/*
 * Decompiled with CFR 0.152.
 */
package autodispose2.androidx.lifecycle;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import autodispose2.OutsideScopeException;
import autodispose2.androidx.lifecycle.LifecycleEventsObservable;
import autodispose2.lifecycle.CorrespondingEventsFunction;
import autodispose2.lifecycle.LifecycleEndedException;
import autodispose2.lifecycle.LifecycleScopeProvider;
import autodispose2.lifecycle.LifecycleScopes;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Observable;

public final class AndroidLifecycleScopeProvider
implements LifecycleScopeProvider<Lifecycle.Event> {
    private static final CorrespondingEventsFunction<Lifecycle.Event> DEFAULT_CORRESPONDING_EVENTS = lastEvent -> {
        switch (lastEvent) {
            case ON_CREATE: {
                return Lifecycle.Event.ON_DESTROY;
            }
            case ON_START: {
                return Lifecycle.Event.ON_STOP;
            }
            case ON_RESUME: {
                return Lifecycle.Event.ON_PAUSE;
            }
            case ON_PAUSE: {
                return Lifecycle.Event.ON_STOP;
            }
        }
        throw new LifecycleEndedException("Lifecycle has ended! Last event was " + lastEvent);
    };
    private final CorrespondingEventsFunction<Lifecycle.Event> boundaryResolver;
    private final LifecycleEventsObservable lifecycleObservable;

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle());
    }

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner, Lifecycle.Event untilEvent) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle(), untilEvent);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle) {
        return AndroidLifecycleScopeProvider.from(lifecycle, DEFAULT_CORRESPONDING_EVENTS);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle, Lifecycle.Event untilEvent) {
        return AndroidLifecycleScopeProvider.from(lifecycle, (CorrespondingEventsFunction<Lifecycle.Event>)new UntilEventFunction(untilEvent));
    }

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner, CorrespondingEventsFunction<Lifecycle.Event> boundaryResolver) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle(), boundaryResolver);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle, CorrespondingEventsFunction<Lifecycle.Event> boundaryResolver) {
        return new AndroidLifecycleScopeProvider(lifecycle, boundaryResolver);
    }

    private AndroidLifecycleScopeProvider(Lifecycle lifecycle, CorrespondingEventsFunction<Lifecycle.Event> boundaryResolver) {
        this.lifecycleObservable = new LifecycleEventsObservable(lifecycle);
        this.boundaryResolver = boundaryResolver;
    }

    public Observable<Lifecycle.Event> lifecycle() {
        return this.lifecycleObservable;
    }

    public CorrespondingEventsFunction<Lifecycle.Event> correspondingEvents() {
        return this.boundaryResolver;
    }

    public Lifecycle.Event peekLifecycle() {
        this.lifecycleObservable.backfillEvents();
        return this.lifecycleObservable.getValue();
    }

    public CompletableSource requestScope() {
        return LifecycleScopes.resolveScopeFromLifecycle((LifecycleScopeProvider)this);
    }

    private static class UntilEventFunction
    implements CorrespondingEventsFunction<Lifecycle.Event> {
        private final Lifecycle.Event untilEvent;

        UntilEventFunction(Lifecycle.Event untilEvent) {
            this.untilEvent = untilEvent;
        }

        public Lifecycle.Event apply(Lifecycle.Event event) throws OutsideScopeException {
            return this.untilEvent;
        }
    }
}

