/*
 * Decompiled with CFR 0.152.
 */
package autodispose2.androidx.lifecycle;

import androidx.annotation.RestrictTo;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import autodispose2.android.internal.AutoDisposeAndroidUtil;
import autodispose2.android.internal.MainThreadDisposable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class LifecycleEventsObservable
extends Observable<Lifecycle.Event> {
    private final Lifecycle lifecycle;
    private final BehaviorSubject<Lifecycle.Event> eventsObservable = BehaviorSubject.create();

    LifecycleEventsObservable(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    Lifecycle.Event getValue() {
        return (Lifecycle.Event)this.eventsObservable.getValue();
    }

    void backfillEvents() {
        Lifecycle.Event correspondingEvent;
        switch (this.lifecycle.getCurrentState()) {
            case INITIALIZED: {
                correspondingEvent = Lifecycle.Event.ON_CREATE;
                break;
            }
            case CREATED: {
                correspondingEvent = Lifecycle.Event.ON_START;
                break;
            }
            case STARTED: 
            case RESUMED: {
                correspondingEvent = Lifecycle.Event.ON_RESUME;
                break;
            }
            default: {
                correspondingEvent = Lifecycle.Event.ON_DESTROY;
            }
        }
        this.eventsObservable.onNext((Object)correspondingEvent);
    }

    protected void subscribeActual(Observer<? super Lifecycle.Event> observer) {
        AutoDisposeLifecycleObserver lifecycleObserver = new AutoDisposeLifecycleObserver(this.lifecycle, observer, this.eventsObservable);
        observer.onSubscribe((Disposable)lifecycleObserver);
        if (!AutoDisposeAndroidUtil.isMainThread()) {
            observer.onError((Throwable)new IllegalStateException("Lifecycles can only be bound to on the main thread!"));
            return;
        }
        this.lifecycle.addObserver((LifecycleObserver)lifecycleObserver);
        if (lifecycleObserver.isDisposed()) {
            this.lifecycle.removeObserver((LifecycleObserver)lifecycleObserver);
        }
    }

    static final class AutoDisposeLifecycleObserver
    extends MainThreadDisposable
    implements LifecycleObserver {
        private final Lifecycle lifecycle;
        private final Observer<? super Lifecycle.Event> observer;
        private final BehaviorSubject<Lifecycle.Event> eventsObservable;

        AutoDisposeLifecycleObserver(Lifecycle lifecycle, Observer<? super Lifecycle.Event> observer, BehaviorSubject<Lifecycle.Event> eventsObservable) {
            this.lifecycle = lifecycle;
            this.observer = observer;
            this.eventsObservable = eventsObservable;
        }

        protected void onDispose() {
            this.lifecycle.removeObserver((LifecycleObserver)this);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
        void onStateChange(LifecycleOwner owner, Lifecycle.Event event) {
            if (!this.isDisposed()) {
                if (event != Lifecycle.Event.ON_CREATE || this.eventsObservable.getValue() != event) {
                    this.eventsObservable.onNext((Object)event);
                }
                this.observer.onNext((Object)event);
            }
        }
    }
}

