/*
 * Decompiled with CFR 0.152.
 */
package autodispose2.lint;

import autodispose2.lint.AutoDisposeDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UImplicitCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationMethod;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0002,-B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J:\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0018H\u0002J:\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0018H\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J:\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00122\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0018H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020$0#0\u0005H\u0016J\u001a\u0010%\u001a\u00020\f2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020$H\u0002J\u0018\u0010*\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010+\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lautodispose2/lint/AutoDisposeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "appliedMethodNames", "", "", "appliedScopes", "", "ktExtensionMethodToPackageMap", "", "lenient", "", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "callExpressionChecker", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "isInScope", "Lkotlin/Function2;", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "callableReferenceChecker", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "containingClassScopeChecker", "evaluator", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "evaluateMethodCall", "getApplicableMethodNames", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "isCapturedTypeAllowed", "returnType", "Lcom/intellij/psi/PsiType;", "isExpressionValueUnused", "element", "isKotlinExtension", "isReactiveType", "Companion", "SubscribeCallVisitor", "autodispose-lint"})
@SourceDebugExtension(value={"SMAP\nAutoDisposeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoDisposeDetector.kt\nautodispose2/lint/AutoDisposeDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,478:1\n1#2:479\n1851#3:480\n1852#3:488\n1743#3,3:489\n1743#3,3:492\n1743#3,3:495\n357#4,7:481\n*S KotlinDebug\n*F\n+ 1 AutoDisposeDetector.kt\nautodispose2/lint/AutoDisposeDetector\n*L\n157#1:480\n157#1:488\n287#1:489,3\n294#1:492,3\n298#1:495,3\n161#1:481,7\n*E\n"})
public final class AutoDisposeDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<String> appliedScopes = DEFAULT_SCOPES;
    @NotNull
    private Map<String, ? extends Set<String>> ktExtensionMethodToPackageMap = MapsKt.emptyMap();
    @NotNull
    private List<String> appliedMethodNames = CollectionsKt.toList((Iterable)REACTIVE_SUBSCRIBE_METHOD_NAMES);
    private boolean lenient;
    @NotNull
    public static final String LINT_DESCRIPTION = "Missing Disposable handling: Apply AutoDispose or cache the Disposable instance manually and enable lenient mode.";
    @NotNull
    private static final Issue ISSUE;
    @NotNull
    private static final String OBSERVABLE = "io.reactivex.rxjava3.core.Observable";
    @NotNull
    private static final String FLOWABLE = "io.reactivex.rxjava3.core.Flowable";
    @NotNull
    private static final String PARALLEL_FLOWABLE = "io.reactivex.rxjava3.core.parallel.ParallelFlowable";
    @NotNull
    private static final String SINGLE = "io.reactivex.rxjava3.core.Single";
    @NotNull
    private static final String MAYBE = "io.reactivex.rxjava3.core.Maybe";
    @NotNull
    private static final String COMPLETABLE = "io.reactivex.rxjava3.core.Completable";
    @NotNull
    private static final String KOTLIN_EXTENSIONS = "autodispose2.KotlinExtensions";
    @NotNull
    private static final Set<String> DEFAULT_SCOPES;
    @NotNull
    private static final Set<String> REACTIVE_TYPES;
    @NotNull
    private static final Set<String> REACTIVE_SUBSCRIBE_METHOD_NAMES;
    @NotNull
    public static final String PROPERTY_FILE = "gradle.properties";

    public void beforeCheckRootProject(@NotNull Context context) {
        Object v1;
        Properties props;
        Map ktExtensionMethodToPackageMap;
        Set scopes;
        boolean overrideScopes;
        block10: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            overrideScopes = false;
            scopes = new LinkedHashSet();
            ktExtensionMethodToPackageMap = new LinkedHashMap();
            props = new Properties();
            List list = context.getProject().getPropertyFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.project.propertyFiles");
            Iterable iterable = list;
            for (Object t : iterable) {
                File it = (File)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)PROPERTY_FILE)) continue;
                v1 = t;
                break block10;
            }
            v1 = null;
        }
        File file = v1;
        if (file != null) {
            boolean it;
            String[] stringArray;
            String string;
            File file2;
            File $this$beforeCheckRootProject_u24lambda_u246 = file2 = file;
            boolean bl = false;
            StringReader content = new StringReader(((Object)context.getClient().readFile($this$beforeCheckRootProject_u24lambda_u246)).toString());
            props.load(content);
            String string2 = string = props.getProperty("autodispose.typesWithScope");
            if (string2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(CUSTOM_SCOPE_KEY)");
                String scopeProperty = string;
                boolean bl2 = false;
                stringArray = new String[]{","};
                List customScopes2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)scopeProperty, (String[])stringArray, (boolean)false, (int)0, (int)6, null)), (Function1)beforeCheckRootProject.2.1.customScopes.1.INSTANCE), (Function1)beforeCheckRootProject.2.1.customScopes.2.INSTANCE));
                scopes.addAll(customScopes2);
            }
            String string3 = string = props.getProperty("autodispose.kotlinExtensionFunctions");
            if (string3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(KOTLIN_EXTENSION_FUNCTIONS)");
                String ktExtensionProperty = string;
                boolean bl3 = false;
                stringArray = new String[]{","};
                Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)ktExtensionProperty, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    String it2 = (String)element$iv;
                    boolean bl4 = false;
                    String[] stringArray2 = new String[]{"#"};
                    List arr = StringsKt.split$default((CharSequence)it2, (String[])stringArray2, (boolean)false, (int)2, (int)2, null);
                    if (arr.size() < 2) continue;
                    String packageName = (String)arr.get(0);
                    String methodName = (String)arr.get(1);
                    Map $this$getOrPut$iv = ktExtensionMethodToPackageMap;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(methodName);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(methodName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(packageName);
                }
            }
            String string4 = props.getProperty("autodispose.lenient");
            if (string4 != null) {
                it = Boolean.parseBoolean(string4);
                boolean bl6 = false;
                this.lenient = it;
            }
            String string5 = props.getProperty("autodispose.overrideScopes");
            if (string5 != null) {
                it = Boolean.parseBoolean(string5);
                boolean bl7 = false;
                overrideScopes = it;
            }
        }
        if (!overrideScopes) {
            scopes.addAll((Collection)DEFAULT_SCOPES);
        }
        this.appliedScopes = scopes;
        this.ktExtensionMethodToPackageMap = ktExtensionMethodToPackageMap;
        this.appliedMethodNames = CollectionsKt.toList((Iterable)SetsKt.plus(REACTIVE_SUBSCRIBE_METHOD_NAMES, (Iterable)ktExtensionMethodToPackageMap.keySet()));
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return this.appliedMethodNames;
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ AutoDisposeDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    PsiElement psiElement = node.resolve();
                    if (psiElement == null) break block1;
                    PsiElement psiElement2 = psiElement;
                    AutoDisposeDetector autoDisposeDetector = this.this$0;
                    JavaContext javaContext = this.$context;
                    PsiElement method = psiElement2;
                    boolean bl = false;
                    if (method instanceof PsiMethod) {
                        AutoDisposeDetector.access$callableReferenceChecker(autoDisposeDetector, javaContext, node, (PsiMethod)method, (Function2)new Function2<JavaEvaluator, UCallExpression, Boolean>((Object)((Object)autoDisposeDetector)){

                            @NotNull
                            public final Boolean invoke(@NotNull JavaEvaluator p0, @NotNull UCallExpression p1) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                return AutoDisposeDetector.access$containingClassScopeChecker((AutoDisposeDetector)((Object)this.receiver), p0, p1);
                            }
                        });
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull UCallExpression node) {
                block1: {
                    PsiMethod method;
                    AutoDisposeDetector autoDisposeDetector;
                    JavaContext javaContext;
                    block2: {
                        void $this$filterIsInstanceTo$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        PsiMethod psiMethod = node.resolve();
                        if (psiMethod == null) break block1;
                        PsiMethod psiMethod2 = psiMethod;
                        javaContext = this.$context;
                        autoDisposeDetector = this.this$0;
                        method = psiMethod2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)method.getName(), (Object)"withScope")) break block2;
                        PsiClass psiClass = method.getContainingClass();
                        if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"autodispose2.KotlinExtensions")) break block2;
                        List args = node.getValueArguments();
                        Iterable $this$filterIsInstance$iv = args;
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof ULambdaExpression)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        ULambdaExpression uLambdaExpression = (ULambdaExpression)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                        if (uLambdaExpression == null) break block1;
                        ULambdaExpression contextArg = uLambdaExpression;
                        UExpression body = contextArg.getBody();
                        SubscribeCallVisitor visitor2 = new SubscribeCallVisitor(javaContext, (Function3<? super JavaContext, ? super UCallExpression, ? super PsiMethod, Unit>)((Function3)new Function3<JavaContext, UCallExpression, PsiMethod, Unit>(autoDisposeDetector){
                            final /* synthetic */ AutoDisposeDetector this$0;
                            {
                                this.this$0 = $receiver;
                                super(3);
                            }

                            public final void invoke(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod calledMethod) {
                                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                Intrinsics.checkNotNullParameter((Object)calledMethod, (String)"calledMethod");
                                AutoDisposeDetector.access$callExpressionChecker(this.this$0, context, node, calledMethod, createUastHandler.visitCallExpression.1.visitor.1.INSTANCE);
                            }
                        }), (Function3<? super JavaContext, ? super UCallableReferenceExpression, ? super PsiMethod, Unit>)((Function3)new Function3<JavaContext, UCallableReferenceExpression, PsiMethod, Unit>(autoDisposeDetector){
                            final /* synthetic */ AutoDisposeDetector this$0;
                            {
                                this.this$0 = $receiver;
                                super(3);
                            }

                            public final void invoke(@NotNull JavaContext context, @NotNull UCallableReferenceExpression node, @NotNull PsiMethod calledMethod) {
                                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                Intrinsics.checkNotNullParameter((Object)calledMethod, (String)"calledMethod");
                                AutoDisposeDetector.access$callableReferenceChecker(this.this$0, context, node, calledMethod, createUastHandler.visitCallExpression.1.visitor.1.INSTANCE);
                            }
                        }));
                        body.accept((UastVisitor)visitor2);
                        break block1;
                    }
                    AutoDisposeDetector.access$callExpressionChecker(autoDisposeDetector, javaContext, node, method, (Function2)new Function2<JavaEvaluator, UCallExpression, Boolean>((Object)((Object)autoDisposeDetector)){

                        @NotNull
                        public final Boolean invoke(@NotNull JavaEvaluator p0, @NotNull UCallExpression p1) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return AutoDisposeDetector.access$containingClassScopeChecker((AutoDisposeDetector)((Object)this.receiver), p0, p1);
                        }
                    });
                }
            }
        };
    }

    private final void callExpressionChecker(JavaContext context, UCallExpression node, PsiMethod method, Function2<? super JavaEvaluator, ? super UCallExpression, Boolean> isInScope) {
        this.evaluateMethodCall(node, method, context, isInScope);
    }

    private final void callableReferenceChecker(JavaContext context, UCallableReferenceExpression node, PsiMethod method, Function2<? super JavaEvaluator, ? super UCallExpression, Boolean> isInScope) {
        if (node.getUastParent() != null && node.getUastParent() instanceof UCallExpression) {
            UElement uElement = node.getUastParent();
            Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            this.evaluateMethodCall((UCallExpression)uElement, method, context, isInScope);
        }
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallExpression.class, UCallableReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean containingClassScopeChecker(JavaEvaluator evaluator, UCallExpression node) {
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
        if (uClass != null) {
            boolean bl;
            block4: {
                UClass callingClass = uClass;
                boolean bl2 = false;
                Iterable $this$any$iv = this.appliedScopes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!evaluator.inheritsFrom((PsiClass)callingClass, it, false)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReactiveType(JavaEvaluator evaluator, PsiMethod method) {
        String it;
        if (!REACTIVE_SUBSCRIBE_METHOD_NAMES.contains(method.getName())) return false;
        Iterable $this$any$iv = REACTIVE_TYPES;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!evaluator.isMemberInClass((PsiMember)method, it));
        return true;
    }

    private final boolean isKotlinExtension(JavaEvaluator evaluator, PsiMethod method) {
        boolean bl;
        block5: {
            Set<String> set = this.ktExtensionMethodToPackageMap.get(method.getName());
            if (set != null) {
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!evaluator.isMemberInClass((PsiMember)method, it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCapturedTypeAllowed(PsiType returnType, JavaEvaluator evaluator) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)returnType);
        if (psiClass != null) {
            PsiClass it = psiClass;
            boolean bl = false;
            return evaluator.inheritsFrom(it, "io.reactivex.rxjava3.disposables.Disposable", false);
        }
        return false;
    }

    private final void evaluateMethodCall(UCallExpression node, PsiMethod method, JavaContext context, Function2<? super JavaEvaluator, ? super UCallExpression, Boolean> isInScope) {
        boolean shouldReport;
        if (!this.getApplicableMethodNames().contains(method.getName())) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        boolean bl = shouldReport = (this.isReactiveType(evaluator, method) || this.isKotlinExtension(evaluator, method)) && (Boolean)isInScope.invoke((Object)evaluator, (Object)node) != false;
        if (shouldReport) {
            if (!this.lenient) {
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)LINT_DESCRIPTION, null, (int)16, null);
            } else {
                boolean isUnusedReturnValue = this.isExpressionValueUnused((UElement)node);
                if (isUnusedReturnValue || !this.isCapturedTypeAllowed(node.getReturnType(), evaluator)) {
                    JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)LINT_DESCRIPTION, null, (int)16, null);
                }
            }
        }
    }

    private final boolean isExpressionValueUnused(UElement element) {
        if (element instanceof UParenthesizedExpression) {
            return this.isExpressionValueUnused((UElement)((UParenthesizedExpression)element).getExpression());
        }
        UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)false);
        if (uExpression == null) {
            return true;
        }
        UElement prev = (UElement)uExpression;
        if (prev instanceof UImplicitCallExpression) {
            prev = (UElement)((UImplicitCallExpression)prev).getExpression();
        }
        UElement uElement = prev.getUastParent();
        if (uElement == null) {
            return true;
        }
        UElement curr = uElement;
        while (curr instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)curr).getSelector() == prev || curr instanceof UParenthesizedExpression) {
            prev = curr;
            if (curr.getUastParent() != null) continue;
            return true;
        }
        if (curr instanceof UBlockExpression) {
            if (curr.getSourcePsi() instanceof PsiSynchronizedStatement) {
                return false;
            }
            UElement block = curr;
            UElement expression = prev;
            int index = CollectionsKt.indexOf((List)((UBlockExpression)block).getExpressions(), (Object)expression);
            if (index == -1) {
                return true;
            }
            if (index < ((UBlockExpression)block).getExpressions().size() - 1) {
                return true;
            }
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
            if (parent instanceof ULambdaExpression && Lint.isKotlin((PsiElement)curr.getSourcePsi())) {
                String expressionType;
                PsiType psiType = ((ULambdaExpression)parent).getExpressionType();
                String string = expressionType = psiType != null ? psiType.getCanonicalText() : null;
                return expressionType != null && StringsKt.startsWith$default((String)expressionType, (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)expressionType, (String)"kotlin.Unit>", (boolean)false, (int)2, null);
            }
            if (Lint.isJava((PsiElement)curr.getSourcePsi())) {
                return true;
            }
            if (parent == null) {
                return true;
            }
            if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                return true;
            }
            return this.isExpressionValueUnused(parent);
        }
        if (curr instanceof UMethod && ((UMethod)curr).isConstructor()) {
            return true;
        }
        if (curr instanceof UIfExpression) {
            if (((UIfExpression)curr).getCondition() == prev) {
                return false;
            }
            if (((UIfExpression)curr).isTernary()) {
                return false;
            }
            UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
            if (uElement2 == null) {
                return true;
            }
            UElement parent = uElement2;
            if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                return true;
            }
            return this.isExpressionValueUnused(curr);
        }
        if (curr instanceof UMethod || curr instanceof UClassInitializer) {
            return !(curr instanceof UAnnotationMethod);
        }
        if (curr instanceof UYieldExpression) {
            UElement uElement3 = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
            UElement p2 = UastUtils.skipParenthesizedExprUp((UElement)(uElement3 != null ? uElement3.getUastParent() : null));
            USwitchClauseExpressionWithBody uSwitchClauseExpressionWithBody = p2 instanceof USwitchClauseExpressionWithBody ? (USwitchClauseExpressionWithBody)p2 : null;
            if (uSwitchClauseExpressionWithBody == null) {
                return false;
            }
            USwitchClauseExpressionWithBody body = uSwitchClauseExpressionWithBody;
            USwitchExpression uSwitchExpression = (USwitchExpression)UastUtils.getParentOfType$default((UElement)((UElement)body), USwitchExpression.class, (boolean)false, (int)2, null);
            if (uSwitchExpression == null) {
                return true;
            }
            USwitchExpression uSwitchExpression2 = uSwitchExpression;
            return this.isExpressionValueUnused((UElement)uSwitchExpression2);
        }
        return false;
    }

    public static final /* synthetic */ void access$callableReferenceChecker(AutoDisposeDetector $this, JavaContext context, UCallableReferenceExpression node, PsiMethod method, Function2 isInScope) {
        $this.callableReferenceChecker(context, node, method, (Function2<? super JavaEvaluator, ? super UCallExpression, Boolean>)isInScope);
    }

    public static final /* synthetic */ boolean access$containingClassScopeChecker(AutoDisposeDetector $this, JavaEvaluator evaluator, UCallExpression node) {
        return $this.containingClassScopeChecker(evaluator, node);
    }

    public static final /* synthetic */ void access$callExpressionChecker(AutoDisposeDetector $this, JavaContext context, UCallExpression node, PsiMethod method, Function2 isInScope) {
        $this.callExpressionChecker(context, node, method, (Function2<? super JavaEvaluator, ? super UCallExpression, Boolean>)isInScope);
    }

    static {
        Object[] objectArray = new EnumSet[]{EnumSet.of((Enum)Scope.JAVA_FILE), EnumSet.of((Enum)Scope.TEST_SOURCES)};
        ISSUE = Issue.Companion.create("AutoDispose", LINT_DESCRIPTION, "You're subscribing to an observable but not handling its subscription. This can result in memory leaks. You can avoid memory leaks by appending `.as(autoDisposable(this))` before you subscribe or cache the Disposable instance manually and enable lenient mode. More: https://github.com/uber/AutoDispose/wiki/Lint-Check", Category.CORRECTNESS, 10, Severity.ERROR, new Implementation(AutoDisposeDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), (EnumSet[])objectArray));
        objectArray = new String[]{"androidx.lifecycle.LifecycleOwner", "autodispose2.ScopeProvider", "android.app.Activity", "android.app.Fragment"};
        DEFAULT_SCOPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{OBSERVABLE, FLOWABLE, PARALLEL_FLOWABLE, SINGLE, MAYBE, COMPLETABLE};
        REACTIVE_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"subscribe", "subscribeWith"};
        REACTIVE_SUBSCRIBE_METHOD_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lautodispose2/lint/AutoDisposeDetector$Companion;", "", "()V", "COMPLETABLE", "", "DEFAULT_SCOPES", "", "FLOWABLE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE$autodispose_lint", "()Lcom/android/tools/lint/detector/api/Issue;", "KOTLIN_EXTENSIONS", "LINT_DESCRIPTION", "MAYBE", "OBSERVABLE", "PARALLEL_FLOWABLE", "PROPERTY_FILE", "REACTIVE_SUBSCRIBE_METHOD_NAMES", "REACTIVE_TYPES", "SINGLE", "autodispose-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE$autodispose_lint() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u0012\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lautodispose2/lint/AutoDisposeDetector$SubscribeCallVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "callExpressionChecker", "Lkotlin/Function3;", "Lorg/jetbrains/uast/UCallExpression;", "Lcom/intellij/psi/PsiMethod;", "", "callableReferenceChecker", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "(Lcom/android/tools/lint/detector/api/JavaContext;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;)V", "afterVisitCallableReferenceExpression", "node", "visitCallExpression", "", "autodispose-lint"})
    @SourceDebugExtension(value={"SMAP\nAutoDisposeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoDisposeDetector.kt\nautodispose2/lint/AutoDisposeDetector$SubscribeCallVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,478:1\n1#2:479\n*E\n"})
    private static final class SubscribeCallVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final JavaContext context;
        @NotNull
        private final Function3<JavaContext, UCallExpression, PsiMethod, Unit> callExpressionChecker;
        @NotNull
        private final Function3<JavaContext, UCallableReferenceExpression, PsiMethod, Unit> callableReferenceChecker;

        public SubscribeCallVisitor(@NotNull JavaContext context, @NotNull Function3<? super JavaContext, ? super UCallExpression, ? super PsiMethod, Unit> callExpressionChecker, @NotNull Function3<? super JavaContext, ? super UCallableReferenceExpression, ? super PsiMethod, Unit> callableReferenceChecker) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(callExpressionChecker, (String)"callExpressionChecker");
            Intrinsics.checkNotNullParameter(callableReferenceChecker, (String)"callableReferenceChecker");
            this.context = context;
            this.callExpressionChecker = callExpressionChecker;
            this.callableReferenceChecker = callableReferenceChecker;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) break block0;
                PsiMethod it = psiMethod;
                boolean bl = false;
                this.callExpressionChecker.invoke((Object)this.context, (Object)node, (Object)it);
            }
            return super.visitCallExpression(node);
        }

        public void afterVisitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement psiElement = node.resolve();
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                if (it instanceof PsiMethod) {
                    this.callableReferenceChecker.invoke((Object)this.context, (Object)node, (Object)it);
                }
            }
            super.afterVisitCallableReferenceExpression(node);
        }
    }
}

