/*
 * Decompiled with CFR 0.152.
 */
package autodispose2;

import autodispose2.AutoDisposableHelper;
import autodispose2.AutoDisposeUtil;
import autodispose2.AutoSubscriptionHelper;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.ProtocolViolationException;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

final class AutoDisposeEndConsumerHelper {
    private AutoDisposeEndConsumerHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static boolean setOnce(AtomicReference<Disposable> upstream, Disposable next, Class<?> observer) {
        AutoDisposeUtil.checkNotNull(next, "next is null");
        if (!upstream.compareAndSet(null, next)) {
            next.dispose();
            if (upstream.get() != AutoDisposableHelper.DISPOSED) {
                AutoDisposeEndConsumerHelper.reportDoubleSubscription(observer);
            }
            return false;
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Subscription> upstream, Subscription next, Class<?> subscriber) {
        AutoDisposeUtil.checkNotNull(next, "next is null");
        if (!upstream.compareAndSet(null, next)) {
            next.cancel();
            if (upstream.get() != AutoSubscriptionHelper.CANCELLED) {
                AutoDisposeEndConsumerHelper.reportDoubleSubscription(subscriber);
            }
            return false;
        }
        return true;
    }

    public static String composeMessage(String consumer) {
        return "It is not allowed to subscribe with a(n) " + consumer + " multiple times. Please create a fresh instance of " + consumer + " and subscribe that to the target source instead.";
    }

    public static void reportDoubleSubscription(Class<?> consumer) {
        RxJavaPlugins.onError((Throwable)new ProtocolViolationException(AutoDisposeEndConsumerHelper.composeMessage(consumer.getName())));
    }
}

