/*
 * Decompiled with CFR 0.152.
 */
package autodispose2;

import autodispose2.AutoDisposableHelper;
import autodispose2.AutoDisposeEndConsumerHelper;
import autodispose2.observers.AutoDisposingCompletableObserver;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.observers.DisposableCompletableObserver;
import java.util.concurrent.atomic.AtomicReference;

final class AutoDisposingCompletableObserverImpl
implements AutoDisposingCompletableObserver {
    final AtomicReference<Disposable> mainDisposable = new AtomicReference();
    final AtomicReference<Disposable> scopeDisposable = new AtomicReference();
    private final CompletableSource scope;
    private final CompletableObserver delegate;

    AutoDisposingCompletableObserverImpl(CompletableSource scope, CompletableObserver delegate) {
        this.scope = scope;
        this.delegate = delegate;
    }

    @Override
    public CompletableObserver delegateObserver() {
        return this.delegate;
    }

    public void onSubscribe(Disposable d) {
        DisposableCompletableObserver o = new DisposableCompletableObserver(){

            public void onError(Throwable e) {
                AutoDisposingCompletableObserverImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposingCompletableObserverImpl.this.onError(e);
            }

            public void onComplete() {
                AutoDisposingCompletableObserverImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposableHelper.dispose(AutoDisposingCompletableObserverImpl.this.mainDisposable);
            }
        };
        if (AutoDisposeEndConsumerHelper.setOnce(this.scopeDisposable, (Disposable)o, this.getClass())) {
            this.delegate.onSubscribe((Disposable)this);
            this.scope.subscribe((CompletableObserver)o);
            AutoDisposeEndConsumerHelper.setOnce(this.mainDisposable, d, this.getClass());
        }
    }

    public boolean isDisposed() {
        return this.mainDisposable.get() == AutoDisposableHelper.DISPOSED;
    }

    public void dispose() {
        AutoDisposableHelper.dispose(this.scopeDisposable);
        AutoDisposableHelper.dispose(this.mainDisposable);
    }

    public void onComplete() {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            this.delegate.onComplete();
        }
    }

    public void onError(Throwable e) {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            this.delegate.onError(e);
        }
    }
}

