/*
 * Decompiled with CFR 0.152.
 */
package autodispose2;

import autodispose2.AutoDisposableHelper;
import autodispose2.AutoDisposeEndConsumerHelper;
import autodispose2.observers.AutoDisposingMaybeObserver;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.observers.DisposableCompletableObserver;
import java.util.concurrent.atomic.AtomicReference;

final class AutoDisposingMaybeObserverImpl<T>
implements AutoDisposingMaybeObserver<T> {
    final AtomicReference<Disposable> mainDisposable = new AtomicReference();
    final AtomicReference<Disposable> scopeDisposable = new AtomicReference();
    private final CompletableSource scope;
    private final MaybeObserver<? super T> delegate;

    AutoDisposingMaybeObserverImpl(CompletableSource scope, MaybeObserver<? super T> delegate) {
        this.scope = scope;
        this.delegate = delegate;
    }

    @Override
    public MaybeObserver<? super T> delegateObserver() {
        return this.delegate;
    }

    public void onSubscribe(Disposable d) {
        DisposableCompletableObserver o = new DisposableCompletableObserver(){

            public void onError(Throwable e) {
                AutoDisposingMaybeObserverImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposingMaybeObserverImpl.this.onError(e);
            }

            public void onComplete() {
                AutoDisposingMaybeObserverImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposableHelper.dispose(AutoDisposingMaybeObserverImpl.this.mainDisposable);
            }
        };
        if (AutoDisposeEndConsumerHelper.setOnce(this.scopeDisposable, (Disposable)o, this.getClass())) {
            this.delegate.onSubscribe((Disposable)this);
            this.scope.subscribe((CompletableObserver)o);
            AutoDisposeEndConsumerHelper.setOnce(this.mainDisposable, d, this.getClass());
        }
    }

    public boolean isDisposed() {
        return this.mainDisposable.get() == AutoDisposableHelper.DISPOSED;
    }

    public void dispose() {
        AutoDisposableHelper.dispose(this.scopeDisposable);
        AutoDisposableHelper.dispose(this.mainDisposable);
    }

    public void onSuccess(T value) {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            this.delegate.onSuccess(value);
        }
    }

    public void onError(Throwable e) {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            this.delegate.onError(e);
        }
    }

    public void onComplete() {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            this.delegate.onComplete();
        }
    }
}

