/*
 * Decompiled with CFR 0.152.
 */
package autodispose2;

import autodispose2.AutoDisposeBackpressureHelper;
import autodispose2.AutoDisposeUtil;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

enum AutoSubscriptionHelper implements Subscription
{
    CANCELLED;


    public void request(long n) {
    }

    public void cancel() {
    }

    static boolean validate(@Nullable Subscription current, Subscription next) {
        if (next == null) {
            RxJavaPlugins.onError((Throwable)new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.cancel();
            AutoSubscriptionHelper.reportSubscriptionSet();
            return false;
        }
        return true;
    }

    static void reportSubscriptionSet() {
        RxJavaPlugins.onError((Throwable)new IllegalStateException("Subscription already set!"));
    }

    static boolean validate(long n) {
        if (n <= 0L) {
            RxJavaPlugins.onError((Throwable)new IllegalArgumentException("n > 0 required but it was " + n));
            return false;
        }
        return true;
    }

    static void reportMoreProduced(long n) {
        RxJavaPlugins.onError((Throwable)new IllegalStateException("More produced than requested: " + n));
    }

    static boolean isCancelled(Subscription s) {
        return s == CANCELLED;
    }

    static boolean set(AtomicReference<Subscription> field, @Nullable Subscription s) {
        Subscription current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s != null) {
                s.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s));
        if (current != null) {
            current.cancel();
        }
        return true;
    }

    static boolean setOnce(AtomicReference<Subscription> field, Subscription s) {
        AutoDisposeUtil.checkNotNull(s, "s is null");
        if (!field.compareAndSet(null, s)) {
            s.cancel();
            if (field.get() != CANCELLED) {
                AutoSubscriptionHelper.reportSubscriptionSet();
            }
            return false;
        }
        return true;
    }

    static boolean setIfNotSet(AtomicReference<Subscription> field, Subscription s) {
        AutoDisposeUtil.checkNotNull(s, "s is null");
        return field.compareAndSet(null, s);
    }

    static boolean replace(AtomicReference<Subscription> field, @Nullable Subscription s) {
        Subscription current;
        do {
            if ((current = field.get()) != CANCELLED) continue;
            if (s != null) {
                s.cancel();
            }
            return false;
        } while (!field.compareAndSet(current, s));
        return true;
    }

    static boolean cancel(AtomicReference<Subscription> field) {
        Subscription current = field.get();
        if (current != CANCELLED && (current = field.getAndSet(CANCELLED)) != CANCELLED) {
            if (current != null) {
                current.cancel();
            }
            return true;
        }
        return false;
    }

    static boolean deferredSetOnce(AtomicReference<Subscription> field, AtomicLong requested, Subscription s) {
        if (AutoSubscriptionHelper.setOnce(field, s)) {
            long r = requested.getAndSet(0L);
            if (r != 0L) {
                s.request(r);
            }
            return true;
        }
        return false;
    }

    static void deferredRequest(AtomicReference<Subscription> field, AtomicLong requested, long n) {
        Subscription s = field.get();
        if (s != null) {
            s.request(n);
        } else if (AutoSubscriptionHelper.validate(n)) {
            long r;
            AutoDisposeBackpressureHelper.add(requested, n);
            s = field.get();
            if (s != null && (r = requested.getAndSet(0L)) != 0L) {
                s.request(r);
            }
        }
    }
}

