/*
 * Decompiled with CFR 0.152.
 */
package autodispose2;

import autodispose2.AtomicThrowable;
import autodispose2.AutoDisposableHelper;
import autodispose2.AutoDisposeEndConsumerHelper;
import autodispose2.HalfSerializer;
import autodispose2.observers.AutoDisposingObserver;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.observers.DisposableCompletableObserver;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class AutoDisposingObserverImpl<@NonNull T>
extends AtomicInteger
implements AutoDisposingObserver<T> {
    final AtomicReference<Disposable> mainDisposable = new AtomicReference();
    final AtomicReference<Disposable> scopeDisposable = new AtomicReference();
    private final AtomicThrowable error = new AtomicThrowable();
    private final CompletableSource scope;
    private final Observer<? super T> delegate;

    AutoDisposingObserverImpl(CompletableSource scope, Observer<? super T> delegate) {
        this.scope = scope;
        this.delegate = delegate;
    }

    @Override
    public Observer<? super T> delegateObserver() {
        return this.delegate;
    }

    public void onSubscribe(Disposable d) {
        DisposableCompletableObserver o = new DisposableCompletableObserver(){

            public void onError(Throwable e) {
                AutoDisposingObserverImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposingObserverImpl.this.onError(e);
            }

            public void onComplete() {
                AutoDisposingObserverImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposableHelper.dispose(AutoDisposingObserverImpl.this.mainDisposable);
            }
        };
        if (AutoDisposeEndConsumerHelper.setOnce(this.scopeDisposable, (Disposable)o, this.getClass())) {
            this.delegate.onSubscribe((Disposable)this);
            this.scope.subscribe((CompletableObserver)o);
            AutoDisposeEndConsumerHelper.setOnce(this.mainDisposable, d, this.getClass());
        }
    }

    public boolean isDisposed() {
        return this.mainDisposable.get() == AutoDisposableHelper.DISPOSED;
    }

    public void dispose() {
        AutoDisposableHelper.dispose(this.scopeDisposable);
        AutoDisposableHelper.dispose(this.mainDisposable);
    }

    public void onNext(T value) {
        if (!this.isDisposed() && HalfSerializer.onNext(this.delegate, value, (AtomicInteger)this, this.error)) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
        }
    }

    public void onError(Throwable e) {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            HalfSerializer.onError(this.delegate, e, (AtomicInteger)this, this.error);
        }
    }

    public void onComplete() {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            HalfSerializer.onComplete(this.delegate, (AtomicInteger)this, this.error);
        }
    }
}

