/*
 * Decompiled with CFR 0.152.
 */
package autodispose2;

import autodispose2.AtomicThrowable;
import autodispose2.AutoDisposableHelper;
import autodispose2.AutoDisposeEndConsumerHelper;
import autodispose2.AutoSubscriptionHelper;
import autodispose2.HalfSerializer;
import autodispose2.observers.AutoDisposingSubscriber;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.observers.DisposableCompletableObserver;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class AutoDisposingSubscriberImpl<@NonNull T>
extends AtomicInteger
implements AutoDisposingSubscriber<T> {
    final AtomicReference<Subscription> mainSubscription = new AtomicReference();
    final AtomicReference<Disposable> scopeDisposable = new AtomicReference();
    private final AtomicThrowable error = new AtomicThrowable();
    private final AtomicReference<Subscription> ref = new AtomicReference();
    private final AtomicLong requested = new AtomicLong();
    private final CompletableSource scope;
    private final Subscriber<? super T> delegate;

    AutoDisposingSubscriberImpl(CompletableSource scope, Subscriber<? super T> delegate) {
        this.scope = scope;
        this.delegate = delegate;
    }

    @Override
    public Subscriber<? super T> delegateSubscriber() {
        return this.delegate;
    }

    public void onSubscribe(Subscription s) {
        DisposableCompletableObserver o = new DisposableCompletableObserver(){

            public void onError(Throwable e) {
                AutoDisposingSubscriberImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposingSubscriberImpl.this.onError(e);
            }

            public void onComplete() {
                AutoDisposingSubscriberImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoSubscriptionHelper.cancel(AutoDisposingSubscriberImpl.this.mainSubscription);
            }
        };
        if (AutoDisposeEndConsumerHelper.setOnce(this.scopeDisposable, (Disposable)o, this.getClass())) {
            this.delegate.onSubscribe((Subscription)this);
            this.scope.subscribe((CompletableObserver)o);
            if (AutoDisposeEndConsumerHelper.setOnce(this.mainSubscription, s, this.getClass())) {
                AutoSubscriptionHelper.deferredSetOnce(this.ref, this.requested, s);
            }
        }
    }

    public void request(long n) {
        AutoSubscriptionHelper.deferredRequest(this.ref, this.requested, n);
    }

    public void cancel() {
        AutoDisposableHelper.dispose(this.scopeDisposable);
        AutoSubscriptionHelper.cancel(this.mainSubscription);
    }

    public boolean isDisposed() {
        return this.mainSubscription.get() == AutoSubscriptionHelper.CANCELLED;
    }

    public void dispose() {
        this.cancel();
    }

    public void onNext(T value) {
        if (!this.isDisposed() && HalfSerializer.onNext(this.delegate, value, (AtomicInteger)this, this.error)) {
            this.mainSubscription.lazySet(AutoSubscriptionHelper.CANCELLED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
        }
    }

    public void onError(Throwable e) {
        if (!this.isDisposed()) {
            this.mainSubscription.lazySet(AutoSubscriptionHelper.CANCELLED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            HalfSerializer.onError(this.delegate, e, (AtomicInteger)this, this.error);
        }
    }

    public void onComplete() {
        if (!this.isDisposed()) {
            this.mainSubscription.lazySet(AutoSubscriptionHelper.CANCELLED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            HalfSerializer.onComplete(this.delegate, (AtomicInteger)this, this.error);
        }
    }
}

