/*
 * Decompiled with CFR 0.152.
 */
package autodispose2;

import autodispose2.AutoDisposableHelper;
import autodispose2.AutoDisposeEndConsumerHelper;
import autodispose2.observers.AutoDisposingSingleObserver;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.observers.DisposableCompletableObserver;
import java.util.concurrent.atomic.AtomicReference;

final class AutoDisposingSingleObserverImpl<@NonNull T>
implements AutoDisposingSingleObserver<T> {
    final AtomicReference<Disposable> mainDisposable = new AtomicReference();
    final AtomicReference<Disposable> scopeDisposable = new AtomicReference();
    private final CompletableSource scope;
    private final SingleObserver<? super T> delegate;

    AutoDisposingSingleObserverImpl(CompletableSource scope, SingleObserver<? super T> delegate) {
        this.scope = scope;
        this.delegate = delegate;
    }

    @Override
    public SingleObserver<? super T> delegateObserver() {
        return this.delegate;
    }

    public void onSubscribe(Disposable d) {
        DisposableCompletableObserver o = new DisposableCompletableObserver(){

            public void onError(Throwable e) {
                AutoDisposingSingleObserverImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposingSingleObserverImpl.this.onError(e);
            }

            public void onComplete() {
                AutoDisposingSingleObserverImpl.this.scopeDisposable.lazySet(AutoDisposableHelper.DISPOSED);
                AutoDisposableHelper.dispose(AutoDisposingSingleObserverImpl.this.mainDisposable);
            }
        };
        if (AutoDisposeEndConsumerHelper.setOnce(this.scopeDisposable, (Disposable)o, this.getClass())) {
            this.delegate.onSubscribe((Disposable)this);
            this.scope.subscribe((CompletableObserver)o);
            AutoDisposeEndConsumerHelper.setOnce(this.mainDisposable, d, this.getClass());
        }
    }

    public boolean isDisposed() {
        return this.mainDisposable.get() == AutoDisposableHelper.DISPOSED;
    }

    public void dispose() {
        AutoDisposableHelper.dispose(this.scopeDisposable);
        AutoDisposableHelper.dispose(this.mainDisposable);
    }

    public void onSuccess(T value) {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            this.delegate.onSuccess(value);
        }
    }

    public void onError(Throwable e) {
        if (!this.isDisposed()) {
            this.mainDisposable.lazySet(AutoDisposableHelper.DISPOSED);
            AutoDisposableHelper.dispose(this.scopeDisposable);
            this.delegate.onError(e);
        }
    }
}

