/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.proto;

import com.google.common.base.Strings;
import com.uber.cadence.ActivityType;
import com.uber.cadence.BadBinaries;
import com.uber.cadence.BadBinaryInfo;
import com.uber.cadence.ClusterReplicationConfiguration;
import com.uber.cadence.Header;
import com.uber.cadence.Memo;
import com.uber.cadence.RetryPolicy;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.StartTimeFilter;
import com.uber.cadence.StickyExecutionAttributes;
import com.uber.cadence.TaskList;
import com.uber.cadence.TaskListMetadata;
import com.uber.cadence.WorkerVersionInfo;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionCloseStatus;
import com.uber.cadence.WorkflowExecutionFilter;
import com.uber.cadence.WorkflowQuery;
import com.uber.cadence.WorkflowQueryResult;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.WorkflowTypeFilter;
import com.uber.cadence.api.v1.Failure;
import com.uber.cadence.api.v1.Payload;
import com.uber.cadence.api.v1.RetryPolicy;
import com.uber.cadence.api.v1.StatusFilter;
import com.uber.cadence.api.v1.WorkflowExecution;
import com.uber.cadence.internal.compatibility.proto.EnumMapper;
import com.uber.cadence.internal.compatibility.proto.Helpers;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TypeMapper {
    TypeMapper() {
    }

    static com.uber.cadence.api.v1.BadBinaryInfo badBinaryInfo(BadBinaryInfo t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.BadBinaryInfo.newBuilder().setReason(t.getReason()).setOperator(t.getOperator()).setCreatedTime(Helpers.unixNanoToTime(t.getCreatedTimeNano())).build();
    }

    static Payload payload(byte[] data) {
        if (data == null) {
            return Payload.newBuilder().build();
        }
        return Payload.newBuilder().setData(Helpers.arrayToByteString(data)).build();
    }

    static Failure failure(String reason, byte[] details) {
        if (reason == null) {
            return Failure.newBuilder().build();
        }
        return Failure.newBuilder().setReason(reason).setDetails(Helpers.arrayToByteString(details)).build();
    }

    static com.uber.cadence.api.v1.WorkflowExecution workflowExecution(WorkflowExecution t) {
        if (t == null) {
            return com.uber.cadence.api.v1.WorkflowExecution.newBuilder().build();
        }
        if (t.getWorkflowId() == null && t.getRunId() == null) {
            return com.uber.cadence.api.v1.WorkflowExecution.newBuilder().build();
        }
        WorkflowExecution.Builder builder = com.uber.cadence.api.v1.WorkflowExecution.newBuilder().setWorkflowId(t.getWorkflowId());
        if (t.getRunId() != null) {
            builder.setRunId(t.getRunId());
        }
        return builder.build();
    }

    static com.uber.cadence.api.v1.WorkflowExecution workflowRunPair(String workflowId, String runId) {
        if (Strings.isNullOrEmpty((String)workflowId) && Strings.isNullOrEmpty((String)runId)) {
            return com.uber.cadence.api.v1.WorkflowExecution.newBuilder().build();
        }
        return com.uber.cadence.api.v1.WorkflowExecution.newBuilder().setWorkflowId(workflowId).setRunId(runId).build();
    }

    static com.uber.cadence.api.v1.ActivityType activityType(ActivityType t) {
        if (t == null) {
            return com.uber.cadence.api.v1.ActivityType.newBuilder().build();
        }
        return com.uber.cadence.api.v1.ActivityType.newBuilder().setName(t.getName()).build();
    }

    static com.uber.cadence.api.v1.WorkflowType workflowType(WorkflowType t) {
        if (t == null) {
            return com.uber.cadence.api.v1.WorkflowType.newBuilder().build();
        }
        return com.uber.cadence.api.v1.WorkflowType.newBuilder().setName(t.getName()).build();
    }

    static com.uber.cadence.api.v1.TaskList taskList(TaskList t) {
        if (t == null) {
            return com.uber.cadence.api.v1.TaskList.newBuilder().build();
        }
        return com.uber.cadence.api.v1.TaskList.newBuilder().setName(t.getName()).setKind(EnumMapper.taskListKind(t.getKind())).build();
    }

    static com.uber.cadence.api.v1.TaskListMetadata taskListMetadata(TaskListMetadata t) {
        if (t == null) {
            return com.uber.cadence.api.v1.TaskListMetadata.newBuilder().build();
        }
        return com.uber.cadence.api.v1.TaskListMetadata.newBuilder().setMaxTasksPerSecond(Helpers.fromDoubleValue(t.getMaxTasksPerSecond())).build();
    }

    static com.uber.cadence.api.v1.RetryPolicy retryPolicy(RetryPolicy t) {
        if (t == null) {
            return null;
        }
        RetryPolicy.Builder builder = com.uber.cadence.api.v1.RetryPolicy.newBuilder().setInitialInterval(Helpers.secondsToDuration(t.getInitialIntervalInSeconds())).setBackoffCoefficient(t.getBackoffCoefficient()).setMaximumInterval(Helpers.secondsToDuration(t.getMaximumIntervalInSeconds())).setMaximumAttempts(t.getMaximumAttempts()).setExpirationInterval(Helpers.secondsToDuration(t.getExpirationIntervalInSeconds()));
        if (t.getNonRetriableErrorReasons() != null) {
            builder.addAllNonRetryableErrorReasons(t.getNonRetriableErrorReasons());
        }
        return builder.build();
    }

    static com.uber.cadence.api.v1.Header header(Header t) {
        if (t == null) {
            return com.uber.cadence.api.v1.Header.newBuilder().build();
        }
        return com.uber.cadence.api.v1.Header.newBuilder().putAllFields(TypeMapper.payloadByteBufferMap(t.getFields())).build();
    }

    static com.uber.cadence.api.v1.Memo memo(Memo t) {
        if (t == null) {
            return com.uber.cadence.api.v1.Memo.newBuilder().build();
        }
        return com.uber.cadence.api.v1.Memo.newBuilder().putAllFields(TypeMapper.payloadByteBufferMap(t.getFields())).build();
    }

    static com.uber.cadence.api.v1.SearchAttributes searchAttributes(SearchAttributes t) {
        if (t == null) {
            return com.uber.cadence.api.v1.SearchAttributes.newBuilder().build();
        }
        return com.uber.cadence.api.v1.SearchAttributes.newBuilder().putAllIndexedFields(TypeMapper.payloadByteBufferMap(t.getIndexedFields())).build();
    }

    static com.uber.cadence.api.v1.BadBinaries badBinaries(BadBinaries t) {
        if (t == null) {
            return com.uber.cadence.api.v1.BadBinaries.newBuilder().build();
        }
        return com.uber.cadence.api.v1.BadBinaries.newBuilder().putAllBinaries(TypeMapper.badBinaryInfoMap(t.getBinaries())).build();
    }

    static com.uber.cadence.api.v1.ClusterReplicationConfiguration clusterReplicationConfiguration(ClusterReplicationConfiguration t) {
        if (t == null) {
            return com.uber.cadence.api.v1.ClusterReplicationConfiguration.newBuilder().build();
        }
        return com.uber.cadence.api.v1.ClusterReplicationConfiguration.newBuilder().setClusterName(t.getClusterName()).build();
    }

    static com.uber.cadence.api.v1.WorkflowQuery workflowQuery(WorkflowQuery t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.WorkflowQuery.newBuilder().setQueryType(t.getQueryType()).setQueryArgs(TypeMapper.payload(t.getQueryArgs())).build();
    }

    static com.uber.cadence.api.v1.WorkflowQueryResult workflowQueryResult(WorkflowQueryResult t) {
        if (t == null) {
            return com.uber.cadence.api.v1.WorkflowQueryResult.newBuilder().build();
        }
        return com.uber.cadence.api.v1.WorkflowQueryResult.newBuilder().setResultType(EnumMapper.queryResultType(t.getResultType())).setAnswer(TypeMapper.payload(t.getAnswer())).setErrorMessage(t.getErrorMessage()).build();
    }

    static com.uber.cadence.api.v1.StickyExecutionAttributes stickyExecutionAttributes(StickyExecutionAttributes t) {
        if (t == null) {
            return com.uber.cadence.api.v1.StickyExecutionAttributes.newBuilder().build();
        }
        return com.uber.cadence.api.v1.StickyExecutionAttributes.newBuilder().setWorkerTaskList(TypeMapper.taskList(t.getWorkerTaskList())).setScheduleToStartTimeout(Helpers.secondsToDuration(t.getScheduleToStartTimeoutSeconds())).build();
    }

    static com.uber.cadence.api.v1.WorkerVersionInfo workerVersionInfo(WorkerVersionInfo t) {
        if (t == null) {
            return com.uber.cadence.api.v1.WorkerVersionInfo.newBuilder().build();
        }
        return com.uber.cadence.api.v1.WorkerVersionInfo.newBuilder().setImpl(t.getImpl()).setFeatureVersion(t.getFeatureVersion()).build();
    }

    static com.uber.cadence.api.v1.StartTimeFilter startTimeFilter(StartTimeFilter t) {
        if (t == null) {
            return null;
        }
        return com.uber.cadence.api.v1.StartTimeFilter.newBuilder().setEarliestTime(Helpers.unixNanoToTime(t.getEarliestTime())).setLatestTime(Helpers.unixNanoToTime(t.getLatestTime())).build();
    }

    static com.uber.cadence.api.v1.WorkflowExecutionFilter workflowExecutionFilter(WorkflowExecutionFilter t) {
        if (t == null) {
            return com.uber.cadence.api.v1.WorkflowExecutionFilter.newBuilder().build();
        }
        return com.uber.cadence.api.v1.WorkflowExecutionFilter.newBuilder().setWorkflowId(t.getWorkflowId()).setRunId(t.getRunId()).build();
    }

    static com.uber.cadence.api.v1.WorkflowTypeFilter workflowTypeFilter(WorkflowTypeFilter t) {
        if (t == null) {
            return com.uber.cadence.api.v1.WorkflowTypeFilter.newBuilder().build();
        }
        return com.uber.cadence.api.v1.WorkflowTypeFilter.newBuilder().setName(t.getName()).build();
    }

    static StatusFilter statusFilter(WorkflowExecutionCloseStatus t) {
        if (t == null) {
            return null;
        }
        return StatusFilter.newBuilder().setStatus(EnumMapper.workflowExecutionCloseStatus(t)).build();
    }

    static Map<String, Payload> payloadByteBufferMap(Map<String, ByteBuffer> t) {
        if (t == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Payload> v = new HashMap<String, Payload>();
        for (String key : t.keySet()) {
            v.put(key, TypeMapper.payload(t.get(key).array()));
        }
        return v;
    }

    static Map<String, com.uber.cadence.api.v1.BadBinaryInfo> badBinaryInfoMap(Map<String, BadBinaryInfo> t) {
        if (t == null) {
            return Collections.emptyMap();
        }
        HashMap<String, com.uber.cadence.api.v1.BadBinaryInfo> v = new HashMap<String, com.uber.cadence.api.v1.BadBinaryInfo>();
        for (String key : t.keySet()) {
            v.put(key, TypeMapper.badBinaryInfo(t.get(key)));
        }
        return v;
    }

    static List<com.uber.cadence.api.v1.ClusterReplicationConfiguration> clusterReplicationConfigurationArray(List<ClusterReplicationConfiguration> t) {
        if (t == null) {
            return Collections.emptyList();
        }
        ArrayList<com.uber.cadence.api.v1.ClusterReplicationConfiguration> v = new ArrayList<com.uber.cadence.api.v1.ClusterReplicationConfiguration>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(TypeMapper.clusterReplicationConfiguration(t.get(i)));
        }
        return v;
    }

    static Map<String, com.uber.cadence.api.v1.WorkflowQueryResult> workflowQueryResultMap(Map<String, WorkflowQueryResult> t) {
        if (t == null) {
            return Collections.emptyMap();
        }
        HashMap<String, com.uber.cadence.api.v1.WorkflowQueryResult> v = new HashMap<String, com.uber.cadence.api.v1.WorkflowQueryResult>();
        for (String key : t.keySet()) {
            v.put(key, TypeMapper.workflowQueryResult(t.get(key)));
        }
        return v;
    }
}

