/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.proto.serviceclient;

import com.google.common.base.Strings;
import com.uber.cadence.api.v1.DomainAPIGrpc;
import com.uber.cadence.api.v1.MetaAPIGrpc;
import com.uber.cadence.api.v1.VisibilityAPIGrpc;
import com.uber.cadence.api.v1.WorkerAPIGrpc;
import com.uber.cadence.api.v1.WorkflowAPIGrpc;
import com.uber.cadence.internal.Version;
import com.uber.cadence.internal.compatibility.proto.serviceclient.IGrpcServiceStubs;
import com.uber.cadence.serviceclient.ClientOptions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Deadline;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GrpcServiceStubs
implements IGrpcServiceStubs {
    private static final Logger log = LoggerFactory.getLogger(GrpcServiceStubs.class);
    private static final Metadata.Key<String> LIBRARY_VERSION_HEADER_KEY = Metadata.Key.of((String)"cadence-client-library-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> FEATURE_VERSION_HEADER_KEY = Metadata.Key.of((String)"cadence-client-feature-version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> CLIENT_IMPL_HEADER_KEY = Metadata.Key.of((String)"cadence-client-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> ISOLATION_GROUP_HEADER_KEY = Metadata.Key.of((String)"cadence-client-isolation-group", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> RPC_SERVICE_NAME_HEADER_KEY = Metadata.Key.of((String)"rpc-service", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> RPC_CALLER_NAME_HEADER_KEY = Metadata.Key.of((String)"rpc-caller", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> RPC_ENCODING_HEADER_KEY = Metadata.Key.of((String)"rpc-encoding", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String CLIENT_IMPL_HEADER_VALUE = "uber-java";
    private final ManagedChannel channel;
    private final boolean shutdownChannel;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final DomainAPIGrpc.DomainAPIBlockingStub domainBlockingStub;
    private final DomainAPIGrpc.DomainAPIFutureStub domainFutureStub;
    private final VisibilityAPIGrpc.VisibilityAPIBlockingStub visibilityBlockingStub;
    private final VisibilityAPIGrpc.VisibilityAPIFutureStub visibilityFutureStub;
    private final WorkerAPIGrpc.WorkerAPIBlockingStub workerBlockingStub;
    private final WorkerAPIGrpc.WorkerAPIFutureStub workerFutureStub;
    private final WorkflowAPIGrpc.WorkflowAPIBlockingStub workflowBlockingStub;
    private final WorkflowAPIGrpc.WorkflowAPIFutureStub workflowFutureStub;
    private final MetaAPIGrpc.MetaAPIBlockingStub metaBlockingStub;
    private final MetaAPIGrpc.MetaAPIFutureStub metaFutureStub;

    GrpcServiceStubs(ClientOptions options) {
        if (options.getGRPCChannel() != null) {
            this.channel = options.getGRPCChannel();
            this.shutdownChannel = false;
        } else {
            this.channel = ManagedChannelBuilder.forAddress((String)options.getHost(), (int)options.getPort()).defaultLoadBalancingPolicy("round_robin").usePlaintext().build();
            this.shutdownChannel = true;
        }
        GrpcDeadlineInterceptor deadlineInterceptor = new GrpcDeadlineInterceptor(options);
        ClientInterceptor tracingInterceptor = this.newTracingInterceptor();
        Metadata headers = new Metadata();
        headers.put(LIBRARY_VERSION_HEADER_KEY, (Object)Version.LIBRARY_VERSION);
        headers.put(FEATURE_VERSION_HEADER_KEY, (Object)"1.5.0");
        headers.put(CLIENT_IMPL_HEADER_KEY, (Object)CLIENT_IMPL_HEADER_VALUE);
        headers.put(RPC_SERVICE_NAME_HEADER_KEY, (Object)options.getServiceName());
        headers.put(RPC_CALLER_NAME_HEADER_KEY, (Object)options.getClientAppName());
        headers.put(RPC_ENCODING_HEADER_KEY, (Object)"proto");
        if (!Strings.isNullOrEmpty((String)options.getIsolationGroup())) {
            headers.put(ISOLATION_GROUP_HEADER_KEY, (Object)options.getIsolationGroup());
        }
        Channel interceptedChannel = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{deadlineInterceptor, MetadataUtils.newAttachHeadersInterceptor((Metadata)headers), this.newOpenTelemetryInterceptor()});
        if (log.isTraceEnabled()) {
            interceptedChannel = ClientInterceptors.intercept((Channel)interceptedChannel, (ClientInterceptor[])new ClientInterceptor[]{tracingInterceptor});
        }
        this.domainBlockingStub = DomainAPIGrpc.newBlockingStub(interceptedChannel);
        this.domainFutureStub = DomainAPIGrpc.newFutureStub(interceptedChannel);
        this.visibilityBlockingStub = VisibilityAPIGrpc.newBlockingStub(interceptedChannel);
        this.visibilityFutureStub = VisibilityAPIGrpc.newFutureStub(interceptedChannel);
        this.workerBlockingStub = WorkerAPIGrpc.newBlockingStub(interceptedChannel);
        this.workerFutureStub = WorkerAPIGrpc.newFutureStub(interceptedChannel);
        this.workflowBlockingStub = WorkflowAPIGrpc.newBlockingStub(interceptedChannel);
        this.workflowFutureStub = WorkflowAPIGrpc.newFutureStub(interceptedChannel);
        this.metaBlockingStub = MetaAPIGrpc.newBlockingStub(interceptedChannel);
        this.metaFutureStub = MetaAPIGrpc.newFutureStub(interceptedChannel);
    }

    private ClientInterceptor newOpenTelemetryInterceptor() {
        return new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        TextMapPropagator propagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
                        TextMapSetter setter = (carrier, key, value) -> {
                            if (carrier != null) {
                                carrier.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
                            }
                        };
                        if (propagator != null) {
                            propagator.inject(Context.current(), (Object)headers, setter);
                        }
                        super.start(responseListener, headers);
                    }
                };
            }
        };
    }

    private ClientInterceptor newTracingInterceptor() {
        return new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    public void sendMessage(ReqT message) {
                        log.trace("Invoking " + method.getFullMethodName() + "with input: " + message);
                        super.sendMessage(message);
                    }

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        ForwardingClientCallListener.SimpleForwardingClientCallListener listener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            public void onMessage(RespT message) {
                                if (method == WorkerAPIGrpc.getPollForDecisionTaskMethod()) {
                                    log.trace("Returned " + method.getFullMethodName());
                                } else {
                                    log.trace("Returned " + method.getFullMethodName() + " with output: " + message);
                                }
                                super.onMessage(message);
                            }
                        };
                        super.start((ClientCall.Listener)listener, headers);
                    }
                };
            }
        };
    }

    @Override
    public DomainAPIGrpc.DomainAPIBlockingStub domainBlockingStub() {
        return this.domainBlockingStub;
    }

    @Override
    public DomainAPIGrpc.DomainAPIFutureStub domainFutureStub() {
        return this.domainFutureStub;
    }

    @Override
    public VisibilityAPIGrpc.VisibilityAPIBlockingStub visibilityBlockingStub() {
        return this.visibilityBlockingStub;
    }

    @Override
    public VisibilityAPIGrpc.VisibilityAPIFutureStub visibilityFutureStub() {
        return this.visibilityFutureStub;
    }

    @Override
    public WorkerAPIGrpc.WorkerAPIBlockingStub workerBlockingStub() {
        return this.workerBlockingStub;
    }

    @Override
    public WorkerAPIGrpc.WorkerAPIFutureStub workerFutureStub() {
        return this.workerFutureStub;
    }

    @Override
    public WorkflowAPIGrpc.WorkflowAPIBlockingStub workflowBlockingStub() {
        return this.workflowBlockingStub;
    }

    @Override
    public MetaAPIGrpc.MetaAPIFutureStub metaFutureStub() {
        return this.metaFutureStub;
    }

    @Override
    public MetaAPIGrpc.MetaAPIBlockingStub metaBlockingStub() {
        return this.metaBlockingStub;
    }

    @Override
    public WorkflowAPIGrpc.WorkflowAPIFutureStub workflowFutureStub() {
        return this.workflowFutureStub;
    }

    @Override
    public void shutdown() {
        this.shutdownRequested.set(true);
        if (this.shutdownChannel) {
            this.channel.shutdown();
        }
    }

    @Override
    public void shutdownNow() {
        this.shutdownRequested.set(true);
        if (this.shutdownChannel) {
            this.channel.shutdownNow();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shutdownChannel) {
            return this.channel.awaitTermination(timeout, unit);
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        if (this.shutdownChannel) {
            return this.channel.isShutdown();
        }
        return this.shutdownRequested.get();
    }

    @Override
    public boolean isTerminated() {
        if (this.shutdownChannel) {
            return this.channel.isTerminated();
        }
        return this.shutdownRequested.get();
    }

    private static class GrpcDeadlineInterceptor
    implements ClientInterceptor {
        private final ClientOptions options;

        public GrpcDeadlineInterceptor(ClientOptions options) {
            this.options = options;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            Deadline deadline = callOptions.getDeadline();
            long duration = deadline == null ? this.options.getRpcTimeoutMillis() : deadline.timeRemaining(TimeUnit.MILLISECONDS);
            if (method == WorkflowAPIGrpc.getGetWorkflowExecutionHistoryMethod()) {
                if (deadline == null) {
                    duration = this.options.getRpcLongPollTimeoutMillis();
                } else {
                    duration = deadline.timeRemaining(TimeUnit.MILLISECONDS);
                    if (duration > this.options.getRpcLongPollTimeoutMillis()) {
                        duration = this.options.getRpcLongPollTimeoutMillis();
                    }
                }
            } else if (method == WorkerAPIGrpc.getPollForDecisionTaskMethod() || method == WorkerAPIGrpc.getPollForActivityTaskMethod()) {
                duration = this.options.getRpcLongPollTimeoutMillis();
            } else if (method == WorkflowAPIGrpc.getQueryWorkflowMethod()) {
                duration = this.options.getRpcQueryTimeoutMillis();
            }
            if (log.isTraceEnabled()) {
                String name = method.getFullMethodName();
                log.trace("TimeoutInterceptor method=" + name + ", timeoutMs=" + duration);
            }
            return next.newCall(method, callOptions.withDeadlineAfter(duration, TimeUnit.MILLISECONDS));
        }
    }
}

