/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.thrift;

import com.uber.cadence.AccessDeniedError;
import com.uber.cadence.CancellationAlreadyRequestedError;
import com.uber.cadence.ClientVersionNotSupportedError;
import com.uber.cadence.DomainAlreadyExistsError;
import com.uber.cadence.DomainNotActiveError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.FeatureNotEnabledError;
import com.uber.cadence.InternalDataInconsistencyError;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.LimitExceededError;
import com.uber.cadence.ServiceBusyError;
import com.uber.cadence.WorkflowExecutionAlreadyCompletedError;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import org.apache.thrift.TException;

public class ErrorMapper {
    public static TException Error(StatusRuntimeException ex) {
        String details = ErrorMapper.getErrorDetails(ex);
        switch (ex.getStatus().getCode()) {
            case PERMISSION_DENIED: {
                return new AccessDeniedError(ex.getMessage());
            }
            case INTERNAL: {
                return new InternalServiceError(ex.getMessage());
            }
            case NOT_FOUND: {
                if ("EntityNotExistsError".equals(details) && ex.getMessage().contains("already completed.")) {
                    return new WorkflowExecutionAlreadyCompletedError(ex.getMessage());
                }
                return new EntityNotExistsError(ex.getMessage());
            }
            case ALREADY_EXISTS: {
                switch (details) {
                    case "CancellationAlreadyRequestedError": {
                        return new CancellationAlreadyRequestedError(ex.getMessage());
                    }
                    case "DomainAlreadyExistsError": {
                        return new DomainAlreadyExistsError(ex.getMessage());
                    }
                    case "WorkflowExecutionAlreadyStartedError": {
                        WorkflowExecutionAlreadyStartedError e = new WorkflowExecutionAlreadyStartedError();
                        e.setMessage(ex.getMessage());
                        return e;
                    }
                }
            }
            case DATA_LOSS: {
                return new InternalDataInconsistencyError(ex.getMessage());
            }
            case FAILED_PRECONDITION: {
                switch (details) {
                    case "ClientVersionNotSupportedError": {
                        return new ClientVersionNotSupportedError();
                    }
                    case "FeatureNotEnabledError": {
                        return new FeatureNotEnabledError();
                    }
                    case "DomainNotActiveError": {
                        DomainNotActiveError e = new DomainNotActiveError();
                        e.setMessage(ex.getMessage());
                        return e;
                    }
                }
            }
            case RESOURCE_EXHAUSTED: {
                switch (details) {
                    case "LimitExceededError": {
                        return new LimitExceededError(ex.getMessage());
                    }
                    case "ServiceBusyError": {
                        return new ServiceBusyError(ex.getMessage());
                    }
                }
            }
            case UNKNOWN: {
                return new TException((Throwable)ex);
            }
        }
        return new TException((Throwable)ex);
    }

    static String getErrorDetails(StatusRuntimeException ex) {
        Metadata trailer = ex.getTrailers();
        Metadata.Key key = Metadata.Key.of((String)"rpc-application-error-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        if (trailer != null && trailer.containsKey(key)) {
            return (String)trailer.get(key);
        }
        return "";
    }
}

