/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.Decision;
import com.uber.cadence.DecisionType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.StartChildWorkflowExecutionDecisionAttributes;
import com.uber.cadence.internal.replay.DecisionId;
import com.uber.cadence.internal.replay.DecisionState;
import com.uber.cadence.internal.replay.DecisionStateMachineBase;

final class ChildWorkflowDecisionStateMachine
extends DecisionStateMachineBase {
    private StartChildWorkflowExecutionDecisionAttributes startAttributes;

    public ChildWorkflowDecisionStateMachine(DecisionId id, StartChildWorkflowExecutionDecisionAttributes startAttributes) {
        super(id);
        this.startAttributes = startAttributes;
    }

    ChildWorkflowDecisionStateMachine(DecisionId id, StartChildWorkflowExecutionDecisionAttributes startAttributes, DecisionState state) {
        super(id, state);
        this.startAttributes = startAttributes;
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createStartChildWorkflowExecutionDecision();
            }
            case CANCELED_AFTER_STARTED: {
                return this.createRequestCancelExternalWorkflowExecutionDecision();
            }
        }
        return null;
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_STARTED: {
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    @Override
    public void handleStartedEvent(HistoryEvent event) {
        this.stateHistory.add("handleStartedEvent");
        switch (this.state) {
            case INITIATED: {
                this.state = DecisionState.STARTED;
                break;
            }
            case CANCELED_AFTER_INITIATED: {
                this.state = DecisionState.CANCELED_AFTER_STARTED;
                break;
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                this.state = DecisionState.STARTED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    @Override
    public boolean cancel(Runnable immediateCancellationCallback) {
        switch (this.state) {
            case STARTED: {
                this.stateHistory.add("cancel");
                this.state = DecisionState.CANCELED_AFTER_STARTED;
                this.stateHistory.add(this.state.toString());
                return true;
            }
        }
        return super.cancel(immediateCancellationCallback);
    }

    @Override
    public void handleCancellationEvent() {
        switch (this.state) {
            case STARTED: {
                this.stateHistory.add("handleCancellationEvent");
                this.state = DecisionState.COMPLETED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationEvent();
            }
        }
    }

    @Override
    public void handleCompletionEvent() {
        switch (this.state) {
            case CANCELED_AFTER_STARTED: 
            case STARTED: {
                this.stateHistory.add("handleCompletionEvent");
                this.state = DecisionState.COMPLETED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCompletionEvent();
            }
        }
    }

    private Decision createRequestCancelExternalWorkflowExecutionDecision() {
        RequestCancelExternalWorkflowExecutionDecisionAttributes tryCancel = new RequestCancelExternalWorkflowExecutionDecisionAttributes();
        tryCancel.setWorkflowId(this.startAttributes.getWorkflowId());
        Decision decision = new Decision();
        decision.setRequestCancelExternalWorkflowExecutionDecisionAttributes(tryCancel);
        decision.setDecisionType(DecisionType.RequestCancelExternalWorkflowExecution);
        return decision;
    }

    private Decision createStartChildWorkflowExecutionDecision() {
        Decision decision = new Decision();
        decision.setStartChildWorkflowExecutionDecisionAttributes(this.startAttributes);
        decision.setDecisionType(DecisionType.StartChildWorkflowExecution);
        return decision;
    }
}

