/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.internal.replay.Decider;
import com.uber.m3.tally.Scope;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class DeciderCache {
    private final Scope metricsScope;
    private LoadingCache<String, Decider> cache;
    private Lock cacheLock = new ReentrantLock();
    private Set<String> inProcessing = new HashSet<String>();

    public DeciderCache(int maxCacheSize, Scope scope) {
        Preconditions.checkArgument((maxCacheSize > 0 ? 1 : 0) != 0, (Object)"Max cache size must be greater than 0");
        this.metricsScope = Objects.requireNonNull(scope);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).removalListener(e -> {
            Decider entry = (Decider)e.getValue();
            if (entry != null) {
                entry.close();
            }
        }).build((CacheLoader)new CacheLoader<String, Decider>(){

            public Decider load(String key) {
                return null;
            }
        });
    }

    public Decider getOrCreate(PollForDecisionTaskResponse decisionTask, Callable<Decider> deciderFunc) throws Exception {
        String runId = decisionTask.getWorkflowExecution().getRunId();
        if (this.isFullHistory(decisionTask)) {
            this.invalidate(runId);
            return deciderFunc.call();
        }
        Decider decider = this.getForProcessing(runId);
        if (decider != null) {
            return decider;
        }
        return deciderFunc.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Decider getForProcessing(String runId) throws Exception {
        this.cacheLock.lock();
        try {
            Decider decider = (Decider)this.cache.get((Object)runId);
            this.inProcessing.add(runId);
            this.metricsScope.counter("cadence-sticky-cache-hit").inc(1L);
            Decider decider2 = decider;
            return decider2;
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            this.metricsScope.counter("cadence-sticky-cache-miss").inc(1L);
            Decider decider = null;
            return decider;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    void markProcessingDone(PollForDecisionTaskResponse decisionTask) {
        String runId = decisionTask.getWorkflowExecution().getRunId();
        this.cacheLock.lock();
        try {
            this.inProcessing.remove(runId);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void addToCache(PollForDecisionTaskResponse decisionTask, Decider decider) {
        String runId = decisionTask.getWorkflowExecution().getRunId();
        this.cache.put((Object)runId, (Object)decider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evictAnyNotInProcessing(String runId) {
        this.cacheLock.lock();
        try {
            this.metricsScope.gauge("cadence-sticky-cache-size").update((double)this.size());
            for (String key : this.cache.asMap().keySet()) {
                if (key.equals(runId) || this.inProcessing.contains(key)) continue;
                this.cache.invalidate((Object)key);
                this.metricsScope.gauge("cadence-sticky-cache-size").update((double)this.size());
                this.metricsScope.counter("cadence-sticky-cache-thread-forced-eviction").inc(1L);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    void invalidate(String runId) {
        this.cacheLock.lock();
        try {
            this.cache.invalidate((Object)runId);
            this.inProcessing.remove(runId);
            this.metricsScope.counter("cadence-sticky-cache-total-forced-eviction").inc(1L);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public long size() {
        return this.cache.size();
    }

    private boolean isFullHistory(PollForDecisionTaskResponse decisionTask) {
        return decisionTask.getHistory() != null && decisionTask.getHistory().getEvents().size() > 0 && decisionTask.getHistory().getEvents().get(0).getEventId() == 1L;
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }
}

