/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.Decision;
import com.uber.cadence.DecisionType;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.internal.replay.DecisionId;
import com.uber.cadence.internal.replay.DecisionState;
import com.uber.cadence.internal.replay.DecisionStateMachineBase;

final class ExternalWorkflowCancellationDecisionStateMachine
extends DecisionStateMachineBase {
    private RequestCancelExternalWorkflowExecutionDecisionAttributes attributes;

    ExternalWorkflowCancellationDecisionStateMachine(DecisionId decisionId, RequestCancelExternalWorkflowExecutionDecisionAttributes attributes) {
        super(decisionId);
        this.attributes = attributes;
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createRequestCancelExternalWorkflowExecutionDecision();
            }
        }
        return null;
    }

    @Override
    public boolean cancel(Runnable immediateCancellationCallback) {
        this.stateHistory.add("cancel");
        this.failStateTransition();
        return false;
    }

    @Override
    public void handleInitiatedEvent(HistoryEvent event) {
        this.stateHistory.add("handleInitiatedEvent");
        switch (this.state) {
            case DECISION_SENT: {
                this.state = DecisionState.INITIATED;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleInitiationFailedEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleStartedEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCompletionEvent() {
        this.stateHistory.add("handleCompletionEvent");
        switch (this.state) {
            case DECISION_SENT: 
            case INITIATED: {
                this.state = DecisionState.COMPLETED;
                break;
            }
            default: {
                this.failStateTransition();
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationInitiatedEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCancellationEvent() {
        throw new UnsupportedOperationException();
    }

    private Decision createRequestCancelExternalWorkflowExecutionDecision() {
        Decision decision = new Decision();
        decision.setRequestCancelExternalWorkflowExecutionDecisionAttributes(this.attributes);
        decision.setDecisionType(DecisionType.RequestCancelExternalWorkflowExecution);
        return decision;
    }
}

