/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.shadowing;

import com.google.common.collect.Lists;
import com.uber.cadence.worker.ShadowingOptions;
import com.uber.cadence.worker.TimeFilter;
import com.uber.cadence.worker.WorkflowStatus;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class QueryBuilder {
    private static final String OR_QUERY = " or ";
    private static final String AND_QUERY = " and ";
    private static final String LEFT_PARENTHESES = "(";
    private static final String RIGHT_PARENTHESES = ")";
    private static final String MISSING_QUERY = "missing";
    private static final String WORKFLOW_TYPE_PLACEHOLDER = "WorkflowType = ";
    private static final String WORKFLOW_STATUS_PLACEHOLDER = "CloseStatus = ";
    private static final String START_TIME_PLACEHOLDER = "StartTime";
    private static final String CLOSE_TIME_PLACEHOLDER = "CloseTime";
    private static final long TIMESTAMP_SCALE = 1000000000L;
    private StringBuffer stringBuffer = new StringBuffer();

    public static QueryBuilder newQueryBuilder() {
        return new QueryBuilder();
    }

    public static QueryBuilder newQueryBuilder(ShadowingOptions options) {
        return new QueryBuilder().setWorkflowTypes(options.getWorkflowTypes()).setWorkflowStartTime(options.getWorkflowStartTimeFilter()).setWorkflowStatuses(options.getWorkflowStatuses());
    }

    public QueryBuilder setWorkflowTypes(Collection<String> workflowTypes) {
        if (workflowTypes == null || workflowTypes.isEmpty()) {
            return this;
        }
        Collection types = workflowTypes.stream().map(wfType -> WORKFLOW_TYPE_PLACEHOLDER + wfType).collect(Collectors.toList());
        String query = String.join((CharSequence)OR_QUERY, types);
        this.appendPartialQuery(query);
        return this;
    }

    public QueryBuilder setWorkflowStatuses(Collection<WorkflowStatus> workflowStatuses) {
        if (workflowStatuses == null || workflowStatuses.isEmpty()) {
            return this;
        }
        ArrayList wfStatuses = Lists.newArrayListWithCapacity((int)workflowStatuses.size());
        block4: for (WorkflowStatus workflowStatus : workflowStatuses) {
            switch (workflowStatus) {
                case OPEN: {
                    wfStatuses.add("CloseTime = missing");
                    continue block4;
                }
                case CLOSED: {
                    wfStatuses.add("CloseTime != missing");
                    continue block4;
                }
            }
            wfStatuses.add("CloseStatus = \"" + (Object)((Object)workflowStatus) + '\"');
        }
        String query = String.join((CharSequence)OR_QUERY, wfStatuses);
        this.appendPartialQuery(query);
        return this;
    }

    public QueryBuilder setWorkflowStartTime(TimeFilter timeFilter) {
        if (timeFilter == null || timeFilter.isEmpty()) {
            return this;
        }
        ArrayList timerFilters = Lists.newArrayListWithCapacity((int)2);
        if (timeFilter.getMinTimestamp() != null) {
            timerFilters.add("StartTime >= " + QueryBuilder.toNanoSeconds(timeFilter.getMinTimestamp()));
        }
        if (timeFilter.getMaxTimestamp() != null) {
            timerFilters.add("StartTime <= " + QueryBuilder.toNanoSeconds(timeFilter.getMaxTimestamp()));
        }
        String query = String.join((CharSequence)AND_QUERY, timerFilters);
        this.appendPartialQuery(query);
        return this;
    }

    public String build() {
        return this.stringBuffer.toString();
    }

    private QueryBuilder() {
    }

    private void appendPartialQuery(String query) {
        if (query == null || query.length() == 0) {
            return;
        }
        if (this.stringBuffer.length() != 0) {
            this.stringBuffer.append(AND_QUERY);
        }
        this.stringBuffer.append(LEFT_PARENTHESES);
        this.stringBuffer.append(query);
        this.stringBuffer.append(RIGHT_PARENTHESES);
    }

    protected static long toNanoSeconds(ZonedDateTime time) {
        return time.toEpochSecond() * 1000000000L + (long)time.getNano();
    }
}

