/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.activity.ActivityMethod;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.internal.sync.ActivityInvocationHandlerBase;
import com.uber.cadence.internal.sync.ActivityStubImpl;
import com.uber.cadence.internal.sync.WorkflowInternal;
import com.uber.cadence.internal.sync.WorkflowThread;
import com.uber.cadence.workflow.ActivityStub;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;

class ActivityInvocationHandler
extends ActivityInvocationHandlerBase {
    private final ActivityOptions options;
    private final WorkflowInterceptor activityExecutor;

    static InvocationHandler newInstance(ActivityOptions options, WorkflowInterceptor activityExecutor) {
        return new ActivityInvocationHandler(options, activityExecutor);
    }

    private ActivityInvocationHandler(ActivityOptions options, WorkflowInterceptor activityExecutor) {
        this.options = options;
        this.activityExecutor = activityExecutor;
    }

    @Override
    protected Function<Object[], Object> getActivityFunc(Method method, MethodRetry methodRetry, ActivityMethod activityMethod, String activityName) {
        ActivityStub stub;
        Map<String, ActivityOptions> activityOptionsMap;
        ActivityOptions activityOptionsOverride = null;
        WorkflowThread workflowThread = WorkflowInternal.getRootWorkflowContext();
        if (workflowThread.getDecisionContext() != null && workflowThread.getDecisionContext().getWorkflowImplementationOptions() != null && (activityOptionsMap = workflowThread.getDecisionContext().getWorkflowImplementationOptions().getActivityOptions()).containsKey(activityName)) {
            activityOptionsOverride = activityOptionsMap.get(activityName);
        }
        ActivityOptions mergedOptions = ActivityOptions.merge(activityMethod, methodRetry, this.options);
        if (activityOptionsOverride == null) {
            stub = ActivityStubImpl.newInstance(mergedOptions, this.activityExecutor);
        } else {
            ActivityOptions mergedOverrideOptions = ActivityOptions.merge(activityMethod, methodRetry, activityOptionsOverride);
            stub = ActivityStubImpl.newInstance(mergedOverrideOptions, this.activityExecutor);
        }
        Function<Object[], Object> function = a -> stub.execute(activityName, method.getReturnType(), method.getGenericReturnType(), a);
        return function;
    }
}

