/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.google.common.base.Defaults;
import com.uber.cadence.ActivityType;
import com.uber.cadence.BadRequestError;
import com.uber.cadence.CancellationAlreadyRequestedError;
import com.uber.cadence.ClientVersionNotSupportedError;
import com.uber.cadence.ClusterInfo;
import com.uber.cadence.CountWorkflowExecutionsRequest;
import com.uber.cadence.CountWorkflowExecutionsResponse;
import com.uber.cadence.DeprecateDomainRequest;
import com.uber.cadence.DescribeDomainRequest;
import com.uber.cadence.DescribeDomainResponse;
import com.uber.cadence.DescribeTaskListRequest;
import com.uber.cadence.DescribeTaskListResponse;
import com.uber.cadence.DescribeWorkflowExecutionRequest;
import com.uber.cadence.DescribeWorkflowExecutionResponse;
import com.uber.cadence.DomainAlreadyExistsError;
import com.uber.cadence.DomainNotActiveError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.GetSearchAttributesResponse;
import com.uber.cadence.GetTaskListsByDomainRequest;
import com.uber.cadence.GetTaskListsByDomainResponse;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.LimitExceededError;
import com.uber.cadence.ListArchivedWorkflowExecutionsRequest;
import com.uber.cadence.ListArchivedWorkflowExecutionsResponse;
import com.uber.cadence.ListClosedWorkflowExecutionsRequest;
import com.uber.cadence.ListClosedWorkflowExecutionsResponse;
import com.uber.cadence.ListDomainsRequest;
import com.uber.cadence.ListDomainsResponse;
import com.uber.cadence.ListOpenWorkflowExecutionsRequest;
import com.uber.cadence.ListOpenWorkflowExecutionsResponse;
import com.uber.cadence.ListTaskListPartitionsRequest;
import com.uber.cadence.ListTaskListPartitionsResponse;
import com.uber.cadence.ListWorkflowExecutionsRequest;
import com.uber.cadence.ListWorkflowExecutionsResponse;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.QueryFailedError;
import com.uber.cadence.QueryWorkflowRequest;
import com.uber.cadence.QueryWorkflowResponse;
import com.uber.cadence.RecordActivityTaskHeartbeatByIDRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatResponse;
import com.uber.cadence.RefreshWorkflowTasksRequest;
import com.uber.cadence.RegisterDomainRequest;
import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.ResetStickyTaskListRequest;
import com.uber.cadence.ResetStickyTaskListResponse;
import com.uber.cadence.ResetWorkflowExecutionRequest;
import com.uber.cadence.ResetWorkflowExecutionResponse;
import com.uber.cadence.RespondActivityTaskCanceledByIDRequest;
import com.uber.cadence.RespondActivityTaskCanceledRequest;
import com.uber.cadence.RespondActivityTaskCompletedByIDRequest;
import com.uber.cadence.RespondActivityTaskCompletedRequest;
import com.uber.cadence.RespondActivityTaskFailedByIDRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedResponse;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RespondQueryTaskCompletedRequest;
import com.uber.cadence.ServiceBusyError;
import com.uber.cadence.SignalWithStartWorkflowExecutionRequest;
import com.uber.cadence.SignalWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionResponse;
import com.uber.cadence.TerminateWorkflowExecutionRequest;
import com.uber.cadence.UpdateDomainRequest;
import com.uber.cadence.UpdateDomainResponse;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionAlreadyCompletedError;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.activity.LocalActivityOptions;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.cadence.internal.sync.ActivityInvocationHandler;
import com.uber.cadence.internal.sync.ActivityInvocationHandlerBase;
import com.uber.cadence.internal.sync.DeterministicRunnerWrapper;
import com.uber.cadence.internal.sync.POJOActivityTaskHandler;
import com.uber.cadence.internal.worker.ActivityTaskHandler;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.testing.TestActivityEnvironment;
import com.uber.cadence.testing.TestEnvironmentOptions;
import com.uber.cadence.workflow.ActivityFailureException;
import com.uber.cadence.workflow.ChildWorkflowOptions;
import com.uber.cadence.workflow.ContinueAsNewOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.Workflow;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.cadence.workflow.WorkflowInterceptorBase;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;

public final class TestActivityEnvironmentInternal
implements TestActivityEnvironment {
    private final POJOActivityTaskHandler activityTaskHandler;
    private final TestEnvironmentOptions testEnvironmentOptions;
    private final AtomicInteger idSequencer = new AtomicInteger();
    private ClassConsumerPair<Object> activityHeartbetListener;
    private static final ScheduledExecutorService heartbeatExecutor = Executors.newScheduledThreadPool(20);
    private IWorkflowService workflowService;

    public TestActivityEnvironmentInternal(TestEnvironmentOptions options) {
        this.testEnvironmentOptions = options == null ? new TestEnvironmentOptions.Builder().build() : options;
        this.activityTaskHandler = new POJOActivityTaskHandler(new WorkflowServiceWrapper(this.workflowService), this.testEnvironmentOptions.getWorkflowClientOptions().getDomain(), this.testEnvironmentOptions.getDataConverter(), heartbeatExecutor);
    }

    @Override
    public void registerActivitiesImplementations(Object ... activityImplementations) {
        this.activityTaskHandler.setActivitiesImplementation(activityImplementations);
    }

    @Override
    public <T> T newActivityStub(Class<T> activityInterface) {
        ActivityOptions options = new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofDays(1L)).build();
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(options, new TestActivityExecutor(this.workflowService, null));
        invocationHandler = new DeterministicRunnerWrapper(invocationHandler);
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    @Override
    public <T> void setActivityHeartbeatListener(Class<T> detailsClass, Consumer<T> listener) {
        this.setActivityHeartbeatListener(detailsClass, detailsClass, listener);
    }

    @Override
    public <T> void setActivityHeartbeatListener(Class<T> detailsClass, Type detailsType, Consumer<T> listener) {
        this.activityHeartbetListener = new ClassConsumerPair<T>(detailsClass, detailsType, listener);
    }

    @Override
    public void setWorkflowService(IWorkflowService workflowService) {
        WorkflowServiceWrapper service = new WorkflowServiceWrapper(workflowService);
        this.workflowService = service;
        this.activityTaskHandler.setWorkflowService(service);
    }

    private class WorkflowServiceWrapper
    implements IWorkflowService {
        private final IWorkflowService impl;

        @Override
        public CompletableFuture<Boolean> isHealthy() {
            return this.impl.isHealthy();
        }

        private WorkflowServiceWrapper(IWorkflowService impl) {
            this.impl = impl == null ? (IWorkflowService)Proxy.newProxyInstance(WorkflowServiceWrapper.class.getClassLoader(), new Class[]{IWorkflowService.class}, (proxy, method, args) -> method.getReturnType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) : impl;
        }

        @Override
        public RecordActivityTaskHeartbeatResponse RecordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            if (TestActivityEnvironmentInternal.this.activityHeartbetListener != null) {
                Object details = TestActivityEnvironmentInternal.this.testEnvironmentOptions.getDataConverter().fromData(heartbeatRequest.getDetails(), ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbetListener.valueClass, ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbetListener.valueType);
                ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbetListener.consumer.accept(details);
            }
            return this.impl.RecordActivityTaskHeartbeat(heartbeatRequest);
        }

        @Override
        public RecordActivityTaskHeartbeatResponse RecordActivityTaskHeartbeatByID(RecordActivityTaskHeartbeatByIDRequest heartbeatRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, DomainNotActiveError, LimitExceededError, ServiceBusyError, TException {
            return this.impl.RecordActivityTaskHeartbeatByID(heartbeatRequest);
        }

        @Override
        public void RespondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RespondActivityTaskCompleted(completeRequest);
        }

        @Override
        public void RespondActivityTaskCompletedByID(RespondActivityTaskCompletedByIDRequest completeRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RespondActivityTaskCompletedByID(completeRequest);
        }

        @Override
        public void RespondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RespondActivityTaskFailed(failRequest);
        }

        @Override
        public void RespondActivityTaskFailedByID(RespondActivityTaskFailedByIDRequest failRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RespondActivityTaskFailedByID(failRequest);
        }

        @Override
        public void RespondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RespondActivityTaskCanceled(canceledRequest);
        }

        @Override
        public void RespondActivityTaskCanceledByID(RespondActivityTaskCanceledByIDRequest canceledRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RespondActivityTaskCanceledByID(canceledRequest);
        }

        @Override
        public void RequestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, CancellationAlreadyRequestedError, ServiceBusyError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RequestCancelWorkflowExecution(cancelRequest);
        }

        @Override
        public void SignalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, ServiceBusyError, TException {
            this.impl.SignalWorkflowExecution(signalRequest);
        }

        @Override
        public StartWorkflowExecutionResponse SignalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, DomainNotActiveError, LimitExceededError, WorkflowExecutionAlreadyStartedError, TException {
            return this.impl.SignalWithStartWorkflowExecution(signalWithStartRequest);
        }

        @Override
        public ResetWorkflowExecutionResponse ResetWorkflowExecution(ResetWorkflowExecutionRequest resetRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, DomainNotActiveError, LimitExceededError, ClientVersionNotSupportedError, TException {
            return this.impl.ResetWorkflowExecution(resetRequest);
        }

        @Override
        public void TerminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, ServiceBusyError, TException {
            this.impl.TerminateWorkflowExecution(terminateRequest);
        }

        @Override
        public ListOpenWorkflowExecutionsResponse ListOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, TException {
            return this.impl.ListOpenWorkflowExecutions(listRequest);
        }

        @Override
        public ListClosedWorkflowExecutionsResponse ListClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, TException {
            return this.impl.ListClosedWorkflowExecutions(listRequest);
        }

        @Override
        public ListWorkflowExecutionsResponse ListWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
            return this.impl.ListWorkflowExecutions(listRequest);
        }

        @Override
        public ListArchivedWorkflowExecutionsResponse ListArchivedWorkflowExecutions(ListArchivedWorkflowExecutionsRequest listRequest) throws BadRequestError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
            return this.impl.ListArchivedWorkflowExecutions(listRequest);
        }

        @Override
        public ListWorkflowExecutionsResponse ScanWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
            return this.impl.ScanWorkflowExecutions(listRequest);
        }

        @Override
        public CountWorkflowExecutionsResponse CountWorkflowExecutions(CountWorkflowExecutionsRequest countRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
            return this.impl.CountWorkflowExecutions(countRequest);
        }

        @Override
        public GetSearchAttributesResponse GetSearchAttributes() throws InternalServiceError, ServiceBusyError, ClientVersionNotSupportedError, TException {
            return this.impl.GetSearchAttributes();
        }

        @Override
        public void RespondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RespondQueryTaskCompleted(completeRequest);
        }

        @Override
        public ResetStickyTaskListResponse ResetStickyTaskList(ResetStickyTaskListRequest resetRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, LimitExceededError, ServiceBusyError, DomainNotActiveError, TException {
            return this.impl.ResetStickyTaskList(resetRequest);
        }

        @Override
        public QueryWorkflowResponse QueryWorkflow(QueryWorkflowRequest queryRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, QueryFailedError, TException {
            return this.impl.QueryWorkflow(queryRequest);
        }

        @Override
        public DescribeWorkflowExecutionResponse DescribeWorkflowExecution(DescribeWorkflowExecutionRequest describeRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, TException {
            return this.impl.DescribeWorkflowExecution(describeRequest);
        }

        @Override
        public DescribeTaskListResponse DescribeTaskList(DescribeTaskListRequest request) throws BadRequestError, InternalServiceError, EntityNotExistsError, TException {
            return this.impl.DescribeTaskList(request);
        }

        @Override
        public ClusterInfo GetClusterInfo() throws InternalServiceError, ServiceBusyError, TException {
            return this.impl.GetClusterInfo();
        }

        @Override
        public ListTaskListPartitionsResponse ListTaskListPartitions(ListTaskListPartitionsRequest request) throws BadRequestError, EntityNotExistsError, LimitExceededError, ServiceBusyError, TException {
            return this.impl.ListTaskListPartitions(request);
        }

        @Override
        public void RefreshWorkflowTasks(RefreshWorkflowTasksRequest request) throws BadRequestError, DomainNotActiveError, ServiceBusyError, EntityNotExistsError, TException {
            this.impl.RefreshWorkflowTasks(request);
        }

        @Override
        public void RegisterDomain(RegisterDomainRequest registerRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RegisterDomain(registerRequest, resultHandler);
        }

        @Override
        public void DescribeDomain(DescribeDomainRequest describeRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.DescribeDomain(describeRequest, resultHandler);
        }

        @Override
        public void ListDomains(ListDomainsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.ListDomains(listRequest, resultHandler);
        }

        @Override
        public void UpdateDomain(UpdateDomainRequest updateRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.UpdateDomain(updateRequest, resultHandler);
        }

        @Override
        public void DeprecateDomain(DeprecateDomainRequest deprecateRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.DeprecateDomain(deprecateRequest, resultHandler);
        }

        @Override
        public void GetTaskListsByDomain(GetTaskListsByDomainRequest request, AsyncMethodCallback resultHandler) throws TException {
            this.impl.GetTaskListsByDomain(request, resultHandler);
        }

        @Override
        public void StartWorkflowExecution(StartWorkflowExecutionRequest startRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.StartWorkflowExecution(startRequest, resultHandler);
        }

        @Override
        public void StartWorkflowExecutionWithTimeout(StartWorkflowExecutionRequest startRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) throws TException {
            this.impl.StartWorkflowExecutionWithTimeout(startRequest, resultHandler, timeoutInMillis);
        }

        @Override
        public void GetWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.GetWorkflowExecutionHistory(getRequest, resultHandler);
        }

        @Override
        public void GetWorkflowExecutionHistoryWithTimeout(GetWorkflowExecutionHistoryRequest getRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) throws TException {
            this.impl.GetWorkflowExecutionHistoryWithTimeout(getRequest, resultHandler, timeoutInMillis);
        }

        @Override
        public void PollForDecisionTask(PollForDecisionTaskRequest pollRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.PollForDecisionTask(pollRequest, resultHandler);
        }

        @Override
        public void RespondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondDecisionTaskCompleted(completeRequest, resultHandler);
        }

        @Override
        public void RespondDecisionTaskFailed(RespondDecisionTaskFailedRequest failedRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondDecisionTaskFailed(failedRequest, resultHandler);
        }

        @Override
        public void PollForActivityTask(PollForActivityTaskRequest pollRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.PollForActivityTask(pollRequest, resultHandler);
        }

        @Override
        public void RecordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RecordActivityTaskHeartbeat(heartbeatRequest, resultHandler);
        }

        @Override
        public void RecordActivityTaskHeartbeatByID(RecordActivityTaskHeartbeatByIDRequest heartbeatRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RecordActivityTaskHeartbeatByID(heartbeatRequest, resultHandler);
        }

        @Override
        public void RespondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondActivityTaskCompleted(completeRequest, resultHandler);
        }

        @Override
        public void RespondActivityTaskCompletedByID(RespondActivityTaskCompletedByIDRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondActivityTaskCompletedByID(completeRequest, resultHandler);
        }

        @Override
        public void RespondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondActivityTaskFailed(failRequest, resultHandler);
        }

        @Override
        public void RespondActivityTaskFailedByID(RespondActivityTaskFailedByIDRequest failRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondActivityTaskFailedByID(failRequest, resultHandler);
        }

        @Override
        public void RespondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondActivityTaskCanceled(canceledRequest, resultHandler);
        }

        @Override
        public void RespondActivityTaskCanceledByID(RespondActivityTaskCanceledByIDRequest canceledRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondActivityTaskCanceledByID(canceledRequest, resultHandler);
        }

        @Override
        public void RequestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RequestCancelWorkflowExecution(cancelRequest, resultHandler);
        }

        @Override
        public void SignalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.SignalWorkflowExecution(signalRequest, resultHandler);
        }

        @Override
        public void SignalWorkflowExecutionWithTimeout(SignalWorkflowExecutionRequest signalRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) throws TException {
            this.impl.SignalWorkflowExecutionWithTimeout(signalRequest, resultHandler, timeoutInMillis);
        }

        @Override
        public void SignalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.SignalWithStartWorkflowExecution(signalWithStartRequest, resultHandler);
        }

        @Override
        public void ResetWorkflowExecution(ResetWorkflowExecutionRequest resetRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.ResetWorkflowExecution(resetRequest, resultHandler);
        }

        @Override
        public void TerminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.TerminateWorkflowExecution(terminateRequest, resultHandler);
        }

        @Override
        public void ListOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.ListOpenWorkflowExecutions(listRequest, resultHandler);
        }

        @Override
        public void ListClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.ListClosedWorkflowExecutions(listRequest, resultHandler);
        }

        @Override
        public void ListWorkflowExecutions(ListWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.ListWorkflowExecutions(listRequest, resultHandler);
        }

        @Override
        public void ListArchivedWorkflowExecutions(ListArchivedWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.ListArchivedWorkflowExecutions(listRequest, resultHandler);
        }

        @Override
        public void ScanWorkflowExecutions(ListWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.ScanWorkflowExecutions(listRequest, resultHandler);
        }

        @Override
        public void CountWorkflowExecutions(CountWorkflowExecutionsRequest countRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.CountWorkflowExecutions(countRequest, resultHandler);
        }

        @Override
        public void GetSearchAttributes(AsyncMethodCallback resultHandler) throws TException {
            this.impl.GetSearchAttributes(resultHandler);
        }

        @Override
        public void RespondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.RespondQueryTaskCompleted(completeRequest, resultHandler);
        }

        @Override
        public void ResetStickyTaskList(ResetStickyTaskListRequest resetRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.ResetStickyTaskList(resetRequest, resultHandler);
        }

        @Override
        public void QueryWorkflow(QueryWorkflowRequest queryRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.QueryWorkflow(queryRequest, resultHandler);
        }

        @Override
        public void DescribeWorkflowExecution(DescribeWorkflowExecutionRequest describeRequest, AsyncMethodCallback resultHandler) throws TException {
            this.impl.DescribeWorkflowExecution(describeRequest, resultHandler);
        }

        @Override
        public void DescribeTaskList(DescribeTaskListRequest request, AsyncMethodCallback resultHandler) throws TException {
            this.impl.DescribeTaskList(request, resultHandler);
        }

        @Override
        public void GetClusterInfo(AsyncMethodCallback resultHandler) throws TException {
        }

        @Override
        public void ListTaskListPartitions(ListTaskListPartitionsRequest request, AsyncMethodCallback resultHandler) throws TException {
        }

        @Override
        public void RefreshWorkflowTasks(RefreshWorkflowTasksRequest request, AsyncMethodCallback resultHandler) throws TException {
        }

        @Override
        public void RegisterDomain(RegisterDomainRequest registerRequest) throws BadRequestError, InternalServiceError, DomainAlreadyExistsError, TException {
            this.impl.RegisterDomain(registerRequest);
        }

        @Override
        public DescribeDomainResponse DescribeDomain(DescribeDomainRequest describeRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, TException {
            return this.impl.DescribeDomain(describeRequest);
        }

        @Override
        public ListDomainsResponse ListDomains(ListDomainsRequest listRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, TException {
            return this.impl.ListDomains(listRequest);
        }

        @Override
        public UpdateDomainResponse UpdateDomain(UpdateDomainRequest updateRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, TException {
            return this.impl.UpdateDomain(updateRequest);
        }

        @Override
        public void DeprecateDomain(DeprecateDomainRequest deprecateRequest) throws BadRequestError, EntityNotExistsError, LimitExceededError, ServiceBusyError, ClientVersionNotSupportedError, TException {
            this.impl.DeprecateDomain(deprecateRequest);
        }

        @Override
        public GetTaskListsByDomainResponse GetTaskListsByDomain(GetTaskListsByDomainRequest request) throws BadRequestError, EntityNotExistsError, LimitExceededError, ServiceBusyError, ClientVersionNotSupportedError, TException {
            return this.impl.GetTaskListsByDomain(request);
        }

        @Override
        public StartWorkflowExecutionResponse StartWorkflowExecution(StartWorkflowExecutionRequest startRequest) throws BadRequestError, InternalServiceError, WorkflowExecutionAlreadyStartedError, ServiceBusyError, TException {
            return this.impl.StartWorkflowExecution(startRequest);
        }

        @Override
        public GetWorkflowExecutionHistoryResponse GetWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, TException {
            return this.impl.GetWorkflowExecutionHistory(getRequest);
        }

        @Override
        public GetWorkflowExecutionHistoryResponse GetWorkflowExecutionHistoryWithTimeout(GetWorkflowExecutionHistoryRequest getRequest, Long timeoutInMillis) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, TException {
            return this.impl.GetWorkflowExecutionHistoryWithTimeout(getRequest, timeoutInMillis);
        }

        @Override
        public PollForDecisionTaskResponse PollForDecisionTask(PollForDecisionTaskRequest pollRequest) throws BadRequestError, InternalServiceError, ServiceBusyError, TException {
            return this.impl.PollForDecisionTask(pollRequest);
        }

        @Override
        public RespondDecisionTaskCompletedResponse RespondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest completeRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            return this.impl.RespondDecisionTaskCompleted(completeRequest);
        }

        @Override
        public void RespondDecisionTaskFailed(RespondDecisionTaskFailedRequest failedRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, WorkflowExecutionAlreadyCompletedError, TException {
            this.impl.RespondDecisionTaskFailed(failedRequest);
        }

        @Override
        public PollForActivityTaskResponse PollForActivityTask(PollForActivityTaskRequest pollRequest) throws BadRequestError, InternalServiceError, ServiceBusyError, TException {
            return this.impl.PollForActivityTask(pollRequest);
        }

        @Override
        public void close() {
            this.impl.close();
        }
    }

    private static class ClassConsumerPair<T> {
        final Consumer<T> consumer;
        final Class<T> valueClass;
        final Type valueType;

        ClassConsumerPair(Class<T> valueClass, Type valueType, Consumer<T> consumer) {
            this.valueClass = Objects.requireNonNull(valueClass);
            this.valueType = Objects.requireNonNull(valueType);
            this.consumer = Objects.requireNonNull(consumer);
        }
    }

    private class TestActivityExecutor
    extends WorkflowInterceptorBase {
        private final IWorkflowService workflowService;

        TestActivityExecutor(IWorkflowService workflowService, WorkflowInterceptorBase next) {
            super(next);
            this.workflowService = workflowService;
        }

        public <T> Promise<T> executeActivity(String activityType, Class<T> resultClass, Type resultType, Object[] args, ActivityOptions options) {
            PollForActivityTaskResponse task = new PollForActivityTaskResponse();
            task.setScheduleToCloseTimeoutSeconds((int)options.getScheduleToCloseTimeout().getSeconds());
            task.setHeartbeatTimeoutSeconds((int)options.getHeartbeatTimeout().getSeconds());
            task.setStartToCloseTimeoutSeconds((int)options.getStartToCloseTimeout().getSeconds());
            task.setScheduledTimestamp(Duration.ofMillis(System.currentTimeMillis()).toNanos());
            task.setStartedTimestamp(Duration.ofMillis(System.currentTimeMillis()).toNanos());
            task.setInput(TestActivityEnvironmentInternal.this.testEnvironmentOptions.getDataConverter().toData(args));
            task.setTaskToken("test-task-token".getBytes(StandardCharsets.UTF_8));
            task.setActivityId(String.valueOf(TestActivityEnvironmentInternal.this.idSequencer.incrementAndGet()));
            task.setWorkflowExecution(new WorkflowExecution().setWorkflowId("test-workflow-id").setRunId(UUID.randomUUID().toString()));
            task.setWorkflowType(new WorkflowType().setName("test-workflow"));
            task.setActivityType(new ActivityType().setName(activityType));
            ActivityTaskHandler.Result taskResult = TestActivityEnvironmentInternal.this.activityTaskHandler.handle(task, NoopScope.getInstance(), false);
            return Workflow.newPromise(this.getReply(task, taskResult, resultClass, resultType));
        }

        @Override
        public <R> Promise<R> executeLocalActivity(String activityName, Class<R> resultClass, Type resultType, Object[] args, LocalActivityOptions options) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public <R> WorkflowInterceptor.WorkflowResult<R> executeChildWorkflow(String workflowType, Class<R> resultClass, Type resultType, Object[] args, ChildWorkflowOptions options) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Random newRandom() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Promise<Void> signalExternalWorkflow(String domain, WorkflowExecution execution, String signalName, Object[] args) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Promise<Void> signalExternalWorkflow(WorkflowExecution execution, String signalName, Object[] args) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Promise<Void> cancelWorkflow(WorkflowExecution execution) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void sleep(Duration duration) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void await(String reason, Supplier<Boolean> unblockCondition) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public Promise<Void> newTimer(Duration duration) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public int getVersion(String changeID, int minSupported, int maxSupported) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void registerQuery(String queryType, Type[] argTypes, Functions.Func1<Object[], Object> callback) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public UUID randomUUID() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void upsertSearchAttributes(Map<String, Object> searchAttributes) {
            throw new UnsupportedOperationException("not implemented");
        }

        private <T> T getReply(PollForActivityTaskResponse task, ActivityTaskHandler.Result response, Class<T> resultClass, Type resultType) {
            RespondActivityTaskCompletedRequest taskCompleted = response.getTaskCompleted();
            if (taskCompleted != null) {
                return TestActivityEnvironmentInternal.this.testEnvironmentOptions.getDataConverter().fromData(taskCompleted.getResult(), resultClass, resultType);
            }
            RespondActivityTaskFailedRequest taskFailed = response.getTaskFailedResult().getTaskFailedRequest();
            if (taskFailed != null) {
                Exception cause;
                String causeClassName = taskFailed.getReason();
                try {
                    Class<?> cc;
                    Class<?> causeClass = cc = Class.forName(causeClassName);
                    cause = (Exception)TestActivityEnvironmentInternal.this.testEnvironmentOptions.getDataConverter().fromData(taskFailed.getDetails(), causeClass, causeClass);
                }
                catch (Exception e) {
                    cause = e;
                }
                throw new ActivityFailureException(0L, task.getActivityType(), task.getActivityId(), cause);
            }
            RespondActivityTaskCanceledRequest taskCancelled = response.getTaskCancelled();
            if (taskCancelled != null) {
                throw new CancellationException(new String(taskCancelled.getDetails(), StandardCharsets.UTF_8));
            }
            return (T)Defaults.defaultValue(resultClass);
        }
    }
}

