/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.google.common.reflect.TypeToken;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.activity.LocalActivityOptions;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.logging.ReplayAwareLogger;
import com.uber.cadence.internal.sync.ActivityInvocationHandler;
import com.uber.cadence.internal.sync.ActivityInvocationHandlerBase;
import com.uber.cadence.internal.sync.ActivityStubImpl;
import com.uber.cadence.internal.sync.AllOfPromise;
import com.uber.cadence.internal.sync.AsyncInternal;
import com.uber.cadence.internal.sync.CancellationScopeImpl;
import com.uber.cadence.internal.sync.ChildWorkflowInvocationHandler;
import com.uber.cadence.internal.sync.ChildWorkflowStubImpl;
import com.uber.cadence.internal.sync.CompletablePromiseImpl;
import com.uber.cadence.internal.sync.ContinueAsNewWorkflowInvocationHandler;
import com.uber.cadence.internal.sync.DestroyWorkflowThreadError;
import com.uber.cadence.internal.sync.DeterministicRunnerImpl;
import com.uber.cadence.internal.sync.ExternalWorkflowInvocationHandler;
import com.uber.cadence.internal.sync.ExternalWorkflowStubImpl;
import com.uber.cadence.internal.sync.LocalActivityInvocationHandler;
import com.uber.cadence.internal.sync.LocalActivityStubImpl;
import com.uber.cadence.internal.sync.SyncDecisionContext;
import com.uber.cadence.internal.sync.WorkflowInfoImpl;
import com.uber.cadence.internal.sync.WorkflowQueueImpl;
import com.uber.cadence.internal.sync.WorkflowRetryerInternal;
import com.uber.cadence.internal.sync.WorkflowStubMarker;
import com.uber.cadence.internal.sync.WorkflowThread;
import com.uber.cadence.workflow.ActivityStub;
import com.uber.cadence.workflow.CancellationScope;
import com.uber.cadence.workflow.ChildWorkflowOptions;
import com.uber.cadence.workflow.ChildWorkflowStub;
import com.uber.cadence.workflow.CompletablePromise;
import com.uber.cadence.workflow.ContinueAsNewOptions;
import com.uber.cadence.workflow.ExternalWorkflowStub;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.QueryMethod;
import com.uber.cadence.workflow.Workflow;
import com.uber.cadence.workflow.WorkflowInfo;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.cadence.workflow.WorkflowQueue;
import com.uber.m3.tally.Scope;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowInternal {
    public static final int DEFAULT_VERSION = -1;
    public static final String CADENCE_CHANGE_VERSION = "CadenceChangeVersion";

    public static WorkflowThread newThread(boolean ignoreParentCancellation, Runnable runnable) {
        return WorkflowThread.newThread(runnable, ignoreParentCancellation);
    }

    public static WorkflowThread newThread(boolean ignoreParentCancellation, String name, Runnable runnable) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        return WorkflowThread.newThread(runnable, ignoreParentCancellation, name);
    }

    public static Promise<Void> newTimer(Duration duration) {
        return WorkflowInternal.getWorkflowInterceptor().newTimer(duration);
    }

    public static <E> WorkflowQueue<E> newQueue(int capacity) {
        return new WorkflowQueueImpl(capacity);
    }

    public static <E> CompletablePromise<E> newCompletablePromise() {
        return new CompletablePromiseImpl();
    }

    public static <E> Promise<E> newPromise(E value) {
        CompletablePromise result = Workflow.newPromise();
        result.complete(value);
        return result;
    }

    public static <E> Promise<E> newFailedPromise(Exception failure) {
        CompletablePromiseImpl result = new CompletablePromiseImpl();
        result.completeExceptionally(CheckedExceptionWrapper.wrap(failure));
        return result;
    }

    public static void registerQuery(Object queryImplementation) {
        Class<?> cls = queryImplementation.getClass();
        TypeToken.TypeSet interfaces = TypeToken.of(cls).getTypes().interfaces();
        if (interfaces.isEmpty()) {
            throw new IllegalArgumentException(cls.getName() + " must implement at least one interface");
        }
        for (TypeToken i : interfaces) {
            for (Method method : i.getRawType().getMethods()) {
                QueryMethod queryMethod = method.getAnnotation(QueryMethod.class);
                if (queryMethod == null) continue;
                String name = queryMethod.name();
                if (name.isEmpty()) {
                    name = InternalUtils.getSimpleName(method);
                }
                WorkflowInternal.getWorkflowInterceptor().registerQuery(name, method.getGenericParameterTypes(), args -> {
                    try {
                        return method.invoke(queryImplementation, args);
                    }
                    catch (Throwable e) {
                        throw CheckedExceptionWrapper.wrap(e);
                    }
                });
            }
        }
    }

    public static long currentTimeMillis() {
        return DeterministicRunnerImpl.currentThreadInternal().getRunner().currentTimeMillis();
    }

    public static <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options) {
        WorkflowInterceptor decisionContext = WorkflowInternal.getWorkflowInterceptor();
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(options, decisionContext);
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    public static <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options) {
        WorkflowInterceptor decisionContext = WorkflowInternal.getWorkflowInterceptor();
        InvocationHandler invocationHandler = LocalActivityInvocationHandler.newInstance(options, decisionContext);
        return ActivityInvocationHandlerBase.newProxy(activityInterface, invocationHandler);
    }

    public static ActivityStub newUntypedActivityStub(ActivityOptions options) {
        return ActivityStubImpl.newInstance(options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static ActivityStub newUntypedLocalActivityStub(LocalActivityOptions options) {
        return LocalActivityStubImpl.newInstance(options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static <T> T newChildWorkflowStub(Class<T> workflowInterface, ChildWorkflowOptions options) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, WorkflowStubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new ChildWorkflowInvocationHandler(workflowInterface, options, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static <T> T newExternalWorkflowStub(Class<T> workflowInterface, WorkflowExecution execution) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface, WorkflowStubMarker.class, AsyncInternal.AsyncMarker.class}, (InvocationHandler)new ExternalWorkflowInvocationHandler(execution, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static Promise<WorkflowExecution> getWorkflowExecution(Object workflowStub) {
        if (workflowStub instanceof WorkflowStubMarker) {
            return ((WorkflowStubMarker)workflowStub).__getWorkflowExecution();
        }
        throw new IllegalArgumentException("Not a workflow stub created through Workflow.newChildWorkflowStub: " + workflowStub);
    }

    public static ChildWorkflowStub newUntypedChildWorkflowStub(String workflowType, ChildWorkflowOptions options) {
        return new ChildWorkflowStubImpl(workflowType, options, WorkflowInternal.getWorkflowInterceptor());
    }

    public static ExternalWorkflowStub newUntypedExternalWorkflowStub(WorkflowExecution execution) {
        return new ExternalWorkflowStubImpl(execution, WorkflowInternal.getWorkflowInterceptor());
    }

    public static <T> T newContinueAsNewStub(Class<T> workflowInterface, ContinueAsNewOptions options) {
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface}, (InvocationHandler)new ContinueAsNewWorkflowInvocationHandler(options, WorkflowInternal.getWorkflowInterceptor()));
    }

    public static <R> R executeActivity(String name, ActivityOptions options, Class<R> resultClass, Type resultType, Object ... args) {
        Promise<R> result = WorkflowInternal.getWorkflowInterceptor().executeActivity(name, resultClass, resultType, args, options);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(result);
            return null;
        }
        return result.get();
    }

    private static WorkflowInterceptor getWorkflowInterceptor() {
        return DeterministicRunnerImpl.currentThreadInternal().getDecisionContext().getWorkflowInterceptor();
    }

    private static SyncDecisionContext getRootDecisionContext() {
        return DeterministicRunnerImpl.currentThreadInternal().getDecisionContext();
    }

    public static void await(String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        WorkflowInternal.getWorkflowInterceptor().await(reason, unblockCondition);
    }

    public static boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) throws DestroyWorkflowThreadError {
        return WorkflowInternal.getWorkflowInterceptor().await(timeout, reason, unblockCondition);
    }

    public static <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        return WorkflowInternal.getWorkflowInterceptor().sideEffect(resultClass, resultType, func);
    }

    public static <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        return WorkflowInternal.getWorkflowInterceptor().mutableSideEffect(id, resultClass, resultType, updated, func);
    }

    public static int getVersion(String changeID, int minSupported, int maxSupported) {
        return WorkflowInternal.getWorkflowInterceptor().getVersion(changeID, minSupported, maxSupported);
    }

    public static <U> Promise<List<U>> promiseAllOf(Collection<Promise<U>> promises) {
        return new AllOfPromise(promises);
    }

    public static Promise<Void> promiseAllOf(Promise<?> ... promises) {
        return new AllOfPromise(promises);
    }

    public static Promise<Object> promiseAnyOf(Iterable<Promise<?>> promises) {
        return CompletablePromiseImpl.promiseAnyOf(promises);
    }

    public static Promise<Object> promiseAnyOf(Promise<?> ... promises) {
        return CompletablePromiseImpl.promiseAnyOf(promises);
    }

    public static CancellationScope newCancellationScope(boolean detached, Runnable runnable) {
        return new CancellationScopeImpl(detached, runnable);
    }

    public static CancellationScope newCancellationScope(boolean detached, Functions.Proc1<CancellationScope> proc) {
        return new CancellationScopeImpl(detached, proc);
    }

    public static CancellationScopeImpl currentCancellationScope() {
        return CancellationScopeImpl.current();
    }

    public static RuntimeException wrap(Throwable e) {
        return CheckedExceptionWrapper.wrap(e);
    }

    public static Exception unwrap(Exception e) {
        return CheckedExceptionWrapper.unwrap(e);
    }

    private WorkflowInternal() {
    }

    public static boolean isReplaying() {
        return WorkflowInternal.getRootDecisionContext().isReplaying();
    }

    public static WorkflowInfo getWorkflowInfo() {
        return new WorkflowInfoImpl(WorkflowInternal.getRootDecisionContext().getContext());
    }

    public static <R> R retry(RetryOptions options, Functions.Func<R> fn) {
        return WorkflowRetryerInternal.validateOptionsAndRetry(options, fn);
    }

    public static void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args) {
        WorkflowInternal.getWorkflowInterceptor().continueAsNew(workflowType, options, args);
    }

    public static void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args, WorkflowInterceptor decisionContext) {
        decisionContext.continueAsNew(workflowType, options, args);
    }

    public static Promise<Void> cancelWorkflow(WorkflowExecution execution) {
        return WorkflowInternal.getWorkflowInterceptor().cancelWorkflow(execution);
    }

    public static void sleep(Duration duration) {
        WorkflowInternal.getWorkflowInterceptor().sleep(duration);
    }

    public static Scope getMetricsScope() {
        return WorkflowInternal.getRootDecisionContext().getMetricsScope();
    }

    private static boolean isLoggingEnabledInReplay() {
        return WorkflowInternal.getRootDecisionContext().isLoggingEnabledInReplay();
    }

    public static UUID randomUUID() {
        return WorkflowInternal.getRootDecisionContext().randomUUID();
    }

    public static Random newRandom() {
        return WorkflowInternal.getRootDecisionContext().newRandom();
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        return new ReplayAwareLogger(logger, WorkflowInternal::isReplaying, WorkflowInternal::isLoggingEnabledInReplay);
    }

    public static Logger getLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new ReplayAwareLogger(logger, WorkflowInternal::isReplaying, WorkflowInternal::isLoggingEnabledInReplay);
    }

    public static <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        return WorkflowInternal.getRootDecisionContext().getLastCompletionResult(resultClass, resultType);
    }

    public static void upsertSearchAttributes(Map<String, Object> searchAttributes) {
        WorkflowInternal.getWorkflowInterceptor().upsertSearchAttributes(searchAttributes);
    }

    public static WorkflowThread getRootWorkflowContext() {
        return DeterministicRunnerImpl.currentThreadInternal();
    }
}

