/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.internal.sync.SyncDecisionContext;
import com.uber.cadence.internal.sync.SyncWorkflowDefinition;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.util.Objects;

class WorkflowRunnable
implements Runnable {
    private final SyncDecisionContext context;
    private final SyncWorkflowDefinition workflow;
    private final WorkflowExecutionStartedEventAttributes attributes;
    private byte[] output;
    private boolean done;

    public WorkflowRunnable(SyncDecisionContext context, SyncWorkflowDefinition workflow, WorkflowExecutionStartedEventAttributes attributes) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(workflow);
        Objects.requireNonNull(attributes);
        this.context = context;
        this.workflow = workflow;
        this.attributes = attributes;
    }

    @Override
    public void run() {
        try {
            WorkflowInterceptor interceptor = this.context.getWorkflowInterceptor();
            this.output = interceptor.executeWorkflow(this.workflow, new WorkflowInterceptor.WorkflowExecuteInput(this.attributes));
        }
        finally {
            this.done = true;
        }
    }

    public void cancel(String reason) {
    }

    public boolean isDone() {
        return this.done;
    }

    public byte[] getOutput() {
        return this.output;
    }

    public void close() {
    }

    public void processSignal(String signalName, byte[] input, long eventId) {
        this.workflow.processSignal(signalName, input, eventId);
    }

    public byte[] query(String type, byte[] args) {
        return this.context.query(type, args);
    }

    public void fireTimers() {
        if (this.context.hasTimersToFire()) {
            this.context.getRunner().executeInWorkflowThread("timers callback", () -> this.context.fireTimers());
        }
    }
}

