/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.google.common.base.Throwables;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.internal.testservice.ExecutionId;
import com.uber.cadence.internal.testservice.WorkflowId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

final class ActivityId {
    private final ExecutionId executionId;
    private final String id;

    ActivityId(String domain, WorkflowExecution execution, String id) {
        this.executionId = new ExecutionId(Objects.requireNonNull(domain), Objects.requireNonNull(execution));
        this.id = Objects.requireNonNull(id);
    }

    ActivityId(String domain, String workflowId, String runId, String id) {
        this(domain, new WorkflowExecution().setWorkflowId(workflowId).setRunId(runId), id);
    }

    public ActivityId(ExecutionId executionId, String id) {
        this.executionId = executionId;
        this.id = id;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityId that = (ActivityId)o;
        if (!this.executionId.equals(that.executionId)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.executionId.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return "ActivityId{executionId=" + this.executionId + ", id='" + this.id + '\'' + '}';
    }

    public byte[] toBytes() throws InternalServiceError {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            out.writeUTF(this.executionId.getDomain());
            WorkflowExecution execution = this.executionId.getExecution();
            out.writeUTF(execution.getWorkflowId());
            out.writeUTF(execution.getRunId());
            out.writeUTF(this.id);
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    static ActivityId fromBytes(byte[] serialized) throws InternalServiceError {
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        DataInputStream in = new DataInputStream(bin);
        try {
            String domain = in.readUTF();
            String workflowId = in.readUTF();
            String runId = in.readUTF();
            String id = in.readUTF();
            return new ActivityId(domain, workflowId, runId, id);
        }
        catch (IOException e) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public WorkflowId getWorkflowId() {
        return new WorkflowId(this.executionId.getDomain(), this.executionId.getExecution().getWorkflowId());
    }
}

