/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.uber.cadence.BadRequestError;
import com.uber.cadence.RetryPolicy;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class RetryState {
    private final RetryPolicy retryPolicy;
    private final long expirationTime;
    private final int attempt;

    RetryState(RetryPolicy retryPolicy, long expirationTime) throws BadRequestError {
        this(RetryState.validateRetryPolicy(retryPolicy), expirationTime, 0);
    }

    private RetryState(RetryPolicy retryPolicy, long expirationTime, int attempt) {
        this.retryPolicy = retryPolicy;
        this.expirationTime = retryPolicy.getExpirationIntervalInSeconds() == 0 ? Long.MAX_VALUE : expirationTime;
        this.attempt = attempt;
    }

    RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    long getExpirationTime() {
        return this.expirationTime;
    }

    int getAttempt() {
        return this.attempt;
    }

    RetryState getNextAttempt() {
        return new RetryState(this.retryPolicy, this.expirationTime, this.attempt + 1);
    }

    int getBackoffIntervalInSeconds(String errReason, long currentTimeMillis) {
        RetryPolicy retryPolicy = this.getRetryPolicy();
        long expirationTime = this.getExpirationTime();
        if (retryPolicy.getMaximumAttempts() == 0 && expirationTime == 0L) {
            return 0;
        }
        if (retryPolicy.getMaximumAttempts() > 0 && this.getAttempt() >= retryPolicy.getMaximumAttempts() - 1) {
            return 0;
        }
        long initInterval = TimeUnit.SECONDS.toMillis(retryPolicy.getInitialIntervalInSeconds());
        long nextInterval = (long)((double)initInterval * Math.pow(retryPolicy.getBackoffCoefficient(), this.getAttempt()));
        long maxInterval = TimeUnit.SECONDS.toMillis(retryPolicy.getMaximumIntervalInSeconds());
        if (nextInterval <= 0L) {
            if (maxInterval > 0L) {
                nextInterval = maxInterval;
            } else {
                return 0;
            }
        }
        if (maxInterval > 0L && nextInterval > maxInterval) {
            nextInterval = maxInterval;
        }
        long backoffInterval = nextInterval;
        long nextScheduleTime = currentTimeMillis + backoffInterval;
        if (expirationTime != 0L && nextScheduleTime > expirationTime) {
            return 0;
        }
        List<String> nonRetriableErrorReasons = retryPolicy.getNonRetriableErrorReasons();
        if (nonRetriableErrorReasons != null) {
            for (String err : nonRetriableErrorReasons) {
                if (!errReason.equals(err)) continue;
                return 0;
            }
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds((long)Math.ceil(backoffInterval));
    }

    static RetryPolicy validateRetryPolicy(RetryPolicy policy) throws BadRequestError {
        if (policy.getInitialIntervalInSeconds() <= 0) {
            throw new BadRequestError("InitialIntervalInSeconds must be greater than 0 on retry policy.");
        }
        if (policy.getBackoffCoefficient() < 1.0) {
            throw new BadRequestError("BackoffCoefficient cannot be less than 1 on retry policy.");
        }
        if (policy.getMaximumIntervalInSeconds() < 0) {
            throw new BadRequestError("MaximumIntervalInSeconds cannot be less than 0 on retry policy.");
        }
        if (policy.getMaximumIntervalInSeconds() > 0 && policy.getMaximumIntervalInSeconds() < policy.getInitialIntervalInSeconds()) {
            throw new BadRequestError("MaximumIntervalInSeconds cannot be less than InitialIntervalInSeconds on retry policy.");
        }
        if (policy.getMaximumAttempts() < 0) {
            throw new BadRequestError("MaximumAttempts cannot be less than 0 on retry policy.");
        }
        if (policy.getMaximumAttempts() == 0 && policy.getExpirationIntervalInSeconds() == 0) {
            throw new BadRequestError("MaximumAttempts and ExpirationIntervalInSeconds are both 0. At least one of them must be specified.");
        }
        return policy;
    }
}

