/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.google.common.collect.ImmutableMap;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.ServiceBusyError;
import com.uber.cadence.TaskList;
import com.uber.cadence.TaskListMetadata;
import com.uber.cadence.internal.worker.ActivityPollTaskBase;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Stopwatch;
import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActivityPollTask
extends ActivityPollTaskBase {
    private static final Logger log = LoggerFactory.getLogger(ActivityPollTask.class);
    private final IWorkflowService service;
    private final String domain;
    private final String taskList;

    public ActivityPollTask(IWorkflowService service, String domain, String taskList, SingleWorkerOptions options) {
        super(options);
        this.service = service;
        this.domain = domain;
        this.taskList = taskList;
    }

    @Override
    protected PollForActivityTaskResponse pollTask() throws TException {
        PollForActivityTaskResponse result;
        this.options.getMetricsScope().counter("cadence-activity-poll-total").inc(1L);
        Stopwatch sw = this.options.getMetricsScope().timer("cadence-activity-poll-latency").start();
        PollForActivityTaskRequest pollRequest = new PollForActivityTaskRequest();
        pollRequest.setDomain(this.domain);
        pollRequest.setIdentity(this.options.getIdentity());
        pollRequest.setTaskList(new TaskList().setName(this.taskList));
        if (this.options.getTaskListActivitiesPerSecond() > 0.0) {
            TaskListMetadata metadata = new TaskListMetadata();
            metadata.setMaxTasksPerSecond(this.options.getTaskListActivitiesPerSecond());
            pollRequest.setTaskListMetadata(metadata);
        }
        if (log.isDebugEnabled()) {
            log.debug("poll request begin: " + pollRequest);
        }
        try {
            result = this.service.PollForActivityTask(pollRequest);
        }
        catch (InternalServiceError e) {
            this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"Cause", (Object)"internalServiceError")).counter("cadence-activity-poll-transient-failed").inc(1L);
            throw e;
        }
        catch (ServiceBusyError e) {
            this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"Cause", (Object)"serviceBusy")).counter("cadence-activity-poll-transient-failed").inc(1L);
            throw e;
        }
        catch (TException e) {
            this.options.getMetricsScope().counter("cadence-activity-poll-failed").inc(1L);
            throw e;
        }
        if (result == null || result.getTaskToken() == null) {
            if (log.isDebugEnabled()) {
                log.debug("poll request returned no task");
            }
            this.options.getMetricsScope().counter("cadence-activity-poll-no-task").inc(1L);
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("poll request returned " + result);
        }
        sw.stop();
        return result;
    }
}

