/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.ActivityType;
import com.uber.cadence.Header;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.internal.worker.ActivityTaskHandler;
import com.uber.cadence.internal.worker.ActivityWorker;
import com.uber.cadence.internal.worker.LocallyDispatchedActivityPollTask;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.serviceclient.IWorkflowService;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;

public final class LocallyDispatchedActivityWorker
extends ActivityWorker {
    private LocallyDispatchedActivityPollTask ldaPollTask;

    public LocallyDispatchedActivityWorker(IWorkflowService service, String domain, String taskList, SingleWorkerOptions options, ActivityTaskHandler handler) {
        super(service, domain, taskList, options, handler, "Locally Dispatched Activity Poller taskList=");
        this.ldaPollTask = new LocallyDispatchedActivityPollTask(options);
    }

    @Override
    protected Poller.PollTask<PollForActivityTaskResponse> getOrCreateActivityPollTask() {
        return this.ldaPollTask;
    }

    public Function<Task, Boolean> getLocallyDispatchedActivityTaskPoller() {
        return this.ldaPollTask;
    }

    public static class Task {
        protected final WorkflowExecution workflowExecution;
        protected final String activityId;
        protected final ActivityType activityType;
        protected final ByteBuffer input;
        protected final int scheduleToCloseTimeoutSeconds;
        protected final int startToCloseTimeoutSeconds;
        protected final int heartbeatTimeoutSeconds;
        protected final WorkflowType workflowType;
        protected final String workflowDomain;
        protected final Header header;
        private final CountDownLatch latch = new CountDownLatch(1);
        protected long scheduledTimestamp;
        protected long scheduledTimestampOfThisAttempt;
        protected long startedTimestamp;
        protected ByteBuffer taskToken;
        private volatile boolean ready;

        public Task(String activityId, ActivityType activityType, ByteBuffer input, int scheduleToCloseTimeoutSeconds, int startToCloseTimeoutSeconds, int heartbeatTimeoutSeconds, WorkflowType workflowType, String workflowDomain, Header header, WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            this.activityId = activityId;
            this.activityType = activityType;
            this.input = input;
            this.scheduleToCloseTimeoutSeconds = scheduleToCloseTimeoutSeconds;
            this.startToCloseTimeoutSeconds = startToCloseTimeoutSeconds;
            this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
            this.workflowType = workflowType;
            this.workflowDomain = workflowDomain;
            this.header = header;
        }

        protected boolean await() throws InterruptedException {
            this.latch.await();
            return this.ready;
        }

        public void notify(boolean ready) {
            this.ready = ready;
            this.latch.countDown();
        }
    }
}

