/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import java.time.Duration;
import java.util.Objects;

public class PollerAutoScalerOptions {
    private Duration pollerScalingInterval;
    private int minConcurrentPollers;
    private float targetPollerUtilisation;

    private PollerAutoScalerOptions() {
    }

    public Duration getPollerScalingInterval() {
        return this.pollerScalingInterval;
    }

    public int getMinConcurrentPollers() {
        return this.minConcurrentPollers;
    }

    public float getTargetPollerUtilisation() {
        return this.targetPollerUtilisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollerAutoScalerOptions that = (PollerAutoScalerOptions)o;
        return this.minConcurrentPollers == that.minConcurrentPollers && Float.compare(that.targetPollerUtilisation, this.targetPollerUtilisation) == 0 && Objects.equals(this.pollerScalingInterval, that.pollerScalingInterval);
    }

    public int hashCode() {
        return Objects.hash(this.pollerScalingInterval, this.minConcurrentPollers, Float.valueOf(this.targetPollerUtilisation));
    }

    public String toString() {
        return "PollerAutoScalerOptions{pollerScalingInterval=" + this.pollerScalingInterval + ", minConcurrentPollers=" + this.minConcurrentPollers + ", targetPollerUtilisation=" + this.targetPollerUtilisation + '}';
    }

    public static class Builder {
        private Duration pollerScalingInterval = Duration.ofMinutes(1L);
        private int minConcurrentPollers = 1;
        private float targetPollerUtilisation = 0.6f;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setPollerScalingInterval(Duration duration) {
            this.pollerScalingInterval = duration;
            return this;
        }

        public Builder setMinConcurrentPollers(int minConcurrentPollers) {
            this.minConcurrentPollers = minConcurrentPollers;
            return this;
        }

        public Builder setTargetPollerUtilisation(float targetPollerUtilisation) {
            this.targetPollerUtilisation = targetPollerUtilisation;
            return this;
        }

        public PollerAutoScalerOptions build() {
            PollerAutoScalerOptions pollerAutoScalerOptions = new PollerAutoScalerOptions();
            pollerAutoScalerOptions.pollerScalingInterval = this.pollerScalingInterval;
            pollerAutoScalerOptions.minConcurrentPollers = this.minConcurrentPollers;
            pollerAutoScalerOptions.targetPollerUtilisation = this.targetPollerUtilisation;
            return pollerAutoScalerOptions;
        }
    }
}

