/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker.autoscaler;

import com.uber.cadence.internal.worker.autoscaler.PollerUsage;
import java.util.concurrent.atomic.AtomicInteger;

public class PollerUsageEstimator {
    private AtomicInteger noopTaskCount = new AtomicInteger();
    private AtomicInteger actionableTaskCount = new AtomicInteger();

    public void increaseNoopTaskCount() {
        this.noopTaskCount.addAndGet(1);
    }

    public void increaseActionableTaskCount() {
        this.actionableTaskCount.addAndGet(1);
    }

    public PollerUsage estimate() {
        int actionableTasks = this.actionableTaskCount.get();
        int noopTasks = this.noopTaskCount.get();
        if (noopTasks + actionableTasks == 0) {
            return new PollerUsage(0.0f);
        }
        PollerUsage result = new PollerUsage((float)actionableTasks * 1.0f / (float)(noopTasks + actionableTasks));
        this.reset();
        return result;
    }

    private void reset() {
        this.noopTaskCount.set(0);
        this.actionableTaskCount.set(0);
    }
}

