/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.migration;

import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.client.WorkflowClient;
import com.uber.cadence.migration.MigrationActivities;
import com.uber.cadence.migration.StartWorkflowInNewResponse;
import com.uber.cadence.workflow.Workflow;

public class MigrationActivitiesImpl
implements MigrationActivities {
    private final WorkflowClient clientInCurrDomain;
    private final WorkflowClient clientInNewDomain;

    public MigrationActivitiesImpl(WorkflowClient clientInCurrDomain, WorkflowClient clientInNewDomain) {
        this.clientInCurrDomain = clientInCurrDomain;
        this.clientInNewDomain = clientInNewDomain;
    }

    @Override
    public StartWorkflowInNewResponse startWorkflowInNewDomain(StartWorkflowExecutionRequest request) {
        try {
            return new StartWorkflowInNewResponse(this.clientInNewDomain.getService().StartWorkflowExecution(request), "New workflow starting successful");
        }
        catch (WorkflowExecutionAlreadyStartedError e) {
            return new StartWorkflowInNewResponse(null, "Workflow already started");
        }
        catch (Exception e) {
            throw Workflow.wrap(e);
        }
    }

    @Override
    public void cancelWorkflowInCurrentDomain(RequestCancelWorkflowExecutionRequest request) {
        try {
            this.clientInCurrDomain.getService().RequestCancelWorkflowExecution(request);
        }
        catch (Exception e) {
            throw Workflow.wrap(e);
        }
    }
}

