/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.migration;

import com.google.common.base.Strings;
import com.uber.cadence.BadRequestError;
import com.uber.cadence.CountWorkflowExecutionsRequest;
import com.uber.cadence.CountWorkflowExecutionsResponse;
import com.uber.cadence.DescribeWorkflowExecutionRequest;
import com.uber.cadence.DescribeWorkflowExecutionResponse;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.ListClosedWorkflowExecutionsRequest;
import com.uber.cadence.ListClosedWorkflowExecutionsResponse;
import com.uber.cadence.ListOpenWorkflowExecutionsRequest;
import com.uber.cadence.ListOpenWorkflowExecutionsResponse;
import com.uber.cadence.ListWorkflowExecutionsRequest;
import com.uber.cadence.ListWorkflowExecutionsResponse;
import com.uber.cadence.QueryWorkflowRequest;
import com.uber.cadence.QueryWorkflowResponse;
import com.uber.cadence.SignalWithStartWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionResponse;
import com.uber.cadence.TerminateWorkflowExecutionRequest;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.serviceclient.IWorkflowServiceBase;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.thrift.TException;

public class MigrationIWorkflowService
extends IWorkflowServiceBase {
    private IWorkflowService serviceOld;
    private IWorkflowService serviceNew;
    private String domainOld;
    private String domainNew;
    private static final int _defaultPageSize = 10;
    private static final String _listWorkflow = "_listWorkflow";
    private static final String _scanWorkflow = "_scanWorkflow";
    byte[] _marker = "to".getBytes();

    public MigrationIWorkflowService(IWorkflowService serviceOld, String domainOld, IWorkflowService serviceNew, String domainNew) {
        this.serviceOld = serviceOld;
        this.domainOld = domainOld;
        this.serviceNew = serviceNew;
        this.domainNew = domainNew;
    }

    @Override
    public StartWorkflowExecutionResponse StartWorkflowExecution(StartWorkflowExecutionRequest startRequest) throws TException {
        if (this.shouldStartInNew(startRequest.getWorkflowId()).booleanValue()) {
            return this.serviceNew.StartWorkflowExecution(startRequest);
        }
        return this.serviceOld.StartWorkflowExecution(startRequest);
    }

    @Override
    public StartWorkflowExecutionResponse SignalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest) throws TException {
        if (this.shouldStartInNew(signalWithStartRequest.getWorkflowId()).booleanValue()) {
            return this.serviceNew.SignalWithStartWorkflowExecution(signalWithStartRequest);
        }
        return this.serviceOld.SignalWithStartWorkflowExecution(signalWithStartRequest);
    }

    @Override
    public GetWorkflowExecutionHistoryResponse GetWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest) throws TException {
        if (this.shouldStartInNew(getRequest.execution.getWorkflowId()).booleanValue()) {
            return this.serviceNew.GetWorkflowExecutionHistory(getRequest);
        }
        return this.serviceOld.GetWorkflowExecutionHistory(getRequest);
    }

    private ListWorkflowExecutionsResponse callOldCluster(ListWorkflowExecutionsRequest listWorkflowExecutionsRequest, int pageSizeOverride, String searchType) throws TException {
        if (pageSizeOverride != 0) {
            listWorkflowExecutionsRequest.setPageSize(pageSizeOverride);
        }
        ListWorkflowExecutionsResponse response = new ListWorkflowExecutionsResponse();
        if (searchType.equals(_listWorkflow)) {
            response = this.serviceOld.ListWorkflowExecutions(listWorkflowExecutionsRequest);
        } else if (searchType.equals(_scanWorkflow)) {
            response = this.serviceOld.ScanWorkflowExecutions(listWorkflowExecutionsRequest);
        }
        return response;
    }

    private ListWorkflowExecutionsResponse appendResultsFromOldCluster(ListWorkflowExecutionsRequest listWorkflowExecutionsRequest, ListWorkflowExecutionsResponse response, String searchType) throws TException {
        int responsePageSize = response.getExecutions().size();
        int neededPageSize = listWorkflowExecutionsRequest.getPageSize() - responsePageSize;
        ListWorkflowExecutionsResponse fromResponse = this.callOldCluster(listWorkflowExecutionsRequest, neededPageSize, searchType);
        if (fromResponse == null) {
            return response;
        }
        fromResponse.getExecutions().addAll(response.getExecutions());
        return fromResponse;
    }

    public boolean hasPrefix(byte[] s, byte[] prefix) {
        return s == null ? false : s.length >= prefix.length && Arrays.equals(Arrays.copyOfRange(s, 0, prefix.length), prefix);
    }

    @Override
    public ListWorkflowExecutionsResponse ListWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) throws TException {
        if (listRequest == null) {
            throw new BadRequestError("List request is null");
        }
        if (Strings.isNullOrEmpty((String)listRequest.getDomain())) {
            throw new BadRequestError("Domain is null or empty");
        }
        if (!listRequest.isSetPageSize()) {
            listRequest.pageSize = 10;
        }
        if (!listRequest.isSetNextPageToken() || listRequest.getNextPageToken().length == 0 || this.hasPrefix(listRequest.getNextPageToken(), this._marker)) {
            ListWorkflowExecutionsResponse response;
            if (this.hasPrefix(listRequest.getNextPageToken(), this._marker)) {
                listRequest.setNextPageToken(Arrays.copyOfRange(listRequest.getNextPageToken(), this._marker.length, listRequest.getNextPageToken().length));
            }
            if ((response = this.serviceNew.ListWorkflowExecutions(listRequest)) == null) {
                return this.callOldCluster(listRequest, 0, _listWorkflow);
            }
            if (response.getExecutions().size() < listRequest.getPageSize()) {
                return this.appendResultsFromOldCluster(listRequest, response, _listWorkflow);
            }
            byte[] combinedNextPageToken = new byte[this._marker.length + response.getNextPageToken().length];
            System.arraycopy(this._marker, 0, combinedNextPageToken, 0, this._marker.length);
            System.arraycopy(response.getNextPageToken(), 0, combinedNextPageToken, this._marker.length, response.getNextPageToken().length);
            response.setNextPageToken(combinedNextPageToken);
            return response;
        }
        return this.callOldCluster(listRequest, 0, _listWorkflow);
    }

    @Override
    public ListWorkflowExecutionsResponse ScanWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) throws TException {
        if (listRequest == null) {
            throw new BadRequestError("List request is null");
        }
        if (Strings.isNullOrEmpty((String)listRequest.getDomain())) {
            throw new BadRequestError("Domain is null or empty");
        }
        if (!listRequest.isSetPageSize()) {
            listRequest.pageSize = 10;
        }
        if (!listRequest.isSetNextPageToken() || listRequest.getNextPageToken().length == 0 || this.hasPrefix(listRequest.getNextPageToken(), this._marker)) {
            ListWorkflowExecutionsResponse response;
            if (this.hasPrefix(listRequest.getNextPageToken(), this._marker)) {
                listRequest.setNextPageToken(Arrays.copyOfRange(listRequest.getNextPageToken(), this._marker.length, listRequest.getNextPageToken().length));
            }
            if ((response = this.serviceNew.ScanWorkflowExecutions(listRequest)) == null) {
                return this.callOldCluster(listRequest, 0, _scanWorkflow);
            }
            if (response.getExecutions().size() < listRequest.getPageSize()) {
                return this.appendResultsFromOldCluster(listRequest, response, _scanWorkflow);
            }
            byte[] combinedNextPageToken = new byte[this._marker.length + response.getNextPageToken().length];
            System.arraycopy(this._marker, 0, combinedNextPageToken, 0, this._marker.length);
            System.arraycopy(response.getNextPageToken(), 0, combinedNextPageToken, this._marker.length, response.getNextPageToken().length);
            response.setNextPageToken(combinedNextPageToken);
            return response;
        }
        return this.callOldCluster(listRequest, 0, _scanWorkflow);
    }

    @Override
    public ListOpenWorkflowExecutionsResponse ListOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest) throws TException {
        if (listRequest == null) {
            throw new BadRequestError("List request is null");
        }
        if (Strings.isNullOrEmpty((String)listRequest.getDomain())) {
            throw new BadRequestError("Domain is null or empty");
        }
        if (!listRequest.isSetMaximumPageSize()) {
            listRequest.maximumPageSize = 10;
        }
        if (!listRequest.isSetNextPageToken() || listRequest.getNextPageToken().length == 0 || this.hasPrefix(listRequest.getNextPageToken(), this._marker)) {
            ListOpenWorkflowExecutionsResponse response;
            if (this.hasPrefix(listRequest.getNextPageToken(), this._marker)) {
                listRequest.setNextPageToken(Arrays.copyOfRange(listRequest.getNextPageToken(), this._marker.length, listRequest.getNextPageToken().length));
            }
            if ((response = this.serviceNew.ListOpenWorkflowExecutions(listRequest)) == null) {
                return this.serviceOld.ListOpenWorkflowExecutions(listRequest);
            }
            if (response.getExecutionsSize() < listRequest.getMaximumPageSize()) {
                int neededPageSize = listRequest.getMaximumPageSize() - response.getExecutionsSize();
                ListOpenWorkflowExecutionsRequest copiedRequest = new ListOpenWorkflowExecutionsRequest(listRequest);
                copiedRequest.maximumPageSize = neededPageSize;
                ListOpenWorkflowExecutionsResponse fromResponse = this.serviceOld.ListOpenWorkflowExecutions(copiedRequest);
                if (fromResponse == null) {
                    return response;
                }
                fromResponse.getExecutions().addAll(response.getExecutions());
                return fromResponse;
            }
            byte[] combinedNextPageToken = new byte[this._marker.length + response.getNextPageToken().length];
            System.arraycopy(this._marker, 0, combinedNextPageToken, 0, this._marker.length);
            System.arraycopy(response.getNextPageToken(), 0, combinedNextPageToken, this._marker.length, response.getNextPageToken().length);
            response.setNextPageToken(combinedNextPageToken);
            return response;
        }
        return this.serviceOld.ListOpenWorkflowExecutions(listRequest);
    }

    @Override
    public ListClosedWorkflowExecutionsResponse ListClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest) throws TException {
        if (listRequest == null) {
            throw new BadRequestError("List request is null");
        }
        if (Strings.isNullOrEmpty((String)listRequest.getDomain())) {
            throw new BadRequestError("Domain is null or empty");
        }
        if (!listRequest.isSetMaximumPageSize()) {
            listRequest.maximumPageSize = 10;
        }
        if (!listRequest.isSetNextPageToken() || listRequest.getNextPageToken().length == 0 || this.hasPrefix(listRequest.getNextPageToken(), this._marker)) {
            ListClosedWorkflowExecutionsResponse response;
            if (this.hasPrefix(listRequest.getNextPageToken(), this._marker)) {
                listRequest.setNextPageToken(Arrays.copyOfRange(listRequest.getNextPageToken(), this._marker.length, listRequest.getNextPageToken().length));
            }
            if ((response = this.serviceNew.ListClosedWorkflowExecutions(listRequest)) == null) {
                return this.serviceOld.ListClosedWorkflowExecutions(listRequest);
            }
            if (response.getExecutionsSize() < listRequest.getMaximumPageSize()) {
                int neededPageSize = listRequest.getMaximumPageSize() - response.getExecutionsSize();
                ListClosedWorkflowExecutionsRequest copiedRequest = new ListClosedWorkflowExecutionsRequest(listRequest);
                copiedRequest.maximumPageSize = neededPageSize;
                ListClosedWorkflowExecutionsResponse fromResponse = this.serviceOld.ListClosedWorkflowExecutions(copiedRequest);
                if (fromResponse == null) {
                    return response;
                }
                fromResponse.getExecutions().addAll(response.getExecutions());
                return fromResponse;
            }
            byte[] combinedNextPageToken = new byte[this._marker.length + response.getNextPageToken().length];
            System.arraycopy(this._marker, 0, combinedNextPageToken, 0, this._marker.length);
            System.arraycopy(response.getNextPageToken(), 0, combinedNextPageToken, this._marker.length, response.getNextPageToken().length);
            response.setNextPageToken(combinedNextPageToken);
            return response;
        }
        return this.serviceOld.ListClosedWorkflowExecutions(listRequest);
    }

    @Override
    public QueryWorkflowResponse QueryWorkflow(QueryWorkflowRequest queryRequest) throws TException {
        try {
            if (this.shouldStartInNew(queryRequest.getExecution().getWorkflowId()).booleanValue()) {
                return this.serviceNew.QueryWorkflow(queryRequest);
            }
            return this.serviceOld.QueryWorkflow(queryRequest);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Query does not have workflowID associated: " + e.getMessage());
        }
    }

    @Override
    public CountWorkflowExecutionsResponse CountWorkflowExecutions(CountWorkflowExecutionsRequest countRequest) throws TException {
        CountWorkflowExecutionsResponse countResponseNew = this.serviceNew.CountWorkflowExecutions(countRequest);
        CountWorkflowExecutionsResponse countResponseOld = this.serviceOld.CountWorkflowExecutions(countRequest);
        if (countResponseNew == null) {
            return countResponseOld;
        }
        if (countResponseOld == null) {
            return countResponseNew;
        }
        countResponseOld.setCount(countResponseOld.getCount() + countResponseNew.getCount());
        return countResponseOld;
    }

    @Override
    public void TerminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateRequest) throws TException {
        try {
            this.serviceNew.TerminateWorkflowExecution(terminateRequest);
        }
        catch (EntityNotExistsError e) {
            this.serviceOld.TerminateWorkflowExecution(terminateRequest);
        }
    }

    private Boolean shouldStartInNew(String workflowID) throws TException {
        try {
            return (Boolean)((CompletableFuture)this.describeWorkflowExecution(this.serviceNew, this.domainNew, workflowID).thenCombine(this.describeWorkflowExecution(this.serviceOld, this.domainOld, workflowID), (respNew, respOld) -> respNew != null || respOld == null || respOld.isSetWorkflowExecutionInfo() && respOld.getWorkflowExecutionInfo().isSetCloseStatus())).get();
        }
        catch (CompletionException e) {
            throw e.getCause() instanceof TException ? (TException)e.getCause() : new TException("unknown error: " + e.getMessage());
        }
        catch (Exception e) {
            throw new TException("Unknown error: " + e.getMessage());
        }
    }

    private CompletableFuture<DescribeWorkflowExecutionResponse> describeWorkflowExecution(IWorkflowService service, String domain, String workflowID) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return service.DescribeWorkflowExecution(new DescribeWorkflowExecutionRequest().setDomain(domain).setExecution(new WorkflowExecution().setWorkflowId(workflowID)));
            }
            catch (EntityNotExistsError e) {
                return null;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }
}

