/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.migration;

import com.google.common.base.Strings;
import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.TaskList;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowIdReusePolicy;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.client.WorkflowClient;
import com.uber.cadence.internal.sync.SyncWorkflowDefinition;
import com.uber.cadence.migration.MigrationActivities;
import com.uber.cadence.workflow.ActivityException;
import com.uber.cadence.workflow.ContinueAsNewOptions;
import com.uber.cadence.workflow.Workflow;
import com.uber.cadence.workflow.WorkflowInfo;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.cadence.workflow.WorkflowInterceptorBase;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;

public class MigrationInterceptor
extends WorkflowInterceptorBase {
    private final WorkflowInterceptor next;
    private final String domainNew;
    private WorkflowClient clientInNewDomain;
    private static final String versionChangeID = "cadenceMigrationInterceptor";
    private static final int versionV1 = 1;
    private final ActivityOptions activityOptions = new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(10L)).build();

    public MigrationInterceptor(WorkflowInterceptor next, WorkflowClient clientInNewDomain) {
        super(next);
        this.next = next;
        this.domainNew = clientInNewDomain.getOptions().getDomain();
    }

    @Override
    public byte[] executeWorkflow(SyncWorkflowDefinition workflowDefinition, WorkflowInterceptor.WorkflowExecuteInput input) {
        WorkflowInfo workflowInfo = Workflow.getWorkflowInfo();
        int version = this.getVersion(versionChangeID, -1, 1);
        switch (version) {
            case 1: {
                WorkflowExecutionStartedEventAttributes startedEventAttributes = input.getWorkflowExecutionStartedEventAttributes();
                if (!this.isCronSchedule(startedEventAttributes)) {
                    return this.next.executeWorkflow(workflowDefinition, input);
                }
                if (this.isChildWorkflow(startedEventAttributes)) {
                    return this.next.executeWorkflow(workflowDefinition, input);
                }
                MigrationDecision decision = Workflow.sideEffect(MigrationDecision.class, () -> this.shouldMigrate(workflowDefinition, input));
                if (!decision.shouldMigrate) break;
                MigrationActivities activities = Workflow.newActivityStub(MigrationActivities.class, this.activityOptions);
                try {
                    activities.startWorkflowInNewDomain(new StartWorkflowExecutionRequest().setDomain(this.domainNew).setWorkflowId(workflowInfo.getWorkflowId()).setTaskList(new TaskList().setName(startedEventAttributes.taskList.getName())).setInput(input.getInput()).setWorkflowType(new WorkflowType().setName(input.getWorkflowType().getName())).setWorkflowIdReusePolicy(WorkflowIdReusePolicy.TerminateIfRunning).setRetryPolicy(startedEventAttributes.getRetryPolicy()).setRequestId(UUID.randomUUID().toString()).setIdentity(startedEventAttributes.getIdentity()).setMemo(startedEventAttributes.getMemo()).setCronSchedule(startedEventAttributes.getCronSchedule()).setHeader(startedEventAttributes.getHeader()).setSearchAttributes(startedEventAttributes.getSearchAttributes()).setExecutionStartToCloseTimeoutSeconds(startedEventAttributes.getExecutionStartToCloseTimeoutSeconds()).setTaskStartToCloseTimeoutSeconds(startedEventAttributes.getTaskStartToCloseTimeoutSeconds()));
                    this.cancelCurrentWorkflow();
                    break;
                }
                catch (ActivityException e) {
                    return this.next.executeWorkflow(workflowDefinition, input);
                }
            }
        }
        return this.next.executeWorkflow(workflowDefinition, input);
    }

    private MigrationDecision shouldMigrate(SyncWorkflowDefinition workflowDefinition, WorkflowInterceptor.WorkflowExecuteInput input) {
        return new MigrationDecision(true, "");
    }

    @Override
    public void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args) {
        int version = this.getVersion(versionChangeID, -1, 1);
        switch (version) {
            case 1: {
                WorkflowInfo workflowInfo = Workflow.getWorkflowInfo();
                WorkflowExecutionStartedEventAttributes startedEventAttributes = workflowInfo.getWorkflowExecutionStartedEventAttributes();
                if (this.isChildWorkflow(startedEventAttributes)) {
                    this.next.continueAsNew(workflowType, options, args);
                }
                MigrationDecision decision = Workflow.sideEffect(MigrationDecision.class, () -> new MigrationDecision(true, ""));
                if (!decision.shouldMigrate) break;
                try {
                    MigrationActivities activities = Workflow.newActivityStub(MigrationActivities.class, this.activityOptions);
                    activities.startWorkflowInNewDomain(new StartWorkflowExecutionRequest().setDomain(this.domainNew).setWorkflowId(workflowInfo.getWorkflowId()).setTaskList(new TaskList().setName(startedEventAttributes.taskList.getName())).setInput(workflowInfo.getDataConverter().toData(args)).setWorkflowType(new WorkflowType().setName(startedEventAttributes.getWorkflowType().getName())).setWorkflowIdReusePolicy(WorkflowIdReusePolicy.TerminateIfRunning).setRetryPolicy(startedEventAttributes.getRetryPolicy()).setRequestId(UUID.randomUUID().toString()).setIdentity(startedEventAttributes.getIdentity()).setMemo(startedEventAttributes.getMemo()).setCronSchedule(startedEventAttributes.getCronSchedule()).setHeader(startedEventAttributes.getHeader()).setSearchAttributes(startedEventAttributes.getSearchAttributes()).setExecutionStartToCloseTimeoutSeconds(startedEventAttributes.getExecutionStartToCloseTimeoutSeconds()).setTaskStartToCloseTimeoutSeconds(startedEventAttributes.getTaskStartToCloseTimeoutSeconds()));
                    this.cancelCurrentWorkflow();
                    break;
                }
                catch (ActivityException e) {
                    this.next.continueAsNew(workflowType, options, args);
                }
            }
        }
        this.next.continueAsNew(workflowType, options, args);
    }

    private boolean isChildWorkflow(WorkflowExecutionStartedEventAttributes startedEventAttributes) {
        return startedEventAttributes.isSetParentWorkflowExecution() && !startedEventAttributes.getParentWorkflowExecution().isSetWorkflowId();
    }

    private boolean isCronSchedule(WorkflowExecutionStartedEventAttributes startedEventAttributes) {
        return !Strings.isNullOrEmpty((String)startedEventAttributes.cronSchedule);
    }

    private void cancelCurrentWorkflow() {
        WorkflowInfo workflowInfo = Workflow.getWorkflowInfo();
        MigrationActivities activities = Workflow.newActivityStub(MigrationActivities.class, this.activityOptions);
        Workflow.newDetachedCancellationScope(() -> activities.cancelWorkflowInCurrentDomain(new RequestCancelWorkflowExecutionRequest().setDomain(workflowInfo.getDomain()).setWorkflowExecution(new WorkflowExecution().setWorkflowId(workflowInfo.getWorkflowId()).setRunId(workflowInfo.getRunId())))).run();
    }

    private class MigrationDecision {
        boolean shouldMigrate;
        String reason;

        public MigrationDecision(boolean shouldMigrate, String reason) {
            this.shouldMigrate = shouldMigrate;
            this.reason = reason;
        }
    }
}

