/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.worker.NonDeterministicWorkflowPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class WorkflowImplementationOptions {
    private final NonDeterministicWorkflowPolicy nonDeterministicWorkflowPolicy;
    private Map<String, ActivityOptions> activityOptions;

    public WorkflowImplementationOptions(NonDeterministicWorkflowPolicy nonDeterministicWorkflowPolicy) {
        this.nonDeterministicWorkflowPolicy = nonDeterministicWorkflowPolicy;
    }

    public WorkflowImplementationOptions(NonDeterministicWorkflowPolicy nonDeterministicWorkflowPolicy, Map<String, ActivityOptions> activityOptions) {
        this.nonDeterministicWorkflowPolicy = nonDeterministicWorkflowPolicy;
        this.activityOptions = activityOptions;
    }

    public NonDeterministicWorkflowPolicy getNonDeterministicWorkflowPolicy() {
        return this.nonDeterministicWorkflowPolicy;
    }

    public Map<String, ActivityOptions> getActivityOptions() {
        return this.activityOptions;
    }

    public String toString() {
        return "WorkflowImplementationOptions{nonDeterministicWorkflowPolicy=" + (Object)((Object)this.nonDeterministicWorkflowPolicy) + this.activityOptions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowImplementationOptions that = (WorkflowImplementationOptions)o;
        return this.nonDeterministicWorkflowPolicy == that.nonDeterministicWorkflowPolicy && Objects.equals(this.activityOptions, that.activityOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nonDeterministicWorkflowPolicy, this.activityOptions});
    }

    public static final class Builder {
        private NonDeterministicWorkflowPolicy nonDeterministicWorkflowPolicy = NonDeterministicWorkflowPolicy.BlockWorkflow;
        private Map<String, ActivityOptions> activityOptionOverrides = new HashMap<String, ActivityOptions>();

        public Builder setNonDeterministicWorkflowPolicy(NonDeterministicWorkflowPolicy nonDeterministicWorkflowPolicy) {
            this.nonDeterministicWorkflowPolicy = Objects.requireNonNull(nonDeterministicWorkflowPolicy);
            return this;
        }

        public Builder setActivityOptionOverrides(Map<String, ActivityOptions> activityOptionOverrides) {
            this.activityOptionOverrides = activityOptionOverrides;
            return this;
        }

        public WorkflowImplementationOptions build() {
            return new WorkflowImplementationOptions(this.nonDeterministicWorkflowPolicy, this.activityOptionOverrides);
        }
    }
}

