/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.client;

import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.activity.ActivityTask;

public class ActivityCompletionException
extends RuntimeException {
    private final WorkflowExecution execution;
    private final String activityType;
    private final String activityId;

    protected ActivityCompletionException(ActivityTask task) {
        this.execution = task.getWorkflowExecution();
        this.activityType = task.getActivityType();
        this.activityId = task.getActivityId();
    }

    protected ActivityCompletionException(ActivityTask task, Throwable cause) {
        super(task != null ? "Execution=" + task.getWorkflowExecution() + ", ActivityType=" + task.getActivityType() + ", ActivityID=" + task.getActivityId() : null, cause);
        if (task != null) {
            this.execution = task.getWorkflowExecution();
            this.activityType = task.getActivityType();
            this.activityId = task.getActivityId();
        } else {
            this.execution = null;
            this.activityType = null;
            this.activityId = null;
        }
    }

    protected ActivityCompletionException(String activityId, Throwable cause) {
        super("ActivityId" + activityId, cause);
        this.execution = null;
        this.activityType = null;
        this.activityId = activityId;
    }

    protected ActivityCompletionException(Throwable cause) {
        this((ActivityTask)null, cause);
    }

    protected ActivityCompletionException() {
        this.execution = null;
        this.activityType = null;
        this.activityId = null;
    }

    public WorkflowExecution getExecution() {
        return this.execution;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public String getActivityId() {
        return this.activityId;
    }
}

