/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.client;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import com.google.common.base.Strings;
import com.uber.cadence.WorkflowIdReusePolicy;
import com.uber.cadence.common.CronSchedule;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.internal.common.OptionsUtils;
import com.uber.cadence.workflow.WorkflowMethod;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class WorkflowOptions {
    private final String workflowId;
    private final WorkflowIdReusePolicy workflowIdReusePolicy;
    private final Duration executionStartToCloseTimeout;
    private final Duration taskStartToCloseTimeout;
    private final String taskList;
    private RetryOptions retryOptions;
    private String cronSchedule;
    private Map<String, Object> memo;
    private Map<String, Object> searchAttributes;
    private List<ContextPropagator> contextPropagators;
    private Duration delayStart;

    public static WorkflowOptions merge(WorkflowMethod a, MethodRetry methodRetry, CronSchedule cronSchedule, WorkflowOptions o) {
        if (a == null) {
            return new Builder(o).validateBuildWithDefaults();
        }
        if (o == null) {
            o = new Builder().build();
        }
        String cronAnnotation = cronSchedule == null ? "" : cronSchedule.value();
        return new Builder().setWorkflowIdReusePolicy(OptionsUtils.merge(a.workflowIdReusePolicy(), o.getWorkflowIdReusePolicy(), WorkflowIdReusePolicy.class)).setWorkflowId(OptionsUtils.merge(a.workflowId(), o.getWorkflowId(), String.class)).setTaskStartToCloseTimeout(OptionsUtils.merge(a.taskStartToCloseTimeoutSeconds(), o.getTaskStartToCloseTimeout())).setExecutionStartToCloseTimeout(OptionsUtils.merge(a.executionStartToCloseTimeoutSeconds(), o.getExecutionStartToCloseTimeout())).setTaskList(OptionsUtils.merge(a.taskList(), o.getTaskList(), String.class)).setRetryOptions(RetryOptions.merge(methodRetry, o.getRetryOptions())).setCronSchedule(OptionsUtils.merge(cronAnnotation, o.getCronSchedule(), String.class)).setMemo(o.getMemo()).setSearchAttributes(o.getSearchAttributes()).setContextPropagators(o.getContextPropagators()).setDelayStart(o.delayStart).validateBuildWithDefaults();
    }

    private WorkflowOptions(String workflowId, WorkflowIdReusePolicy workflowIdReusePolicy, Duration executionStartToCloseTimeout, Duration taskStartToCloseTimeout, String taskList, RetryOptions retryOptions, String cronSchedule, Map<String, Object> memo, Map<String, Object> searchAttributes, List<ContextPropagator> contextPropagators, Duration delayStart) {
        this.workflowId = workflowId;
        this.workflowIdReusePolicy = workflowIdReusePolicy;
        this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        this.taskList = taskList;
        this.retryOptions = retryOptions;
        this.cronSchedule = cronSchedule;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
        this.contextPropagators = contextPropagators;
        this.delayStart = delayStart;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public WorkflowIdReusePolicy getWorkflowIdReusePolicy() {
        return this.workflowIdReusePolicy;
    }

    public Duration getExecutionStartToCloseTimeout() {
        return this.executionStartToCloseTimeout;
    }

    public Duration getTaskStartToCloseTimeout() {
        return this.taskStartToCloseTimeout;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public Map<String, Object> getMemo() {
        return this.memo;
    }

    public Map<String, Object> getSearchAttributes() {
        return this.searchAttributes;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public Duration getDelayStart() {
        return this.delayStart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowOptions that = (WorkflowOptions)o;
        return Objects.equals(this.workflowId, that.workflowId) && this.workflowIdReusePolicy == that.workflowIdReusePolicy && Objects.equals(this.executionStartToCloseTimeout, that.executionStartToCloseTimeout) && Objects.equals(this.taskStartToCloseTimeout, that.taskStartToCloseTimeout) && Objects.equals(this.taskList, that.taskList) && Objects.equals(this.retryOptions, that.retryOptions) && Objects.equals(this.cronSchedule, that.cronSchedule) && Objects.equals(this.memo, that.memo) && Objects.equals(this.searchAttributes, that.searchAttributes) && Objects.equals(this.contextPropagators, that.contextPropagators) && Objects.equals(this.delayStart, that.delayStart);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workflowId, this.workflowIdReusePolicy, this.executionStartToCloseTimeout, this.taskStartToCloseTimeout, this.taskList, this.retryOptions, this.cronSchedule, this.memo, this.searchAttributes, this.contextPropagators, this.delayStart});
    }

    public String toString() {
        return "WorkflowOptions{workflowId='" + this.workflowId + '\'' + ", workflowIdReusePolicy=" + (Object)((Object)this.workflowIdReusePolicy) + ", executionStartToCloseTimeout=" + this.executionStartToCloseTimeout + ", taskStartToCloseTimeout=" + this.taskStartToCloseTimeout + ", taskList='" + this.taskList + '\'' + ", retryOptions=" + this.retryOptions + ", cronSchedule='" + this.cronSchedule + '\'' + ", memo='" + this.memo + '\'' + ", searchAttributes='" + this.searchAttributes + ", contextPropagators='" + this.contextPropagators + '\'' + ", delayStart='" + this.delayStart + '\'' + '}';
    }

    public static final class Builder {
        private String workflowId;
        private WorkflowIdReusePolicy workflowIdReusePolicy;
        private Duration executionStartToCloseTimeout;
        private Duration taskStartToCloseTimeout;
        private String taskList;
        private RetryOptions retryOptions;
        private String cronSchedule;
        private Map<String, Object> memo;
        private Map<String, Object> searchAttributes;
        private List<ContextPropagator> contextPropagators;
        private Duration delayStart;

        public Builder() {
        }

        public Builder(WorkflowOptions o) {
            if (o == null) {
                return;
            }
            this.workflowIdReusePolicy = o.workflowIdReusePolicy;
            this.workflowId = o.workflowId;
            this.taskStartToCloseTimeout = o.taskStartToCloseTimeout;
            this.executionStartToCloseTimeout = o.executionStartToCloseTimeout;
            this.taskList = o.taskList;
            this.retryOptions = o.retryOptions;
            this.cronSchedule = o.cronSchedule;
            this.memo = o.memo;
            this.searchAttributes = o.searchAttributes;
            this.contextPropagators = o.contextPropagators;
            this.delayStart = o.delayStart;
        }

        public Builder setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public Builder setWorkflowIdReusePolicy(WorkflowIdReusePolicy workflowIdReusePolicy) {
            this.workflowIdReusePolicy = workflowIdReusePolicy;
            return this;
        }

        public Builder setExecutionStartToCloseTimeout(Duration executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public Builder setTaskStartToCloseTimeout(Duration taskStartToCloseTimeout) {
            if (OptionsUtils.roundUpToSeconds(taskStartToCloseTimeout).getSeconds() > 60L) {
                throw new IllegalArgumentException("TaskStartToCloseTimeout over one minute: " + taskStartToCloseTimeout);
            }
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public Builder setTaskList(String taskList) {
            this.taskList = taskList;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setCronSchedule(String cronSchedule) {
            this.cronSchedule = cronSchedule;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        public Builder setSearchAttributes(Map<String, Object> searchAttributes) {
            this.searchAttributes = searchAttributes;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public Builder setDelayStart(Duration delayStart) {
            this.delayStart = delayStart;
            return this;
        }

        public WorkflowOptions build() {
            return new WorkflowOptions(this.workflowId, this.workflowIdReusePolicy, this.executionStartToCloseTimeout, this.taskStartToCloseTimeout, this.taskList, this.retryOptions, this.cronSchedule, this.memo, this.searchAttributes, this.contextPropagators, this.delayStart);
        }

        public WorkflowOptions validateBuildWithDefaults() {
            if (this.executionStartToCloseTimeout == null) {
                throw new IllegalStateException("Required property executionStartToCloseTimeout is not set");
            }
            if (this.taskList == null) {
                throw new IllegalArgumentException("Required property taskList is not set");
            }
            WorkflowIdReusePolicy policy = this.workflowIdReusePolicy;
            if (policy == null) {
                policy = WorkflowIdReusePolicy.AllowDuplicateFailedOnly;
            }
            if (this.retryOptions != null) {
                if (this.retryOptions.getInitialInterval() == null) {
                    throw new IllegalArgumentException("RetryOptions missing required initialInterval property");
                }
                if (this.retryOptions.getExpiration() == null && this.retryOptions.getMaximumAttempts() == 0) {
                    throw new IllegalArgumentException("RetryOptions must specify either expiration or maximum attempts");
                }
            }
            if (!Strings.isNullOrEmpty((String)this.cronSchedule)) {
                CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
                CronParser parser = new CronParser(cronDefinition);
                Cron cron = parser.parse(this.cronSchedule);
                cron.validate();
            }
            if (this.delayStart != null && this.delayStart.getSeconds() < 0L) {
                throw new IllegalArgumentException("Delay start (in seconds) value cannot be lower than zero");
            }
            return new WorkflowOptions(this.workflowId, policy, OptionsUtils.roundUpToSeconds(this.executionStartToCloseTimeout), OptionsUtils.roundUpToSeconds(this.taskStartToCloseTimeout, OptionsUtils.DEFAULT_TASK_START_TO_CLOSE_TIMEOUT), this.taskList, this.retryOptions, this.cronSchedule, this.memo, this.searchAttributes, this.contextPropagators, this.delayStart);
        }
    }
}

