/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import com.google.common.base.Strings;
import com.uber.cadence.ActivityType;
import com.uber.cadence.Header;
import com.uber.cadence.MarkerRecordedEventAttributes;
import com.uber.cadence.RespondActivityTaskCanceledRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.converter.DataConverter;
import com.uber.m3.util.ImmutableMap;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import org.apache.thrift.TBaseHelper;

public final class LocalActivityMarkerData {
    private static final String LOCAL_ACTIVITY_HEADER_KEY = "LocalActivityHeader";
    private final LocalActivityMarkerHeader headers;
    private final byte[] result;

    private LocalActivityMarkerData(String activityId, String activityType, long replayTimeMillis, byte[] result, String errReason, int attempt, Duration backoff, boolean isCancelled) {
        this.headers = new LocalActivityMarkerHeader(activityId, activityType, replayTimeMillis, errReason, attempt, backoff, isCancelled);
        this.result = result;
    }

    private LocalActivityMarkerData(LocalActivityMarkerHeader headers, byte[] result) {
        this.headers = headers;
        this.result = result;
        if (headers == null) {
            System.out.println("test");
        }
    }

    public String getActivityId() {
        return this.headers.activityId;
    }

    public String getActivityType() {
        return this.headers.activityType;
    }

    public String getErrReason() {
        return this.headers.errReason;
    }

    public byte[] getErrJson() {
        return Strings.isNullOrEmpty((String)this.headers.errReason) ? null : this.result;
    }

    public byte[] getResult() {
        return this.result;
    }

    public long getReplayTimeMillis() {
        return this.headers.replayTimeMillis;
    }

    public int getAttempt() {
        return this.headers.attempt;
    }

    public Duration getBackoff() {
        return this.headers.backoff;
    }

    public boolean getIsCancelled() {
        return this.headers.isCancelled;
    }

    public Header getHeader(DataConverter converter) {
        byte[] headerData = converter.toData(this.headers);
        Header header = new Header();
        header.setFields((Map<String, ByteBuffer>)ImmutableMap.of((Object)LOCAL_ACTIVITY_HEADER_KEY, (Object)ByteBuffer.wrap(headerData)));
        return header;
    }

    public static LocalActivityMarkerData fromEventAttributes(MarkerRecordedEventAttributes attributes, DataConverter converter) {
        ByteBuffer byteBuffer = attributes.getHeader().getFields().get(LOCAL_ACTIVITY_HEADER_KEY);
        byte[] bytes = TBaseHelper.byteBufferToByteArray((ByteBuffer)byteBuffer);
        LocalActivityMarkerHeader header = converter.fromData(bytes, LocalActivityMarkerHeader.class, (Type)((Object)LocalActivityMarkerHeader.class));
        return new LocalActivityMarkerData(header, attributes.getDetails());
    }

    private static class LocalActivityMarkerHeader {
        private final String activityId;
        private final String activityType;
        private final String errReason;
        private final long replayTimeMillis;
        private final int attempt;
        private final Duration backoff;
        private final boolean isCancelled;

        LocalActivityMarkerHeader(String activityId, String activityType, long replayTimeMillis, String errReason, int attempt, Duration backoff, boolean isCancelled) {
            this.activityId = activityId;
            this.activityType = activityType;
            this.replayTimeMillis = replayTimeMillis;
            this.errReason = errReason;
            this.attempt = attempt;
            this.backoff = backoff;
            this.isCancelled = isCancelled;
        }
    }

    public static final class Builder {
        private String activityId;
        private String activityType;
        private String errReason;
        private byte[] result;
        private long replayTimeMillis;
        private int attempt;
        private Duration backoff;
        private boolean isCancelled;

        public Builder setActivityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public Builder setActivityType(ActivityType activityType) {
            this.activityType = activityType.toString();
            return this;
        }

        public Builder setTaskFailedRequest(RespondActivityTaskFailedRequest request) {
            this.errReason = request.getReason();
            this.result = request.getDetails();
            return this;
        }

        public Builder setTaskCancelledRequest(RespondActivityTaskCanceledRequest request) {
            this.errReason = new String(request.getDetails(), StandardCharsets.UTF_8);
            this.result = request.getDetails();
            this.isCancelled = true;
            return this;
        }

        public Builder setResult(byte[] result) {
            this.result = result;
            return this;
        }

        public Builder setReplayTimeMillis(long replayTimeMillis) {
            this.replayTimeMillis = replayTimeMillis;
            return this;
        }

        public Builder setAttempt(int attempt) {
            this.attempt = attempt;
            return this;
        }

        public Builder setBackoff(Duration backoff) {
            this.backoff = backoff;
            return this;
        }

        public LocalActivityMarkerData build() {
            return new LocalActivityMarkerData(this.activityId, this.activityType, this.replayTimeMillis, this.result, this.errReason, this.attempt, this.backoff, this.isCancelled);
        }
    }
}

