/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.common;

import com.uber.cadence.RetryPolicy;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.common.OptionsUtils;
import com.uber.m3.util.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public final class RetryParameters {
    public int initialIntervalInSeconds;
    public double backoffCoefficient;
    public int maximumIntervalInSeconds;
    public int maximumAttempts;
    public List<String> nonRetriableErrorReasons;
    public int expirationIntervalInSeconds;

    public RetryParameters(RetryOptions retryOptions) {
        this.setBackoffCoefficient(retryOptions.getBackoffCoefficient());
        this.setExpirationIntervalInSeconds((int)OptionsUtils.roundUpToSeconds(retryOptions.getExpiration()).getSeconds());
        this.setMaximumAttempts(retryOptions.getMaximumAttempts());
        this.setInitialIntervalInSeconds((int)OptionsUtils.roundUpToSeconds(retryOptions.getInitialInterval()).getSeconds());
        this.setMaximumIntervalInSeconds((int)OptionsUtils.roundUpToSeconds(retryOptions.getMaximumInterval()).getSeconds());
        ArrayList<String> reasons = new ArrayList<String>();
        List<Class<? extends Throwable>> doNotRetry = retryOptions.getDoNotRetry();
        if (doNotRetry != null) {
            for (Class<? extends Throwable> r : doNotRetry) {
                reasons.add(r.getName());
            }
            this.setNonRetriableErrorReasons(reasons);
        }
    }

    public RetryParameters() {
    }

    public int getInitialIntervalInSeconds() {
        return this.initialIntervalInSeconds;
    }

    public void setInitialIntervalInSeconds(int initialIntervalInSeconds) {
        this.initialIntervalInSeconds = initialIntervalInSeconds;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public void setBackoffCoefficient(double backoffCoefficient) {
        this.backoffCoefficient = backoffCoefficient;
    }

    public int getMaximumIntervalInSeconds() {
        return this.maximumIntervalInSeconds;
    }

    public void setMaximumIntervalInSeconds(int maximumIntervalInSeconds) {
        this.maximumIntervalInSeconds = maximumIntervalInSeconds;
    }

    public int getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public void setMaximumAttempts(int maximumAttempts) {
        this.maximumAttempts = maximumAttempts;
    }

    public List<String> getNonRetriableErrorReasons() {
        return this.nonRetriableErrorReasons;
    }

    public void setNonRetriableErrorReasons(List<String> nonRetriableErrorReasons) {
        this.nonRetriableErrorReasons = nonRetriableErrorReasons;
    }

    public int getExpirationIntervalInSeconds() {
        return this.expirationIntervalInSeconds;
    }

    public void setExpirationIntervalInSeconds(int expirationIntervalInSeconds) {
        this.expirationIntervalInSeconds = expirationIntervalInSeconds;
    }

    public RetryParameters copy() {
        RetryParameters result = new RetryParameters();
        result.setMaximumIntervalInSeconds(this.maximumIntervalInSeconds);
        result.setNonRetriableErrorReasons((List<String>)new ImmutableList(this.nonRetriableErrorReasons));
        result.setInitialIntervalInSeconds(this.initialIntervalInSeconds);
        result.setMaximumAttempts(this.maximumAttempts);
        result.setExpirationIntervalInSeconds(this.expirationIntervalInSeconds);
        result.setBackoffCoefficient(this.backoffCoefficient);
        return result;
    }

    public RetryPolicy toRetryPolicy() {
        return new RetryPolicy().setNonRetriableErrorReasons(this.getNonRetriableErrorReasons()).setMaximumAttempts(this.getMaximumAttempts()).setInitialIntervalInSeconds(this.getInitialIntervalInSeconds()).setExpirationIntervalInSeconds(this.getExpirationIntervalInSeconds()).setBackoffCoefficient(this.getBackoffCoefficient()).setMaximumIntervalInSeconds(this.getMaximumIntervalInSeconds());
    }

    public String toString() {
        return "RetryParameters{initialIntervalInSeconds=" + this.initialIntervalInSeconds + ", backoffCoefficient=" + this.backoffCoefficient + ", maximumIntervalInSeconds=" + this.maximumIntervalInSeconds + ", maximumAttempts=" + this.maximumAttempts + ", nonRetriableErrorReasons=" + this.nonRetriableErrorReasons + ", expirationIntervalInSeconds=" + this.expirationIntervalInSeconds + '}';
    }
}

