/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.external;

import com.google.common.base.Strings;
import com.uber.cadence.Header;
import com.uber.cadence.Memo;
import com.uber.cadence.QueryWorkflowRequest;
import com.uber.cadence.QueryWorkflowResponse;
import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.RetryPolicy;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.SignalWithStartWorkflowExecutionRequest;
import com.uber.cadence.SignalWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionResponse;
import com.uber.cadence.TaskList;
import com.uber.cadence.TerminateWorkflowExecutionRequest;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.WorkflowQuery;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.common.RetryParameters;
import com.uber.cadence.internal.common.RpcRetryer;
import com.uber.cadence.internal.common.SignalWithStartWorkflowExecutionParameters;
import com.uber.cadence.internal.common.StartWorkflowExecutionParameters;
import com.uber.cadence.internal.common.TerminateWorkflowExecutionParameters;
import com.uber.cadence.internal.external.GenericWorkflowClientExternal;
import com.uber.cadence.internal.replay.QueryWorkflowParameters;
import com.uber.cadence.internal.replay.SignalExternalWorkflowParameters;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;

public final class GenericWorkflowClientExternalImpl
implements GenericWorkflowClientExternal {
    private final String domain;
    private final IWorkflowService service;
    private final Scope metricsScope;

    public GenericWorkflowClientExternalImpl(IWorkflowService service, String domain, Scope metricsScope) {
        this.service = service;
        this.domain = domain;
        this.metricsScope = metricsScope;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public IWorkflowService getService() {
        return this.service;
    }

    @Override
    public WorkflowExecution startWorkflow(StartWorkflowExecutionParameters startParameters) throws WorkflowExecutionAlreadyStartedError {
        try {
            WorkflowExecution workflowExecution = this.startWorkflowInternal(startParameters);
            return workflowExecution;
        }
        finally {
            this.emitMetricsForStartWorkflow(startParameters);
        }
    }

    @Override
    public CompletableFuture<WorkflowExecution> startWorkflowAsync(StartWorkflowExecutionParameters startParameters) {
        return this.startWorkflowAsync(startParameters, Long.MAX_VALUE);
    }

    @Override
    public CompletableFuture<WorkflowExecution> startWorkflowAsync(StartWorkflowExecutionParameters startParameters, Long timeoutInMillis) {
        this.emitMetricsForStartWorkflow(startParameters);
        return this.startWorkflowAsyncInternal(startParameters, timeoutInMillis);
    }

    private void emitMetricsForStartWorkflow(StartWorkflowExecutionParameters startParameters) {
        ImmutableMap tags = new ImmutableMap.Builder(3).put((Object)"WorkflowType", (Object)startParameters.getWorkflowType().getName()).put((Object)"TaskList", (Object)startParameters.getTaskList()).put((Object)"Domain", (Object)this.domain).build();
        this.metricsScope.tagged((Map)tags).counter("cadence-workflow-start").inc(1L);
    }

    private WorkflowExecution startWorkflowInternal(StartWorkflowExecutionParameters startParameters) throws WorkflowExecutionAlreadyStartedError {
        StartWorkflowExecutionResponse result;
        StartWorkflowExecutionRequest request = this.getStartRequest(startParameters);
        try {
            result = RpcRetryer.retryWithResult(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS, () -> this.service.StartWorkflowExecution(request));
        }
        catch (WorkflowExecutionAlreadyStartedError e) {
            throw e;
        }
        catch (TException e) {
            throw CheckedExceptionWrapper.wrap(e);
        }
        WorkflowExecution execution = new WorkflowExecution();
        execution.setRunId(result.getRunId());
        execution.setWorkflowId(request.getWorkflowId());
        return execution;
    }

    private RetryOptions getRetryOptionsWithExpiration(RetryOptions o, Long timeoutInMillis) {
        if (timeoutInMillis == null || timeoutInMillis <= 0L || timeoutInMillis == Long.MAX_VALUE) {
            return o;
        }
        return new RetryOptions.Builder(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS).setExpiration(Duration.ofMillis(timeoutInMillis)).build();
    }

    private CompletableFuture<WorkflowExecution> startWorkflowAsyncInternal(StartWorkflowExecutionParameters startParameters, Long timeoutInMillis) {
        final StartWorkflowExecutionRequest request = this.getStartRequest(startParameters);
        return RpcRetryer.retryWithResultAsync(this.getRetryOptionsWithExpiration(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS, timeoutInMillis), () -> {
            final CompletableFuture result = new CompletableFuture();
            try {
                this.service.StartWorkflowExecutionWithTimeout(request, (AsyncMethodCallback)new AsyncMethodCallback<StartWorkflowExecutionResponse>(){

                    public void onComplete(StartWorkflowExecutionResponse response) {
                        WorkflowExecution execution = new WorkflowExecution();
                        execution.setRunId(response.getRunId());
                        execution.setWorkflowId(request.getWorkflowId());
                        result.complete(execution);
                    }

                    public void onError(Exception exception) {
                        result.completeExceptionally(exception);
                    }
                }, timeoutInMillis);
            }
            catch (TException e) {
                result.completeExceptionally(e);
            }
            return result;
        });
    }

    private StartWorkflowExecutionRequest getStartRequest(StartWorkflowExecutionParameters startParameters) {
        String workflowId;
        StartWorkflowExecutionRequest request = new StartWorkflowExecutionRequest();
        request.setDomain(this.domain);
        if (startParameters.getInput() != null) {
            request.setInput(startParameters.getInput());
        }
        request.setExecutionStartToCloseTimeoutSeconds((int)startParameters.getExecutionStartToCloseTimeoutSeconds());
        request.setTaskStartToCloseTimeoutSeconds((int)startParameters.getTaskStartToCloseTimeoutSeconds());
        request.setWorkflowIdReusePolicy(startParameters.getWorkflowIdReusePolicy());
        String taskList = startParameters.getTaskList();
        if (taskList != null && !taskList.isEmpty()) {
            TaskList tl = new TaskList();
            tl.setName(taskList);
            request.setTaskList(tl);
        }
        if ((workflowId = startParameters.getWorkflowId()) == null) {
            workflowId = UUID.randomUUID().toString();
        }
        request.setWorkflowId(workflowId);
        request.setWorkflowType(startParameters.getWorkflowType());
        RetryParameters retryParameters = startParameters.getRetryParameters();
        if (retryParameters != null) {
            RetryPolicy retryPolicy = this.toRetryPolicy(retryParameters);
            request.setRetryPolicy(retryPolicy);
        }
        if (!Strings.isNullOrEmpty((String)startParameters.getCronSchedule())) {
            request.setCronSchedule(startParameters.getCronSchedule());
        }
        request.setMemo(this.toMemoThrift(startParameters.getMemo()));
        request.setSearchAttributes(this.toSearchAttributesThrift(startParameters.getSearchAttributes()));
        request.setHeader(this.toHeaderThrift(startParameters.getContext()));
        if (startParameters.getDelayStart() != null) {
            request.setDelayStartSeconds((int)startParameters.getDelayStart().getSeconds());
        }
        return request;
    }

    private Memo toMemoThrift(Map<String, byte[]> memo) {
        if (memo == null || memo.isEmpty()) {
            return null;
        }
        HashMap<String, ByteBuffer> fields = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, byte[]> item : memo.entrySet()) {
            fields.put(item.getKey(), ByteBuffer.wrap(item.getValue()));
        }
        Memo memoThrift = new Memo();
        memoThrift.setFields(fields);
        return memoThrift;
    }

    private SearchAttributes toSearchAttributesThrift(Map<String, byte[]> searchAttributes) {
        if (searchAttributes == null || searchAttributes.isEmpty()) {
            return null;
        }
        HashMap<String, ByteBuffer> fields = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, byte[]> item : searchAttributes.entrySet()) {
            fields.put(item.getKey(), ByteBuffer.wrap(item.getValue()));
        }
        SearchAttributes searchAttrThrift = new SearchAttributes();
        searchAttrThrift.setIndexedFields(fields);
        return searchAttrThrift;
    }

    private Header toHeaderThrift(Map<String, byte[]> headers) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        HashMap<String, ByteBuffer> fields = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, byte[]> item : headers.entrySet()) {
            fields.put(item.getKey(), ByteBuffer.wrap(item.getValue()));
        }
        Header headerThrift = new Header();
        headerThrift.setFields(fields);
        return headerThrift;
    }

    private RetryPolicy toRetryPolicy(RetryParameters retryParameters) {
        return new RetryPolicy().setBackoffCoefficient(retryParameters.getBackoffCoefficient()).setExpirationIntervalInSeconds(retryParameters.getExpirationIntervalInSeconds()).setInitialIntervalInSeconds(retryParameters.getInitialIntervalInSeconds()).setMaximumAttempts(retryParameters.getMaximumAttempts()).setMaximumIntervalInSeconds(retryParameters.getMaximumIntervalInSeconds()).setNonRetriableErrorReasons(retryParameters.getNonRetriableErrorReasons());
    }

    @Override
    public void signalWorkflowExecution(SignalExternalWorkflowParameters signalParameters) {
        SignalWorkflowExecutionRequest request = this.getSignalRequest(signalParameters);
        try {
            RpcRetryer.retry(() -> this.service.SignalWorkflowExecution(request));
        }
        catch (TException e) {
            throw CheckedExceptionWrapper.wrap(e);
        }
    }

    @Override
    public CompletableFuture<Void> signalWorkflowExecutionAsync(SignalExternalWorkflowParameters signalParameters) {
        return this.signalWorkflowExecutionAsync(signalParameters, Long.MAX_VALUE);
    }

    @Override
    public CompletableFuture<Void> signalWorkflowExecutionAsync(SignalExternalWorkflowParameters signalParameters, Long timeoutInMillis) {
        SignalWorkflowExecutionRequest request = this.getSignalRequest(signalParameters);
        return RpcRetryer.retryWithResultAsync(this.getRetryOptionsWithExpiration(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS, timeoutInMillis), () -> {
            final CompletableFuture result = new CompletableFuture();
            try {
                this.service.SignalWorkflowExecution(request, new AsyncMethodCallback(){

                    public void onComplete(Object response) {
                        result.complete(null);
                    }

                    public void onError(Exception exception) {
                        result.completeExceptionally(exception);
                    }
                });
            }
            catch (TException e) {
                result.completeExceptionally(e);
            }
            return result;
        });
    }

    private SignalWorkflowExecutionRequest getSignalRequest(SignalExternalWorkflowParameters signalParameters) {
        SignalWorkflowExecutionRequest request = new SignalWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setInput(signalParameters.getInput());
        request.setSignalName(signalParameters.getSignalName());
        WorkflowExecution execution = new WorkflowExecution();
        execution.setRunId(signalParameters.getRunId());
        execution.setWorkflowId(signalParameters.getWorkflowId());
        request.setWorkflowExecution(execution);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowExecution signalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionParameters parameters) {
        try {
            WorkflowExecution workflowExecution = this.signalWithStartWorkflowInternal(parameters);
            return workflowExecution;
        }
        finally {
            ImmutableMap tags = new ImmutableMap.Builder(3).put((Object)"WorkflowType", (Object)parameters.getStartParameters().getWorkflowType().getName()).put((Object)"TaskList", (Object)parameters.getStartParameters().getTaskList()).put((Object)"Domain", (Object)this.domain).build();
            this.metricsScope.tagged((Map)tags).counter("cadence-workflow-signal-with-start").inc(1L);
        }
    }

    private WorkflowExecution signalWithStartWorkflowInternal(SignalWithStartWorkflowExecutionParameters parameters) {
        StartWorkflowExecutionResponse result;
        String workflowId;
        SignalWithStartWorkflowExecutionRequest request = new SignalWithStartWorkflowExecutionRequest();
        request.setDomain(this.domain);
        StartWorkflowExecutionParameters startParameters = parameters.getStartParameters();
        request.setSignalName(parameters.getSignalName());
        request.setSignalInput(parameters.getSignalInput());
        if (startParameters.getInput() != null) {
            request.setInput(startParameters.getInput());
        }
        request.setExecutionStartToCloseTimeoutSeconds((int)startParameters.getExecutionStartToCloseTimeoutSeconds());
        request.setTaskStartToCloseTimeoutSeconds((int)startParameters.getTaskStartToCloseTimeoutSeconds());
        request.setWorkflowIdReusePolicy(startParameters.getWorkflowIdReusePolicy());
        String taskList = startParameters.getTaskList();
        if (taskList != null && !taskList.isEmpty()) {
            TaskList tl = new TaskList();
            tl.setName(taskList);
            request.setTaskList(tl);
        }
        if ((workflowId = startParameters.getWorkflowId()) == null) {
            workflowId = UUID.randomUUID().toString();
        }
        request.setWorkflowId(workflowId);
        request.setWorkflowType(startParameters.getWorkflowType());
        RetryParameters retryParameters = startParameters.getRetryParameters();
        if (retryParameters != null) {
            RetryPolicy retryPolicy = this.toRetryPolicy(retryParameters);
            request.setRetryPolicy(retryPolicy);
        }
        if (!Strings.isNullOrEmpty((String)startParameters.getCronSchedule())) {
            request.setCronSchedule(startParameters.getCronSchedule());
        }
        if (startParameters.getDelayStart() != null) {
            request.setDelayStartSeconds((int)startParameters.getDelayStart().getSeconds());
        }
        try {
            result = RpcRetryer.retryWithResult(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS, () -> this.service.SignalWithStartWorkflowExecution(request));
        }
        catch (TException e) {
            throw CheckedExceptionWrapper.wrap(e);
        }
        WorkflowExecution execution = new WorkflowExecution();
        execution.setRunId(result.getRunId());
        execution.setWorkflowId(request.getWorkflowId());
        return execution;
    }

    @Override
    public void requestCancelWorkflowExecution(WorkflowExecution execution) {
        RequestCancelWorkflowExecutionRequest request = new RequestCancelWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setWorkflowExecution(execution);
        try {
            RpcRetryer.retry(() -> this.service.RequestCancelWorkflowExecution(request));
        }
        catch (TException e) {
            throw CheckedExceptionWrapper.wrap(e);
        }
    }

    @Override
    public QueryWorkflowResponse queryWorkflow(QueryWorkflowParameters queryParameters) {
        QueryWorkflowRequest request = new QueryWorkflowRequest();
        request.setDomain(this.domain);
        WorkflowExecution execution = new WorkflowExecution();
        execution.setWorkflowId(queryParameters.getWorkflowId()).setRunId(queryParameters.getRunId());
        request.setExecution(execution);
        WorkflowQuery query = new WorkflowQuery();
        query.setQueryArgs(queryParameters.getInput());
        query.setQueryType(queryParameters.getQueryType());
        request.setQuery(query);
        request.setQueryRejectCondition(queryParameters.getQueryRejectCondition());
        request.setQueryConsistencyLevel(queryParameters.getQueryConsistencyLevel());
        try {
            QueryWorkflowResponse response = RpcRetryer.retryWithResult(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS, () -> this.service.QueryWorkflow(request));
            return response;
        }
        catch (TException e) {
            throw CheckedExceptionWrapper.wrap(e);
        }
    }

    @Override
    public String generateUniqueId() {
        String workflowId = UUID.randomUUID().toString();
        return workflowId;
    }

    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionParameters terminateParameters) {
        TerminateWorkflowExecutionRequest request = new TerminateWorkflowExecutionRequest();
        request.setWorkflowExecution(terminateParameters.getWorkflowExecution());
        request.setDomain(this.domain);
        request.setDetails(terminateParameters.getDetails());
        request.setReason(terminateParameters.getReason());
        try {
            RpcRetryer.retry(() -> this.service.TerminateWorkflowExecution(request));
        }
        catch (TException e) {
            throw CheckedExceptionWrapper.wrap(e);
        }
    }
}

