/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.Header;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.SearchAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.internal.replay.ContinueAsNewWorkflowExecutionParameters;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBaseHelper;

final class WorkflowContext {
    private final PollForDecisionTaskResponse decisionTask;
    private boolean cancelRequested;
    private ContinueAsNewWorkflowExecutionParameters continueAsNewOnCompletion;
    private WorkflowExecutionStartedEventAttributes startedAttributes;
    private final String domain;
    private String currentRunId;
    private SearchAttributes searchAttributes;
    private List<ContextPropagator> contextPropagators;

    WorkflowContext(String domain, PollForDecisionTaskResponse decisionTask, WorkflowExecutionStartedEventAttributes startedAttributes, List<ContextPropagator> contextPropagators) {
        this.domain = domain;
        this.decisionTask = decisionTask;
        this.startedAttributes = startedAttributes;
        this.currentRunId = startedAttributes.getOriginalExecutionRunId();
        this.searchAttributes = startedAttributes.getSearchAttributes();
        this.contextPropagators = contextPropagators;
    }

    WorkflowExecution getWorkflowExecution() {
        return this.decisionTask.getWorkflowExecution();
    }

    WorkflowType getWorkflowType() {
        return this.decisionTask.getWorkflowType();
    }

    boolean isCancelRequested() {
        return this.cancelRequested;
    }

    void setCancelRequested(boolean flag) {
        this.cancelRequested = flag;
    }

    ContinueAsNewWorkflowExecutionParameters getContinueAsNewOnCompletion() {
        return this.continueAsNewOnCompletion;
    }

    void setContinueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        if (continueParameters == null) {
            continueParameters = new ContinueAsNewWorkflowExecutionParameters();
        }
        if (continueParameters.getExecutionStartToCloseTimeoutSeconds() == 0) {
            continueParameters.setExecutionStartToCloseTimeoutSeconds(this.startedAttributes.getExecutionStartToCloseTimeoutSeconds());
        }
        if (continueParameters.getTaskList() == null) {
            continueParameters.setTaskList(this.startedAttributes.getTaskList().getName());
        }
        if (continueParameters.getTaskStartToCloseTimeoutSeconds() == 0) {
            continueParameters.setTaskStartToCloseTimeoutSeconds(this.startedAttributes.getTaskStartToCloseTimeoutSeconds());
        }
        this.continueAsNewOnCompletion = continueParameters;
    }

    WorkflowExecution getParentWorkflowExecution() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getParentWorkflowExecution();
    }

    int getExecutionStartToCloseTimeoutSeconds() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getExecutionStartToCloseTimeoutSeconds();
    }

    int getDecisionTaskTimeoutSeconds() {
        return this.startedAttributes.getTaskStartToCloseTimeoutSeconds();
    }

    String getTaskList() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.getTaskList().getName();
    }

    String getDomain() {
        return this.domain;
    }

    private WorkflowExecutionStartedEventAttributes getWorkflowStartedEventAttributes() {
        return this.startedAttributes;
    }

    void setCurrentRunId(String currentRunId) {
        this.currentRunId = currentRunId;
    }

    String getCurrentRunId() {
        return this.currentRunId;
    }

    SearchAttributes getSearchAttributes() {
        return this.searchAttributes;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    Map<String, Object> getPropagatedContexts() {
        if (this.contextPropagators == null || this.contextPropagators.isEmpty()) {
            return new HashMap<String, Object>();
        }
        Header headers = this.startedAttributes.getHeader();
        if (headers == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, byte[]> headerData = new HashMap<String, byte[]>();
        headers.getFields().forEach((k, v) -> headerData.put((String)k, TBaseHelper.byteBufferToByteArray((ByteBuffer)v)));
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        for (ContextPropagator propagator : this.contextPropagators) {
            contextData.put(propagator.getName(), propagator.deserializeContext(headerData));
        }
        return contextData;
    }

    void mergeSearchAttributes(SearchAttributes searchAttributes) {
        if (searchAttributes == null) {
            return;
        }
        if (this.searchAttributes == null) {
            this.searchAttributes = this.newSearchAttributes();
        }
        Map<String, ByteBuffer> current = this.searchAttributes.getIndexedFields();
        searchAttributes.getIndexedFields().forEach((k, v) -> current.put((String)k, (ByteBuffer)v));
    }

    private SearchAttributes newSearchAttributes() {
        SearchAttributes result = new SearchAttributes();
        result.setIndexedFields(new HashMap<String, ByteBuffer>());
        return result;
    }
}

