/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.shadowing;

import com.google.common.collect.Lists;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.History;
import com.uber.cadence.HistoryEventFilterType;
import com.uber.cadence.activity.Activity;
import com.uber.cadence.common.WorkflowExecutionHistory;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.common.RpcRetryer;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.shadowing.NonRetryableException;
import com.uber.cadence.internal.shadowing.ReplayWorkflowActivity;
import com.uber.cadence.internal.shadowing.ReplayWorkflowActivityParams;
import com.uber.cadence.internal.shadowing.ReplayWorkflowActivityResult;
import com.uber.cadence.internal.shadowing.WorkflowExecution;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.testing.TestEnvironmentOptions;
import com.uber.cadence.testing.TestWorkflowEnvironment;
import com.uber.cadence.worker.Worker;
import com.uber.cadence.worker.WorkflowImplementationOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplayWorkflowActivityImpl
implements ReplayWorkflowActivity {
    private static final Logger log = LoggerFactory.getLogger(ReplayWorkflowActivityImpl.class);
    private final IWorkflowService serviceClient;
    private final Scope metricsScope;
    private final Worker worker;

    public ReplayWorkflowActivityImpl(IWorkflowService serviceClient, Scope metricsScope, String taskList) {
        this(serviceClient, metricsScope, taskList, new TestEnvironmentOptions.Builder().build());
    }

    public ReplayWorkflowActivityImpl(IWorkflowService serviceClient, Scope metricsScope, String taskList, TestEnvironmentOptions testOptions) {
        this.serviceClient = Objects.requireNonNull(serviceClient);
        this.metricsScope = Objects.requireNonNull(metricsScope);
        this.worker = TestWorkflowEnvironment.newInstance(testOptions).newWorker(taskList);
    }

    @Override
    public void registerWorkflowImplementationTypes(Class<?> ... workflowImplementationClasses) {
        this.worker.registerWorkflowImplementationTypes(workflowImplementationClasses);
    }

    @Override
    public void registerWorkflowImplementationTypesWithOptions(WorkflowImplementationOptions options, Class<?> ... workflowImplementationClasses) {
        this.worker.registerWorkflowImplementationTypes(options, workflowImplementationClasses);
    }

    @Override
    public <R> void addWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory) {
        this.worker.addWorkflowImplementationFactory(workflowInterface, factory);
    }

    @Override
    public <R> void addWorkflowImplementationFactoryWithOptions(WorkflowImplementationOptions options, Class<R> workflowInterface, Functions.Func<R> factory) {
        this.worker.addWorkflowImplementationFactory(options, workflowInterface, factory);
    }

    @Override
    public ReplayWorkflowActivityResult replay(ReplayWorkflowActivityParams request) throws Exception {
        ReplayWorkflowActivityResult heartbeatResult;
        if (request == null) {
            throw new NullPointerException("Replay activity request is null.");
        }
        int successCount = 0;
        int failedCount = 0;
        int skippedCount = 0;
        int replayIndex = 0;
        List<WorkflowExecution> executions = request.getExecutions();
        Optional<HeartbeatDetail> heartbeatDetail = Activity.getHeartbeatDetails(HeartbeatDetail.class);
        if (heartbeatDetail.isPresent()) {
            heartbeatResult = heartbeatDetail.get().getReplayResult();
            successCount = heartbeatResult.getSucceeded();
            failedCount = heartbeatResult.getFailed();
            skippedCount = heartbeatResult.getSkipped();
            replayIndex = heartbeatDetail.get().getReplayExecutionIndex() + 1;
        }
        while (replayIndex < executions.size()) {
            WorkflowExecution execution = executions.get(replayIndex);
            ReplayWorkflowActivityResult oneReplayResult = this.replayOneExecution(request.getDomain(), execution);
            heartbeatResult = new ReplayWorkflowActivityResult();
            heartbeatResult.setSucceeded(successCount += oneReplayResult.getSucceeded());
            heartbeatResult.setFailed(failedCount += oneReplayResult.getFailed());
            heartbeatResult.setSkipped(skippedCount += oneReplayResult.getSkipped());
            Activity.heartbeat(new HeartbeatDetail(heartbeatResult, replayIndex));
            ++replayIndex;
        }
        ReplayWorkflowActivityResult result = new ReplayWorkflowActivityResult();
        result.setSucceeded(successCount);
        result.setFailed(failedCount);
        result.setSkipped(skippedCount);
        return result;
    }

    @Override
    public ReplayWorkflowActivityResult replayOneExecution(String domain, WorkflowExecution execution) {
        WorkflowExecutionHistory workflowHistory;
        ReplayWorkflowActivityResult result = new ReplayWorkflowActivityResult();
        try {
            workflowHistory = this.getFullHistory(domain, execution);
        }
        catch (Throwable e) {
            log.error("skipped workflow execution with domain: " + domain + ". Execution: " + execution.toString(), e);
            result.setSkipped(1);
            return result;
        }
        try {
            boolean isSuccess = this.replayWorkflowHistory(domain, execution, workflowHistory);
            if (isSuccess) {
                this.metricsScope.counter("cadence-replay-succeed").inc(1L);
                result.setSucceeded(1);
                return result;
            }
            this.metricsScope.counter("cadence-replay-skipped").inc(1L);
            result.setSkipped(1);
            return result;
        }
        catch (NonRetryableException e) {
            throw e;
        }
        catch (Exception e) {
            this.metricsScope.counter("cadence-replay-failed").inc(1L);
            result.setFailed(1);
            return result;
        }
    }

    protected WorkflowExecutionHistory getFullHistory(String domain, WorkflowExecution execution) throws Exception {
        byte[] pageToken = null;
        ArrayList histories = Lists.newArrayList();
        do {
            byte[] nextPageToken = pageToken;
            GetWorkflowExecutionHistoryResponse resp = RpcRetryer.retryWithResult(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS, () -> WorkflowExecutionUtils.getHistoryPage(nextPageToken, this.serviceClient, domain, execution.toThrift()));
            pageToken = resp.getNextPageToken();
            if (resp.getRawHistory() != null && resp.getRawHistory().size() > 0) {
                History history = InternalUtils.DeserializeFromBlobDataToHistory(resp.getRawHistory(), HistoryEventFilterType.ALL_EVENT);
                if (history == null || history.getEvents() == null) continue;
                histories.addAll(history.getEvents());
                continue;
            }
            histories.addAll(resp.getHistory().getEvents());
        } while (pageToken != null);
        return new WorkflowExecutionHistory(histories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean replayWorkflowHistory(String domain, WorkflowExecution execution, WorkflowExecutionHistory workflowHistory) throws Exception {
        Stopwatch sw = this.metricsScope.timer("cadence-replay-latency").start();
        try {
            this.worker.replayWorkflowExecution(workflowHistory);
        }
        catch (Exception e) {
            if (this.isNonDeterministicError(e)) {
                log.error("failed to replay workflow history with domain: " + domain + ". Execution: " + execution.toString(), (Throwable)e);
                throw e;
            }
            if (this.isWorkflowTypeNotRegisterError(e)) {
                log.info("replay unregistered workflow execution: {}", (Object)execution.toString(), (Object)e);
                throw new NonRetryableException(e);
            }
            log.info("replay workflow execution: {} skipped", (Object)execution.toString(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            sw.stop();
        }
        log.info("replay workflow execution: {} succeed", (Object)execution.toString());
        return true;
    }

    private boolean isNonDeterministicError(Exception e) {
        return e != null && e.getMessage() != null && e.getMessage().contains("nondeterministic");
    }

    private boolean isWorkflowTypeNotRegisterError(Exception e) {
        return e != null && e.getMessage() != null && e.getMessage().contains("Unknown workflow type");
    }

    private class HeartbeatDetail {
        private final ReplayWorkflowActivityResult replayResult;
        private final int replayExecutionIndex;

        public HeartbeatDetail(ReplayWorkflowActivityResult replayResult, int replayExecutionIndex) {
            this.replayResult = replayResult;
            this.replayExecutionIndex = replayExecutionIndex;
        }

        public ReplayWorkflowActivityResult getReplayResult() {
            return this.replayResult;
        }

        public int getReplayExecutionIndex() {
            return this.replayExecutionIndex;
        }
    }
}

