/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.shadowing;

import com.uber.cadence.BadRequestError;
import com.uber.cadence.ClientVersionNotSupportedError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.ListWorkflowExecutionsRequest;
import com.uber.cadence.ListWorkflowExecutionsResponse;
import com.uber.cadence.WorkflowExecutionInfo;
import com.uber.cadence.internal.common.RpcRetryer;
import com.uber.cadence.internal.shadowing.NonRetryableException;
import com.uber.cadence.internal.shadowing.ScanWorkflowActivity;
import com.uber.cadence.internal.shadowing.ScanWorkflowActivityParams;
import com.uber.cadence.internal.shadowing.ScanWorkflowActivityResult;
import com.uber.cadence.internal.shadowing.WorkflowExecution;
import com.uber.cadence.serviceclient.IWorkflowService;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScanWorkflowActivityImpl
implements ScanWorkflowActivity {
    private static final Logger log = LoggerFactory.getLogger(ScanWorkflowActivityImpl.class);
    private final IWorkflowService serviceClient;

    public ScanWorkflowActivityImpl(IWorkflowService serviceClient) {
        this.serviceClient = Objects.requireNonNull(serviceClient);
    }

    @Override
    public ScanWorkflowActivityResult scan(ScanWorkflowActivityParams params) throws Throwable {
        ListWorkflowExecutionsRequest scanRequest = new ListWorkflowExecutionsRequest().setDomain(params.getDomain()).setNextPageToken(params.getNextPageToken()).setPageSize(params.getPageSize()).setQuery(params.getWorkflowQuery());
        ListWorkflowExecutionsResponse resp = this.scanWorkflows(scanRequest);
        List<com.uber.cadence.WorkflowExecution> executions = this.samplingWorkflows(resp.getExecutions(), params.getSamplingRate());
        ScanWorkflowActivityResult result = new ScanWorkflowActivityResult();
        result.setExecutions(executions.stream().map(WorkflowExecution::new).collect(Collectors.toList()));
        result.setNextPageToken(resp.getNextPageToken());
        return result;
    }

    protected ListWorkflowExecutionsResponse scanWorkflows(ListWorkflowExecutionsRequest request) throws Throwable {
        try {
            return RpcRetryer.retryWithResult(RpcRetryer.DEFAULT_RPC_RETRY_OPTIONS, () -> this.serviceClient.ScanWorkflowExecutions(request));
        }
        catch (BadRequestError | ClientVersionNotSupportedError | EntityNotExistsError e) {
            log.error("failed to scan workflow records with non-retryable error. domain: " + request.getDomain() + "; query: " + request.getQuery(), (Throwable)e);
            throw new NonRetryableException(e);
        }
        catch (Throwable t) {
            log.error("failed to scan workflow records with domain: " + request.getDomain() + "; query: " + request.getQuery(), t);
            throw t;
        }
    }

    protected List<com.uber.cadence.WorkflowExecution> samplingWorkflows(List<WorkflowExecutionInfo> executionInfoList, double samplingRate) {
        int capacity = (int)((double)executionInfoList.size() * samplingRate);
        capacity = Math.max(capacity, 1);
        return ((Stream)executionInfoList.stream().unordered()).map(executionInfo -> executionInfo.getExecution()).limit(capacity).collect(Collectors.toList());
    }
}

