/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.sync.WorkflowInternal;
import com.uber.cadence.workflow.ContinueAsNewOptions;
import com.uber.cadence.workflow.QueryMethod;
import com.uber.cadence.workflow.SignalMethod;
import com.uber.cadence.workflow.WorkflowInterceptor;
import com.uber.cadence.workflow.WorkflowMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Optional;

class ContinueAsNewWorkflowInvocationHandler
implements InvocationHandler {
    private final ContinueAsNewOptions options;
    private final WorkflowInterceptor decisionContext;

    ContinueAsNewWorkflowInvocationHandler(ContinueAsNewOptions options, WorkflowInterceptor decisionContext) {
        this.options = options == null ? new ContinueAsNewOptions.Builder().build() : options;
        this.decisionContext = decisionContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        SignalMethod signalMethod;
        QueryMethod queryMethod;
        WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
        int count = (workflowMethod == null ? 0 : 1) + ((queryMethod = method.getAnnotation(QueryMethod.class)) == null ? 0 : 1) + ((signalMethod = method.getAnnotation(SignalMethod.class)) == null ? 0 : 1);
        if (count > 1) {
            throw new IllegalArgumentException(method + " must contain at most one annotation from @WorkflowMethod, @QueryMethod or @SignalMethod");
        }
        if (workflowMethod == null) {
            throw new IllegalStateException("ContinueAsNew Stub supports only calls to methods annotated with @WorkflowMethod");
        }
        String workflowType = InternalUtils.getWorkflowType(method, workflowMethod);
        WorkflowInternal.continueAsNew(Optional.of(workflowType), Optional.of(this.options), args, this.decisionContext);
        return InternalUtils.getValueOrDefault(null, method.getReturnType());
    }
}

