/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.sync.POJOActivityTaskHandler;
import com.uber.cadence.internal.worker.ActivityWorker;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.SuspendableWorker;
import com.uber.cadence.serviceclient.IWorkflowService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SyncActivityWorker
implements SuspendableWorker {
    private final ActivityWorker worker;
    private final POJOActivityTaskHandler taskHandler;
    private final ScheduledExecutorService heartbeatExecutor = Executors.newScheduledThreadPool(4);

    public SyncActivityWorker(IWorkflowService service, String domain, String taskList, SingleWorkerOptions options) {
        this.taskHandler = new POJOActivityTaskHandler(service, domain, options.getDataConverter(), this.heartbeatExecutor);
        this.worker = new ActivityWorker(service, domain, taskList, options, this.taskHandler);
    }

    public void setActivitiesImplementation(Object ... activitiesImplementation) {
        this.taskHandler.setActivitiesImplementation(activitiesImplementation);
    }

    @Override
    public void start() {
        this.worker.start();
    }

    @Override
    public boolean isStarted() {
        return this.worker.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.worker.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.worker.isTerminated() && this.heartbeatExecutor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.worker.shutdown();
        this.heartbeatExecutor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.worker.shutdownNow();
        this.heartbeatExecutor.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = unit.toMillis(timeout);
        timeoutMillis = InternalUtils.awaitTermination(this.worker, timeoutMillis);
        InternalUtils.awaitTermination(this.heartbeatExecutor, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.worker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.worker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.worker.isSuspended();
    }
}

