/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import com.uber.cadence.RefreshWorkflowTasksRequest;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.client.ActivityCompletionClient;
import com.uber.cadence.client.BatchRequest;
import com.uber.cadence.client.WorkflowClient;
import com.uber.cadence.client.WorkflowClientInterceptor;
import com.uber.cadence.client.WorkflowClientOptions;
import com.uber.cadence.client.WorkflowOptions;
import com.uber.cadence.client.WorkflowStub;
import com.uber.cadence.internal.external.GenericWorkflowClientExternal;
import com.uber.cadence.internal.external.GenericWorkflowClientExternalImpl;
import com.uber.cadence.internal.external.ManualActivityCompletionClientFactory;
import com.uber.cadence.internal.external.ManualActivityCompletionClientFactoryImpl;
import com.uber.cadence.internal.sync.ActivityCompletionClientImpl;
import com.uber.cadence.internal.sync.SignalWithStartBatchRequest;
import com.uber.cadence.internal.sync.WorkflowInvocationHandler;
import com.uber.cadence.internal.sync.WorkflowStubImpl;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.QueryMethod;
import com.uber.cadence.workflow.WorkflowMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.thrift.TException;

public final class WorkflowClientInternal
implements WorkflowClient {
    private final GenericWorkflowClientExternalImpl genericClient;
    private final ManualActivityCompletionClientFactory manualActivityCompletionClientFactory;
    private final WorkflowClientInterceptor[] interceptors;
    private final IWorkflowService workflowService;
    private final WorkflowClientOptions clientOptions;

    public static WorkflowClient newInstance(IWorkflowService service, WorkflowClientOptions options) {
        Objects.requireNonNull(service);
        Objects.requireNonNull(options);
        return new WorkflowClientInternal(service, options);
    }

    private WorkflowClientInternal(IWorkflowService service, WorkflowClientOptions options) {
        this.clientOptions = options;
        this.workflowService = service;
        this.genericClient = new GenericWorkflowClientExternalImpl(service, options.getDomain(), options.getMetricsScope());
        this.interceptors = options.getInterceptors();
        this.manualActivityCompletionClientFactory = new ManualActivityCompletionClientFactoryImpl(service, options.getDomain(), options.getDataConverter(), options.getMetricsScope());
    }

    @Override
    public WorkflowClientOptions getOptions() {
        return this.clientOptions;
    }

    @Override
    public IWorkflowService getService() {
        return this.workflowService;
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface) {
        return this.newWorkflowStub(workflowInterface, (WorkflowOptions)null);
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, WorkflowOptions options) {
        WorkflowClientInternal.checkAnnotation(workflowInterface, WorkflowMethod.class);
        WorkflowInvocationHandler invocationHandler = new WorkflowInvocationHandler(workflowInterface, this.clientOptions, (GenericWorkflowClientExternal)this.genericClient, options, this.interceptors);
        return (T)Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface}, (InvocationHandler)invocationHandler);
    }

    @SafeVarargs
    private static <T> void checkAnnotation(Class<T> workflowInterface, Class<? extends Annotation> ... annotationClasses) {
        TypeToken.TypeSet interfaces = TypeToken.of(workflowInterface).getTypes().interfaces();
        if (interfaces.isEmpty()) {
            throw new IllegalArgumentException("Workflow must implement at least one interface");
        }
        for (TypeToken i : interfaces) {
            for (Method method : i.getRawType().getMethods()) {
                for (Class<? extends Annotation> annotationClass : annotationClasses) {
                    Annotation workflowMethod = method.getAnnotation(annotationClass);
                    if (workflowMethod == null) continue;
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Workflow interface " + workflowInterface.getName() + " doesn't have method annotated with any of " + Arrays.toString(annotationClasses));
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, String workflowId) {
        return this.newWorkflowStub(workflowInterface, workflowId, Optional.empty());
    }

    @Override
    public <T> T newWorkflowStub(Class<T> workflowInterface, String workflowId, Optional<String> runId) {
        WorkflowClientInternal.checkAnnotation(workflowInterface, WorkflowMethod.class, QueryMethod.class);
        if (Strings.isNullOrEmpty((String)workflowId)) {
            throw new IllegalArgumentException("workflowId is null or empty");
        }
        WorkflowExecution execution = new WorkflowExecution();
        execution.setWorkflowId(workflowId);
        if (runId.isPresent()) {
            execution.setRunId(runId.get());
        }
        WorkflowInvocationHandler invocationHandler = new WorkflowInvocationHandler(workflowInterface, this.clientOptions, (GenericWorkflowClientExternal)this.genericClient, execution, this.interceptors);
        Object result = Proxy.newProxyInstance(workflowInterface.getClassLoader(), new Class[]{workflowInterface}, (InvocationHandler)invocationHandler);
        return (T)result;
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(String workflowType, WorkflowOptions options) {
        WorkflowStub result = new WorkflowStubImpl(this.clientOptions, (GenericWorkflowClientExternal)this.genericClient, workflowType, options);
        for (WorkflowClientInterceptor i : this.interceptors) {
            result = i.newUntypedWorkflowStub(workflowType, options, result);
        }
        return result;
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(String workflowId, Optional<String> runId, Optional<String> workflowType) {
        WorkflowExecution execution = new WorkflowExecution().setWorkflowId(workflowId);
        if (runId.isPresent()) {
            execution.setRunId(runId.get());
        }
        return this.newUntypedWorkflowStub(execution, workflowType);
    }

    @Override
    public WorkflowStub newUntypedWorkflowStub(WorkflowExecution execution, Optional<String> workflowType) {
        return new WorkflowStubImpl(this.clientOptions, (GenericWorkflowClientExternal)this.genericClient, workflowType, execution);
    }

    @Override
    public ActivityCompletionClient newActivityCompletionClient() {
        ActivityCompletionClient result = new ActivityCompletionClientImpl(this.manualActivityCompletionClientFactory);
        for (WorkflowClientInterceptor i : this.interceptors) {
            result = i.newActivityCompletionClient(result);
        }
        return result;
    }

    @Override
    public BatchRequest newSignalWithStartRequest() {
        return new SignalWithStartBatchRequest();
    }

    @Override
    public WorkflowExecution signalWithStart(BatchRequest signalWithStartBatch) {
        return ((SignalWithStartBatchRequest)signalWithStartBatch).invoke();
    }

    @Override
    public void refreshWorkflowTasks(RefreshWorkflowTasksRequest refreshWorkflowTasksRequest) throws TException {
        this.workflowService.RefreshWorkflowTasks(refreshWorkflowTasksRequest);
    }

    public static WorkflowExecution start(Functions.Proc workflow) {
        WorkflowInvocationHandler.initAsyncInvocation(WorkflowInvocationHandler.InvocationType.START);
        try {
            workflow.apply();
            WorkflowExecution workflowExecution = WorkflowInvocationHandler.getAsyncInvocationResult(WorkflowExecution.class);
            return workflowExecution;
        }
        finally {
            WorkflowInvocationHandler.closeAsyncInvocation();
        }
    }

    public static <A1> WorkflowExecution start(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1));
    }

    public static <A1, A2> WorkflowExecution start(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3> WorkflowExecution start(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4> WorkflowExecution start(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5> WorkflowExecution start(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6> WorkflowExecution start(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static <R> WorkflowExecution start(Functions.Func<R> workflow) {
        return WorkflowClientInternal.start(() -> workflow.apply());
    }

    public static <A1, R> WorkflowExecution start(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1));
    }

    public static <A1, A2, R> WorkflowExecution start(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3, R> WorkflowExecution start(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4, R> WorkflowExecution start(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5, R> WorkflowExecution start(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6, R> WorkflowExecution start(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.start(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static CompletableFuture<Void> execute(Functions.Proc workflow) {
        WorkflowInvocationHandler.initAsyncInvocation(WorkflowInvocationHandler.InvocationType.EXECUTE);
        try {
            workflow.apply();
            CompletableFuture completableFuture = WorkflowInvocationHandler.getAsyncInvocationResult(CompletableFuture.class);
            return completableFuture;
        }
        finally {
            WorkflowInvocationHandler.closeAsyncInvocation();
        }
    }

    public static <A1> CompletableFuture<Void> execute(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1));
    }

    public static <A1, A2> CompletableFuture<Void> execute(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3> CompletableFuture<Void> execute(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4> CompletableFuture<Void> execute(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5> CompletableFuture<Void> execute(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6> CompletableFuture<Void> execute(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }

    public static <R> CompletableFuture<R> execute(Functions.Func<R> workflow) {
        return WorkflowClientInternal.execute(() -> workflow.apply());
    }

    public static <A1, R> CompletableFuture<R> execute(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1));
    }

    public static <A1, A2, R> CompletableFuture<R> execute(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2));
    }

    public static <A1, A2, A3, R> CompletableFuture<R> execute(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3));
    }

    public static <A1, A2, A3, A4, R> CompletableFuture<R> execute(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4));
    }

    public static <A1, A2, A3, A4, A5, R> CompletableFuture<R> execute(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5));
    }

    public static <A1, A2, A3, A4, A5, A6, R> CompletableFuture<R> execute(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternal.execute(() -> workflow.apply(arg1, arg2, arg3, arg4, arg5, arg6));
    }
}

