/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.internal.sync.WorkflowThread;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.QueueConsumer;
import com.uber.cadence.workflow.WorkflowQueue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;

final class WorkflowQueueImpl<E>
implements WorkflowQueue<E> {
    private final Deque<E> queue = new ArrayDeque();
    private final int capacity;

    public WorkflowQueueImpl(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity less than 1: " + capacity);
        }
        this.capacity = capacity;
    }

    @Override
    public E take() throws InterruptedException {
        WorkflowThread.await("WorkflowQueue.take", () -> !this.queue.isEmpty());
        return this.queue.pollLast();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        WorkflowThread.await(unit.toMillis(timeout), "WorkflowQueue.poll", () -> !this.queue.isEmpty());
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.remove();
    }

    @Override
    public boolean offer(E e) {
        if (this.queue.size() == this.capacity) {
            return false;
        }
        this.queue.addLast(e);
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (this.queue.size() >= this.capacity) {
            WorkflowThread.await("WorkflowQueue.put", () -> this.queue.size() < this.capacity);
        }
        this.queue.addLast(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        boolean timedOut = WorkflowThread.await(unit.toMillis(timeout), "WorkflowQueue.offer", () -> this.queue.size() < this.capacity);
        if (timedOut) {
            return false;
        }
        this.queue.addLast(e);
        return true;
    }

    @Override
    public <R> QueueConsumer<R> map(Functions.Func1<? super E, ? extends R> mapper) {
        return new MappedQueueConsumer<R, E>(this, mapper);
    }

    private static class MappedQueueConsumer<R, E>
    implements QueueConsumer<R> {
        private QueueConsumer<E> source;
        private final Functions.Func1<? super E, ? extends R> mapper;

        public MappedQueueConsumer(QueueConsumer<E> source, Functions.Func1<? super E, ? extends R> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public R take() throws InterruptedException {
            E element = this.source.take();
            try {
                return this.mapper.apply(element);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure mapping an element", e);
            }
        }

        @Override
        public R poll(long timeout, TimeUnit unit) throws InterruptedException {
            E element = this.source.poll(timeout, unit);
            try {
                if (element == null) {
                    return null;
                }
                return this.mapper.apply(element);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure mapping an element", e);
            }
        }

        @Override
        public <R1> QueueConsumer<R1> map(Functions.Func1<? super R, ? extends R1> mapper) {
            return new MappedQueueConsumer<R1, R>(this, mapper);
        }
    }
}

