/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.workflow.CompletablePromise;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class WorkflowTimers {
    private final SortedMap<Long, Timers> timers = new TreeMap<Long, Timers>();

    WorkflowTimers() {
    }

    public void addTimer(long fireTime, CompletablePromise<Void> result) {
        Timers t = (Timers)this.timers.get(fireTime);
        if (t == null) {
            t = new Timers(fireTime);
            this.timers.put(fireTime, t);
        }
        t.addTimer(result);
    }

    public void removeTimer(long fireTime, CompletablePromise<Void> result) {
        Timers t = (Timers)this.timers.get(fireTime);
        if (t == null) {
            throw new Error("Unknown timer");
        }
        t.remove(result);
        if (t.isEmpty()) {
            this.timers.remove(fireTime);
        }
    }

    public boolean hasTimersToFire(long currentTime) {
        return !this.timers.isEmpty() && this.timers.firstKey() <= currentTime;
    }

    public void fireTimers(long currentTime) {
        boolean newTimersAdded;
        boolean fired = false;
        do {
            ArrayList<Timers> toFire = new ArrayList<Timers>();
            for (Map.Entry<Long, Timers> pair : this.timers.entrySet()) {
                if (pair.getKey() > currentTime) break;
                toFire.add(pair.getValue());
            }
            int beforeSize = this.timers.size() - toFire.size();
            for (Timers t : toFire) {
                t.fire();
                this.timers.remove(t.fireTime);
            }
            newTimersAdded = this.timers.size() > beforeSize;
            boolean bl = fired = fired || !toFire.isEmpty();
        } while (newTimersAdded);
    }

    public long getNextFireTime() {
        if (this.timers.isEmpty()) {
            return 0L;
        }
        return this.timers.firstKey();
    }

    private static class Timers {
        private final Set<CompletablePromise<Void>> results = new HashSet<CompletablePromise<Void>>();
        private final long fireTime;

        private Timers(long fireTime) {
            this.fireTime = fireTime;
        }

        void addTimer(CompletablePromise<Void> result) {
            this.results.add(result);
            result.handle((r, failure) -> {
                if (failure != null) {
                    this.results.remove(result);
                    throw failure;
                }
                return r;
            });
        }

        void fire() {
            for (CompletablePromise<Void> t : this.results) {
                t.complete(null);
            }
        }

        public void remove(CompletablePromise<Void> result) {
            this.results.remove(result);
        }

        public boolean isEmpty() {
            return this.results.isEmpty();
        }
    }
}

