/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.google.common.base.Throwables;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.internal.testservice.WorkflowId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

final class ExecutionId {
    private final String domain;
    private final WorkflowExecution execution;

    ExecutionId(String domain, WorkflowExecution execution) {
        this.domain = Objects.requireNonNull(domain);
        this.execution = Objects.requireNonNull(execution);
    }

    ExecutionId(String domain, String workflowId, String runId) {
        this(domain, new WorkflowExecution().setWorkflowId(Objects.requireNonNull(workflowId)).setRunId(runId));
    }

    public String getDomain() {
        return this.domain;
    }

    public WorkflowExecution getExecution() {
        return this.execution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionId that = (ExecutionId)o;
        if (!this.domain.equals(that.domain)) {
            return false;
        }
        return this.execution.equals(that.execution);
    }

    public int hashCode() {
        int result = this.domain.hashCode();
        result = 31 * result + this.execution.hashCode();
        return result;
    }

    public String toString() {
        return "ExecutionId{domain='" + this.domain + '\'' + ", execution=" + this.execution + '}';
    }

    byte[] toBytes() throws InternalServiceError {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            this.addBytes(out);
        }
        catch (IOException e) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
        }
        return bout.toByteArray();
    }

    void addBytes(DataOutputStream out) throws IOException {
        out.writeUTF(this.domain);
        out.writeUTF(this.execution.getWorkflowId());
        if (this.execution.getRunId() != null) {
            out.writeUTF(this.execution.getRunId());
        }
    }

    static ExecutionId fromBytes(byte[] serialized) throws InternalServiceError {
        ByteArrayInputStream bin = new ByteArrayInputStream(serialized);
        DataInputStream in = new DataInputStream(bin);
        try {
            return ExecutionId.readFromBytes(in);
        }
        catch (IOException e) {
            throw new InternalServiceError(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    static ExecutionId readFromBytes(DataInputStream in) throws IOException {
        String domain = in.readUTF();
        String workflowId = in.readUTF();
        String runId = null;
        if (in.available() > 0) {
            runId = in.readUTF();
        }
        return new ExecutionId(domain, workflowId, runId);
    }

    public WorkflowId getWorkflowId() {
        return new WorkflowId(this.domain, this.execution.getWorkflowId());
    }
}

