/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.testservice;

import com.uber.cadence.BadRequestError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.testservice.ExecutionId;
import com.uber.cadence.internal.testservice.TestWorkflowMutableState;
import com.uber.cadence.internal.testservice.TestWorkflowStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;

final class RequestContext {
    private final LongSupplier clock;
    private final ExecutionId executionId;
    private final TestWorkflowMutableState workflowMutableState;
    private final long initialEventId;
    private final List<HistoryEvent> events = new ArrayList<HistoryEvent>();
    private final List<CommitCallback> commitCallbacks = new ArrayList<CommitCallback>();
    private TestWorkflowStore.DecisionTask decisionTask;
    private final List<TestWorkflowStore.ActivityTask> activityTasks = new ArrayList<TestWorkflowStore.ActivityTask>();
    private final List<Timer> timers = new ArrayList<Timer>();
    private long workflowCompletedAtEventId = -1L;
    private boolean needDecision;
    private int timerLocks;

    RequestContext(LongSupplier clock, TestWorkflowMutableState workflowMutableState, long initialEventId) {
        this.clock = Objects.requireNonNull(clock);
        this.workflowMutableState = Objects.requireNonNull(workflowMutableState);
        this.executionId = Objects.requireNonNull(workflowMutableState.getExecutionId());
        this.initialEventId = initialEventId;
    }

    void add(RequestContext ctx) {
        this.activityTasks.addAll(ctx.getActivityTasks());
        this.timers.addAll(ctx.getTimers());
        this.events.addAll(ctx.getEvents());
    }

    void lockTimer() {
        ++this.timerLocks;
    }

    void unlockTimer() {
        --this.timerLocks;
    }

    int getTimerLocks() {
        return this.timerLocks;
    }

    void clearTimersAndLocks() {
        this.timerLocks = 0;
        this.timers.clear();
    }

    long currentTimeInNanoseconds() {
        return TimeUnit.MILLISECONDS.toNanos(this.clock.getAsLong());
    }

    long addEvent(HistoryEvent event) {
        long eventId = this.initialEventId + (long)this.events.size();
        if (WorkflowExecutionUtils.isWorkflowExecutionCompletedEvent(event)) {
            this.workflowCompletedAtEventId = eventId;
        } else if (this.workflowCompletedAtEventId > 0L && this.workflowCompletedAtEventId < eventId) {
            throw new IllegalStateException("Event added after the workflow completion event");
        }
        this.events.add(event);
        return eventId;
    }

    WorkflowExecution getExecution() {
        return this.executionId.getExecution();
    }

    public TestWorkflowMutableState getWorkflowMutableState() {
        return this.workflowMutableState;
    }

    String getDomain() {
        return this.executionId.getDomain();
    }

    public long getInitialEventId() {
        return this.initialEventId;
    }

    public long getNextEventId() {
        return this.initialEventId + (long)this.events.size();
    }

    void setNeedDecision(boolean needDecision) {
        this.needDecision = needDecision;
    }

    boolean isNeedDecision() {
        return this.needDecision;
    }

    void setDecisionTask(TestWorkflowStore.DecisionTask decisionTask) {
        this.decisionTask = Objects.requireNonNull(decisionTask);
    }

    void addActivityTask(TestWorkflowStore.ActivityTask activityTask) {
        this.activityTasks.add(activityTask);
    }

    void addTimer(long delaySeconds, Runnable callback, String name) {
        Timer timer = new Timer(delaySeconds, callback, name);
        this.timers.add(timer);
    }

    public List<Timer> getTimers() {
        return this.timers;
    }

    List<TestWorkflowStore.ActivityTask> getActivityTasks() {
        return this.activityTasks;
    }

    TestWorkflowStore.DecisionTask getDecisionTask() {
        return this.decisionTask;
    }

    List<HistoryEvent> getEvents() {
        return this.events;
    }

    void onCommit(CommitCallback callback) {
        this.commitCallbacks.add(callback);
    }

    long commitChanges(TestWorkflowStore store) throws InternalServiceError, EntityNotExistsError, BadRequestError {
        return store.save(this);
    }

    void fireCallbacks(int historySize) throws InternalServiceError, BadRequestError {
        for (CommitCallback callback : this.commitCallbacks) {
            callback.apply(historySize);
        }
    }

    ExecutionId getExecutionId() {
        return this.executionId;
    }

    public boolean isEmpty() {
        return this.events.isEmpty() && this.activityTasks.isEmpty() && this.decisionTask == null && this.timers.isEmpty();
    }

    static final class Timer {
        private final long delaySeconds;
        private final Runnable callback;
        private final String taskInfo;

        Timer(long delaySeconds, Runnable callback, String taskInfo) {
            this.delaySeconds = delaySeconds;
            this.callback = callback;
            this.taskInfo = taskInfo;
        }

        long getDelaySeconds() {
            return this.delaySeconds;
        }

        Runnable getCallback() {
            return this.callback;
        }

        String getTaskInfo() {
            return this.taskInfo;
        }
    }

    @FunctionalInterface
    static interface CommitCallback {
        public void apply(int var1) throws InternalServiceError, BadRequestError;
    }
}

