/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.internal.worker.LocalActivityWorker;
import com.uber.cadence.internal.worker.Poller;
import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.thrift.TException;

final class LocalActivityPollTask
implements Poller.PollTask<LocalActivityWorker.Task>,
BiFunction<LocalActivityWorker.Task, Duration, Boolean> {
    private static final int QUEUE_SIZE = 1000;
    private BlockingQueue<LocalActivityWorker.Task> pendingTasks = new ArrayBlockingQueue<LocalActivityWorker.Task>(1000);

    LocalActivityPollTask() {
    }

    @Override
    public LocalActivityWorker.Task poll() throws TException {
        try {
            return this.pendingTasks.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("local activity poll task interrupted", e);
        }
    }

    @Override
    public Boolean apply(LocalActivityWorker.Task task, Duration maxWaitAllowed) {
        try {
            this.pendingTasks.offer(task, maxWaitAllowed.toMillis(), TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

