/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.google.common.base.Strings;
import com.uber.cadence.ActivityLocalDispatchInfo;
import com.uber.cadence.Decision;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.History;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedResponse;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RespondQueryTaskCompletedRequest;
import com.uber.cadence.ScheduleActivityTaskDecisionAttributes;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.WorkflowQuery;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.common.BinaryChecksum;
import com.uber.cadence.common.WorkflowExecutionHistory;
import com.uber.cadence.internal.common.RpcRetryer;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.internal.worker.DecisionTaskHandler;
import com.uber.cadence.internal.worker.LocallyDispatchedActivityWorker;
import com.uber.cadence.internal.worker.PollTaskExecutor;
import com.uber.cadence.internal.worker.Poller;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import com.uber.cadence.internal.worker.SuspendableWorkerBase;
import com.uber.cadence.internal.worker.WorkflowPollTask;
import com.uber.cadence.internal.worker.WorkflowRunLockManager;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.thrift.TException;
import org.slf4j.MDC;

public final class WorkflowWorker
extends SuspendableWorkerBase
implements Consumer<PollForDecisionTaskResponse> {
    private static final String POLL_THREAD_NAME_PREFIX = "Workflow Poller taskList=";
    private final DecisionTaskHandler handler;
    private final IWorkflowService service;
    private final String domain;
    private final String taskList;
    private final SingleWorkerOptions options;
    private final String stickyTaskListName;
    private final WorkflowRunLockManager runLocks = new WorkflowRunLockManager();
    private final Function<LocallyDispatchedActivityWorker.Task, Boolean> ldaTaskPoller;
    private PollTaskExecutor<PollForDecisionTaskResponse> pollTaskExecutor;

    public WorkflowWorker(IWorkflowService service, String domain, String taskList, SingleWorkerOptions options, DecisionTaskHandler handler, Function<LocallyDispatchedActivityWorker.Task, Boolean> ldaTaskPoller, String stickyTaskListName) {
        this.service = Objects.requireNonNull(service);
        this.domain = Objects.requireNonNull(domain);
        this.taskList = Objects.requireNonNull(taskList);
        this.handler = handler;
        this.ldaTaskPoller = ldaTaskPoller;
        this.stickyTaskListName = stickyTaskListName;
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix("Workflow Poller taskList=\"" + taskList + "\", domain=\"" + domain + "\"").build();
        }
        this.options = SingleWorkerOptions.newBuilder(options).setPollerOptions(pollerOptions).build();
    }

    @Override
    public void start() {
        if (this.handler.isAnyTypeSupported()) {
            this.pollTaskExecutor = new PollTaskExecutor<PollForDecisionTaskResponse>(this.domain, this.taskList, this.options, new TaskHandlerImpl(this.handler));
            Poller<PollForDecisionTaskResponse> poller = new Poller<PollForDecisionTaskResponse>(this.options.getIdentity(), new WorkflowPollTask(this.service, this.domain, this.taskList, this.options.getMetricsScope(), this.options.getIdentity()), this.pollTaskExecutor, this.options.getPollerOptions(), this.options.getMetricsScope());
            poller.start();
            this.setPoller(poller);
            this.options.getMetricsScope().counter("cadence-worker-start").inc(1L);
        }
    }

    public byte[] queryWorkflowExecution(WorkflowExecution exec, String queryType, byte[] args) throws Exception {
        GetWorkflowExecutionHistoryResponse historyResponse = WorkflowExecutionUtils.getHistoryPage(null, this.service, this.domain, exec);
        History history = historyResponse.getHistory();
        WorkflowExecutionHistory workflowExecutionHistory = new WorkflowExecutionHistory(history.getEvents());
        return this.queryWorkflowExecution(queryType, args, workflowExecutionHistory, historyResponse.getNextPageToken());
    }

    public byte[] queryWorkflowExecution(String jsonSerializedHistory, String queryType, byte[] args) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        return this.queryWorkflowExecution(queryType, args, history, null);
    }

    public byte[] queryWorkflowExecution(WorkflowExecutionHistory history, String queryType, byte[] args) throws Exception {
        return this.queryWorkflowExecution(queryType, args, history, null);
    }

    private byte[] queryWorkflowExecution(String queryType, byte[] args, WorkflowExecutionHistory history, byte[] nextPageToken) throws Exception {
        PollForDecisionTaskResponse task = new PollForDecisionTaskResponse();
        task.setWorkflowExecution(history.getWorkflowExecution());
        task.setStartedEventId(Long.MAX_VALUE);
        task.setPreviousStartedEventId(Long.MAX_VALUE);
        task.setNextPageToken(nextPageToken);
        WorkflowQuery query = new WorkflowQuery();
        query.setQueryType(queryType).setQueryArgs(args);
        task.setQuery(query);
        List<HistoryEvent> events = history.getEvents();
        HistoryEvent startedEvent = events.get(0);
        WorkflowExecutionStartedEventAttributes started = startedEvent.getWorkflowExecutionStartedEventAttributes();
        if (started == null) {
            throw new IllegalStateException("First event of the history is not WorkflowExecutionStarted: " + startedEvent);
        }
        WorkflowType workflowType = started.getWorkflowType();
        task.setWorkflowType(workflowType);
        task.setHistory(new History().setEvents(events));
        DecisionTaskHandler.Result result = this.handler.handleDecisionTask(task);
        if (result.getQueryCompleted() != null) {
            RespondQueryTaskCompletedRequest r = result.getQueryCompleted();
            if (r.getErrorMessage() != null) {
                throw new RuntimeException("query failure for " + history.getWorkflowExecution() + ", queryType=" + queryType + ", args=" + Arrays.toString(args) + ", error=" + r.getErrorMessage());
            }
            return r.getQueryResult();
        }
        throw new RuntimeException("Query returned wrong response: " + result);
    }

    @Override
    public void accept(PollForDecisionTaskResponse pollForDecisionTaskResponse) {
        this.pollTaskExecutor.process(pollForDecisionTaskResponse);
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<PollForDecisionTaskResponse> {
        final DecisionTaskHandler handler;

        private TaskHandlerImpl(DecisionTaskHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PollForDecisionTaskResponse task) throws Exception {
            Scope metricsScope = WorkflowWorker.this.options.getMetricsScope().tagged((Map)ImmutableMap.of((Object)"WorkflowType", (Object)task.getWorkflowType().getName()));
            MDC.put((String)"WorkflowID", (String)task.getWorkflowExecution().getWorkflowId());
            MDC.put((String)"WorkflowType", (String)task.getWorkflowType().getName());
            MDC.put((String)"RunID", (String)task.getWorkflowExecution().getRunId());
            Lock runLock = null;
            if (!Strings.isNullOrEmpty((String)WorkflowWorker.this.stickyTaskListName)) {
                runLock = WorkflowWorker.this.runLocks.getLockForLocking(task.getWorkflowExecution().getRunId());
                runLock.lock();
            }
            try {
                Stopwatch sw = metricsScope.timer("cadence-decision-execution-latency").start();
                DecisionTaskHandler.Result response = this.handler.handleDecisionTask(task);
                sw.stop();
                sw = metricsScope.timer("cadence-decision-response-latency").start();
                this.sendReply(WorkflowWorker.this.service, task, response);
                sw.stop();
                metricsScope.counter("cadence-decision-task-completed").inc(1L);
            }
            finally {
                MDC.remove((String)"WorkflowID");
                MDC.remove((String)"WorkflowType");
                MDC.remove((String)"RunID");
                if (runLock != null) {
                    WorkflowWorker.this.runLocks.unlock(task.getWorkflowExecution().getRunId());
                }
            }
        }

        @Override
        public Throwable wrapFailure(PollForDecisionTaskResponse task, Throwable failure) {
            WorkflowExecution execution = task.getWorkflowExecution();
            return new RuntimeException("Failure processing decision task. WorkflowID=" + execution.getWorkflowId() + ", RunID=" + execution.getRunId(), failure);
        }

        private void sendReply(IWorkflowService service, PollForDecisionTaskResponse task, DecisionTaskHandler.Result response) throws TException {
            RespondDecisionTaskCompletedRequest taskCompleted = response.getTaskCompleted();
            if (taskCompleted != null) {
                taskCompleted.setIdentity(WorkflowWorker.this.options.getIdentity());
                taskCompleted.setTaskToken(task.getTaskToken());
                taskCompleted.setBinaryChecksum(BinaryChecksum.getBinaryChecksum());
                RpcRetryer.retry(() -> {
                    RespondDecisionTaskCompletedResponse taskCompletedResponse = null;
                    ArrayList<LocallyDispatchedActivityWorker.Task> activityTasks = new ArrayList<LocallyDispatchedActivityWorker.Task>();
                    try {
                        if (WorkflowWorker.this.ldaTaskPoller != null) {
                            for (Decision decision : taskCompleted.getDecisions()) {
                                ScheduleActivityTaskDecisionAttributes attr = decision.getScheduleActivityTaskDecisionAttributes();
                                if (attr == null || !WorkflowWorker.this.taskList.equals(attr.getTaskList().getName())) continue;
                                LocallyDispatchedActivityWorker.Task activityTask = new LocallyDispatchedActivityWorker.Task(attr.getActivityId(), attr.getActivityType(), attr.bufferForInput(), attr.getScheduleToCloseTimeoutSeconds(), attr.getStartToCloseTimeoutSeconds(), attr.getHeartbeatTimeoutSeconds(), task.getWorkflowType(), WorkflowWorker.this.domain, attr.getHeader(), task.getWorkflowExecution());
                                if (((Boolean)WorkflowWorker.this.ldaTaskPoller.apply(activityTask)).booleanValue()) {
                                    WorkflowWorker.this.options.getMetricsScope().counter("cadence-activity-local-dispatch-succeed").inc(1L);
                                    decision.getScheduleActivityTaskDecisionAttributes().setRequestLocalDispatch(true);
                                    activityTasks.add(activityTask);
                                    continue;
                                }
                                WorkflowWorker.this.options.getMetricsScope().counter("cadence-activity-local-dispatch-failed").inc(1L);
                            }
                        }
                        taskCompletedResponse = service.RespondDecisionTaskCompleted(taskCompleted);
                    }
                    catch (Throwable throwable) {
                        for (LocallyDispatchedActivityWorker.Task activityTask : activityTasks) {
                            ActivityLocalDispatchInfo activityLocalDispatchInfo;
                            boolean started = false;
                            if (taskCompletedResponse != null && taskCompletedResponse.getActivitiesToDispatchLocally() != null && (activityLocalDispatchInfo = (ActivityLocalDispatchInfo)taskCompletedResponse.getActivitiesToDispatchLocally().getOrDefault(activityTask.activityId, null)) != null) {
                                activityTask.scheduledTimestamp = activityLocalDispatchInfo.getScheduledTimestamp();
                                activityTask.startedTimestamp = activityLocalDispatchInfo.getStartedTimestamp();
                                activityTask.scheduledTimestampOfThisAttempt = activityLocalDispatchInfo.getScheduledTimestampOfThisAttempt();
                                activityTask.taskToken = activityLocalDispatchInfo.bufferForTaskToken();
                                started = true;
                            }
                            activityTask.notify(started);
                        }
                        throw throwable;
                    }
                    for (LocallyDispatchedActivityWorker.Task activityTask : activityTasks) {
                        ActivityLocalDispatchInfo activityLocalDispatchInfo;
                        boolean started = false;
                        if (taskCompletedResponse != null && taskCompletedResponse.getActivitiesToDispatchLocally() != null && (activityLocalDispatchInfo = (ActivityLocalDispatchInfo)taskCompletedResponse.getActivitiesToDispatchLocally().getOrDefault(activityTask.activityId, null)) != null) {
                            activityTask.scheduledTimestamp = activityLocalDispatchInfo.getScheduledTimestamp();
                            activityTask.startedTimestamp = activityLocalDispatchInfo.getStartedTimestamp();
                            activityTask.scheduledTimestampOfThisAttempt = activityLocalDispatchInfo.getScheduledTimestampOfThisAttempt();
                            activityTask.taskToken = activityLocalDispatchInfo.bufferForTaskToken();
                            started = true;
                        }
                        activityTask.notify(started);
                    }
                });
            } else {
                RespondDecisionTaskFailedRequest taskFailed = response.getTaskFailed();
                if (taskFailed != null) {
                    taskFailed.setIdentity(WorkflowWorker.this.options.getIdentity());
                    taskFailed.setTaskToken(task.getTaskToken());
                    taskFailed.setBinaryChecksum(BinaryChecksum.getBinaryChecksum());
                    RpcRetryer.retry(() -> service.RespondDecisionTaskFailed(taskFailed));
                } else {
                    RespondQueryTaskCompletedRequest queryCompleted = response.getQueryCompleted();
                    if (queryCompleted != null) {
                        queryCompleted.setTaskToken(task.getTaskToken());
                        service.RespondQueryTaskCompleted(queryCompleted);
                    }
                }
            }
        }
    }
}

