/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.testing;

import com.google.common.annotations.VisibleForTesting;
import com.uber.cadence.internal.shadowing.ReplayWorkflowActivity;
import com.uber.cadence.internal.shadowing.ReplayWorkflowActivityImpl;
import com.uber.cadence.internal.shadowing.ReplayWorkflowActivityResult;
import com.uber.cadence.internal.shadowing.ScanWorkflowActivity;
import com.uber.cadence.internal.shadowing.ScanWorkflowActivityImpl;
import com.uber.cadence.internal.shadowing.ScanWorkflowActivityParams;
import com.uber.cadence.internal.shadowing.ScanWorkflowActivityResult;
import com.uber.cadence.internal.shadowing.WorkflowExecution;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.shadower.Mode;
import com.uber.cadence.testing.TestEnvironmentOptions;
import com.uber.cadence.worker.ShadowingOptions;
import com.uber.cadence.worker.WorkflowImplementationOptions;
import com.uber.cadence.workflow.Functions;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class WorkflowShadower {
    private static final long SLEEP_INTERVAL = 300L;
    private final ShadowingOptions options;
    private final String query;
    private final ScanWorkflowActivity scanWorkflow;
    private final ReplayWorkflowActivity replayWorkflow;

    public WorkflowShadower(IWorkflowService service, ShadowingOptions options, String taskList) {
        this(service, options, taskList, (Scope)new NoopScope());
    }

    public WorkflowShadower(IWorkflowService service, ShadowingOptions options, String taskList, Scope metricsScope, TestEnvironmentOptions testOptions) {
        this(options, new ScanWorkflowActivityImpl(service), new ReplayWorkflowActivityImpl(service, metricsScope, taskList, testOptions));
    }

    public WorkflowShadower(IWorkflowService service, ShadowingOptions options, String taskList, Scope metricsScope) {
        this(options, new ScanWorkflowActivityImpl(service), new ReplayWorkflowActivityImpl(service, metricsScope, taskList));
    }

    @VisibleForTesting
    public WorkflowShadower(ShadowingOptions options, ScanWorkflowActivity scanWorkflow, ReplayWorkflowActivity replayWorkflow) {
        this.options = this.validateShadowingOptions(options);
        this.query = options.getWorkflowQuery();
        this.scanWorkflow = scanWorkflow;
        this.replayWorkflow = replayWorkflow;
    }

    public void run() throws Throwable {
        byte[] nextPageToken = null;
        int replayCount = 0;
        int maxReplayCount = Integer.MAX_VALUE;
        Duration maxReplayDuration = Duration.ZERO;
        ZonedDateTime now = ZonedDateTime.now();
        if (this.options.getExitCondition() != null) {
            if (this.options.getExitCondition().getShadowCount() != 0) {
                maxReplayCount = this.options.getExitCondition().getShadowCount();
            }
            if (this.options.getExitCondition().getExpirationIntervalInSeconds() != 0) {
                maxReplayDuration = Duration.ofSeconds(this.options.getExitCondition().getExpirationIntervalInSeconds());
            }
        }
        do {
            ScanWorkflowActivityParams params = new ScanWorkflowActivityParams();
            params.setDomain(this.options.getDomain());
            params.setWorkflowQuery(this.query);
            params.setSamplingRate(this.options.getSamplingRate());
            params.setNextPageToken(nextPageToken);
            ScanWorkflowActivityResult scanResult = this.scanWorkflow.scan(params);
            nextPageToken = scanResult.getNextPageToken();
            for (WorkflowExecution execution : scanResult.getExecutions()) {
                ReplayWorkflowActivityResult replayResult = this.replayWorkflow.replayOneExecution(this.options.getDomain(), execution);
                if (replayResult.getFailed() > 0) {
                    throw new Error("Replay workflow history failed with execution:" + execution.toString());
                }
                if (replayResult.getSucceeded() > 0) {
                    ++replayCount;
                }
                if (replayCount >= maxReplayCount) {
                    return;
                }
                if (maxReplayDuration.isZero() || !ZonedDateTime.now().isAfter(now.plusSeconds(maxReplayDuration.getSeconds()))) continue;
                return;
            }
            if (nextPageToken != null || this.options.getShadowMode() != Mode.Continuous) continue;
            Thread.sleep(300L);
        } while (nextPageToken != null && this.options.getShadowMode() == Mode.Normal);
    }

    public void registerWorkflowImplementationTypes(Class<?> ... workflowImplementationClasses) {
        this.replayWorkflow.registerWorkflowImplementationTypes(workflowImplementationClasses);
    }

    public void registerWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?> ... workflowImplementationClasses) {
        this.replayWorkflow.registerWorkflowImplementationTypesWithOptions(options, workflowImplementationClasses);
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> workflowInterface, Functions.Func<R> factory) {
        this.replayWorkflow.addWorkflowImplementationFactoryWithOptions(options, workflowInterface, factory);
    }

    public <R> void addWorkflowImplementationFactory(Class<R> workflowInterface, Functions.Func<R> factory) {
        this.replayWorkflow.addWorkflowImplementationFactory(workflowInterface, factory);
    }

    private ShadowingOptions validateShadowingOptions(ShadowingOptions options) {
        Objects.requireNonNull(options);
        if (options.getConcurrency() > 1) {
            throw new IllegalArgumentException("Concurrency is not supported in workflow shadower");
        }
        return options;
    }
}

