/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.worker;

import java.time.ZonedDateTime;
import java.util.Objects;

public class TimeFilter {
    private static final TimeFilter DEFAULT_INSTANCE = TimeFilter.newBuilder().build();
    private final ZonedDateTime minTimestamp;
    private final ZonedDateTime maxTimestamp;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(TimeFilter options) {
        return new Builder(options);
    }

    public static TimeFilter defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private TimeFilter(ZonedDateTime minTimestamp, ZonedDateTime maxTimestamp) {
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
    }

    public ZonedDateTime getMinTimestamp() {
        return this.minTimestamp;
    }

    public ZonedDateTime getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public boolean isEmpty() {
        return this.minTimestamp == null && this.maxTimestamp == null;
    }

    public String toString() {
        return "TimeFilter{minTimestamp=" + this.minTimestamp + ", maxTimestamp=" + this.maxTimestamp + '}';
    }

    public static final class Builder {
        private ZonedDateTime minTimestamp;
        private ZonedDateTime maxTimestamp;

        private Builder() {
        }

        private Builder(TimeFilter options) {
            this.minTimestamp = options.minTimestamp;
            this.maxTimestamp = options.maxTimestamp;
        }

        public Builder setMinTimestamp(ZonedDateTime minTimestamp) {
            this.minTimestamp = Objects.requireNonNull(minTimestamp);
            return this;
        }

        public Builder setMaxTimestamp(ZonedDateTime maxTimestamp) {
            this.maxTimestamp = Objects.requireNonNull(maxTimestamp);
            return this;
        }

        public TimeFilter build() {
            return new TimeFilter(this.minTimestamp, this.maxTimestamp);
        }
    }
}

